{
    "_source": false,
    "query": {
        "bool": {
            <#if applicationCodes??>
            "must": [
                {
                    "terms": {
                        "application_code.keyword": [<#list applicationCodes as item>"${item}"<#sep>, </#list>]
                    }
                }
            <#if version??>
                ,{
                     "term": {
                       "version.keyword": "${version}"
                     }
                }
            </#if>
            ],
            </#if>
            "minimum_should_match": 1,
            "should": [
                {
                    "match": {
                        "standard_name.keyword": {
                            "query": "${use_question}",
                            "boost": 10,
                            "analyzer": "ngram_analyzer"
                        }
                    }
                },
                {
                    "match": {
                        "synonyms.keyword": {
                            "query": "${use_question}",
                            "boost": 10,
                            "analyzer": "ngram_analyzer"
                        }
                    }
                }
            ],
            "must_not": [
                {
                    "term": {
                        "del_flag": 1
                    }
                }
            ]
        }
    },
    "collapse": {
        "field": "entity_type",
        "inner_hits": {
            "name": "entity_collection",
            "_source": [
                "standard_name",
                "synonyms",
                "tenant_id",
                "ext_info",
                "description",
                 "application_code",
                 "version"
            ],
            "size": 100
        }
    },
    "size": 100
}