{
    "query": {
        "bool": {
            "filter": {
                "bool":{
                    "must":[
                        <#if appCodesCondition??>
                        {
                            "terms": {
                                "applicationCode": [<#list appCodesCondition as item>"${item}"<#sep>, </#list>]
                            }
                        },
                        </#if>
                        <#if version??>
                        {
                            "term": {
                                "version": "${version}"
                            }
                        },
                        </#if>
                        <#if datasetIds??>
                        {
                            "terms": {
                                "datasetId": [<#list datasetIds as item>"${item}"<#sep>, </#list>]
                            }
                        },
                        </#if>
                        {
                            "exists": {
                                "field": "datasetId"
                            }
                        }
                    ],
                  "should": [
                    {
                      "script": {
                        "script": {
                          "source": "String sentence = params.sentence; for (def item : doc['fieldSchema.title.keyword']) { String title = item.toString(); if (title != null && sentence.contains(title)) {return true;}} return false;",
                          "params": { "sentence": "${userMessage}" }
                        }
                      }
                    },
                    {
                      "script": {
                        "script": {
                          "source": "String sentence = params.sentence; for (def item : doc['fieldSchema.lang.title.zh_CN.keyword']) { String name = item.toString(); if (name != null && sentence.contains(name)) {return true;}} return false;",
                          "params": { "sentence": "${userMessage}" }

                        }
                      }
                    },
                     {
                       "script": {
                         "script": {
                           "source": "String sentence = params.sentence; for (def item : doc['fieldSchema.lang.title.zh_TW.keyword']) { String name = item.toString(); if (name != null && sentence.contains(name)) {return true;}} return false;",
                           "params": { "sentence": "${userMessage}" }
                         }
                       }
                     }
                  ],
                  "minimum_should_match": 1
                }
            }
        }
    },
    "size": 1000
}