{
    "query": {
        "bool": {
            "filter": {
                "bool":{
                    "must":[
                        <#if appCodesCondition??>
                        {
                            "terms": {
                                "applicationCode": [<#list appCodesCondition as item>"${item}"<#sep>, </#list>]
                            }
                        },
                        </#if>
                        <#if version??>
                        {
                            "term": {
                                "version": "${version}"
                            }
                        },
                        </#if>
                        <#if datasetIds??>
                        {
                            "terms": {
                                "datasetId": [<#list datasetIds as item>"${item}"<#sep>, </#list>]
                            }
                        },
                        </#if>
                        <#if moduleNames??>
                        {
                            "terms": {
                                "modules.name.keyword": [<#list moduleNames as item>"${item}"<#sep>, </#list>]
                            }
                        },
                        </#if>
                        <#if not_query_all??>
                        {"bool":{"should":[
                            <#if simplified_use_question??>
                            {
                                "match": {
                                    "datasetName": {
                                        "query": "${simplified_use_question}",
                                        "boost": 7,
                                        "analyzer": "ngram_analyzer"
                                    }
                                }
                            }
                            </#if>
                            <#if traditional_use_question??>
                            ,{
                                "match": {
                                    "datasetName": {
                                        "query": "${traditional_use_question}",
                                        "boost": 7,
                                        "analyzer": "ngram_analyzer"
                                    }
                                }
                            }
                            </#if>
                            <#if origin_finally_question??>
                            ,{
                                "match": {
                                    "datasetName": {
                                        "query": "${origin_finally_question}",
                                        "boost": 7,
                                        "analyzer": "ngram_analyzer"
                                    }
                                }
                            }
                            </#if>
                            <#if simplified_metric_standard_name??>
                            ,{
                                "match": {
                                    "datasetName": {
                                        "query": "${simplified_metric_standard_name}",
                                        "boost": 10,
                                        "analyzer": "whitespace"
                                    }
                                }
                            }
                            </#if>
                            <#if traditional_metric_standard_name??>
                            ,{
                                "match": {
                                    "datasetName": {
                                        "query": "${traditional_metric_standard_name}",
                                        "boost": 10,
                                        "analyzer": "whitespace"
                                    }
                                }
                            }
                            </#if>
                            <#if orginal_question??>
                            {
                                "match": {
                                    "datasetName": {
                                        "query": "${orginal_question}",
                                        "boost": 7,
                                        "analyzer": "ngram_analyzer"
                                    }
                                }
                            }
                            </#if>
                        ]}},

                        </#if>
                        {
                            "exists": {
                                "field": "datasetId"
                            }
                        }
                    ]
                }
            }
        }
    },
    "size": 1000
}