{
    "query": {
        "bool": {
            "filter": {
                "bool":{
                    "must":[
                        <#if appCodesCondition??>
                        {
                            "terms": {
                                "applicationCode": [<#list appCodesCondition as item>"${item}"<#sep>, </#list>]
                            }
                        },
                        </#if>
                        <#if version??>
                        {
                            "term": {
                                "version": "${version}"
                            }
                        },
                        </#if>
                        {
                            "exists": {
                                "field": "metricId"
                            }
                        }
                    ]
                }
            },
            "must": {
                "function_score": {
                    "boost": "1",
                    "query": {
                        "dis_max": {
                            "queries": [
                                <#if simplified_metric_standard_name??>
                                {
                                    "match": {
                                        "metricName": {
                                            "query": "${simplified_metric_standard_name}",
                                            "boost": 10,
                                            "analyzer": "whitespace"
                                        }
                                    }
                                },
                                </#if>
                                <#if traditional_metric_standard_name??>
                                {
                                    "match": {
                                        "metricName": {
                                            "query": "${traditional_metric_standard_name}",
                                            "boost": 10,
                                            "analyzer": "whitespace"
                                        }
                                    }
                                }
                                </#if>
                            ],
                            "tie_breaker": 0.1
                        }
                    }
                }
            }
        }
    },
    "size": 100
}