{
    "size": 15,
    "query": {
        "bool": {
            "must": [
                <#if appCodesCondition??>
                {
                    "terms": {
                        "applicationCode": [<#list appCodesCondition as item>"${item}"<#sep>, </#list>]
                    }
                },
                </#if>
                <#if version??>
                {
                    "term": {
                        "version": "${version}"
                    }
                },
                </#if>
                <#if datasetIds??>                
                {
                    "terms": {
                        "datasetId": [<#list datasetIds as item>"${item}"<#sep>, </#list>]
                    }
                },
                </#if>
                {
                    "query_string": {
                        "query": "${search_table_query_fields}",
                        "fields": [
                            "metrics.keyword^5",
                            "measures.name.keyword^5",
                            "entities.keyword^5",
                            "dimensions.name.keyword^4",
                            "datasetName^4",
                            "fieldSchema.title.keyword^2.5",
                            "fieldSchema.lang.title.zh_CN.keyword^2.0",
                            "fieldSchema.lang.title.zh_TW.keyword^2.0"
                        ],
                        "boost": 1,
                        "type": "best_fields"
                    }
                }
            ],
            "should": [
                {
                    "query_string": {
                        "query": "${search_table_query_module}",
                        "fields": [
                            "modules.name.keyword^1.0"
                        ],
                        "boost": 1,
                        "type": "best_fields"
                    }
                },
                {
                    "query_string": {
                        "query": "${search_table_query_system}",
                        "fields": [
                            "modules.subsystems.keyword^1.0"
                        ],
                        "boost": 1,
                        "type": "best_fields"
                    }
                }
            ]
        }
    }
}