/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.search.config.AdtHostConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AdtServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(AdtServiceInvoker.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private AdtHostConfig adtHostConfig;
    private static final String ADT_QUERY_SNAPSHOT_URL = "/api/ai/agile/report/getSnapData/";
    private static final String ADT_PROCESSMESSAGE_URL = "/api/ai/agileData/dataPanel/processMessage";
    private static final String ADT_AUTODATA_GETDATA_URL = "/api/ai/agileData/autoData/getData";
    private String ERR_MESSAGE = "\u67e5\u8be2adt\u7cfb\u7edf\u5f02\u5e38";

    public JSONObject querySnapshotInfo(String token, String routerKey, String snapshotId) {
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add("token", token);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        headers.add("Content-Type", "application/json");
        JSONObject gptParam = new JSONObject();
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.adtHostConfig.getUrl().concat(ADT_QUERY_SNAPSHOT_URL).concat(snapshotId), HttpMethod.GET, entity, String.class, new Object[0]);
            log.info("querySnapshotId responseEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.info("\u67e5\u8be2\u5feb\u7167\u4fe1\u606f\u6210\u529f");
                String actionId = "";
                JSONObject snapshotInfo = JSONObject.parseObject((String)((String)responseEntity.getBody()));
                JSONObject response = Optional.ofNullable(snapshotInfo).map(lang -> lang.getJSONObject("response")).orElse(new JSONObject());
                if (!response.isEmpty()) {
                    actionId = Optional.ofNullable(response.getJSONObject("showDefine")).map(lang -> lang.getJSONArray("showType")).map(lang -> lang.getJSONObject(0)).map(lang -> lang.getString("actionId")).orElse("");
                    String title = Optional.ofNullable(response.getJSONObject("showDefine")).map(lang -> lang.getJSONArray("showType")).map(lang -> lang.getJSONObject(0)).map(lang -> lang.getJSONArray("type")).map(lang -> lang.getJSONObject(0)).map(lang -> lang.getString("title")).orElse("");
                    gptParam.put("data_title", (Object)title);
                    if (StringUtils.isNotEmpty((CharSequence)actionId)) {
                        String finalActionId = actionId;
                        JSONObject pageDataObj = Optional.ofNullable(response.getJSONObject("pageData")).map(lang -> lang.getJSONArray(finalActionId)).map(lang -> lang.getJSONObject(0)).orElse(new JSONObject());
                        if (!pageDataObj.isEmpty()) {
                            JSONObject dataObj = pageDataObj.getJSONObject("data");
                            if (null != dataObj && !dataObj.isEmpty()) {
                                gptParam.put("data", (Object)dataObj.getJSONArray("data"));
                            }
                            JSONObject metadata = Optional.ofNullable(pageDataObj.getJSONObject("metadata").getJSONObject("response")).map(lang -> lang.getJSONObject("data")).orElse(new JSONObject());
                            gptParam.put("metadata", (Object)metadata);
                        }
                    }
                }
                return gptParam;
            }
            log.info("\u67e5\u8be2\u5feb\u7167\u4fe1\u606f\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse("\u67e5\u8be2\u5feb\u7167\u4fe1\u606f\u5931\u8d25"));
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5feb\u7167\u4fe1\u606f\u5931\u8d25\uff1a{} ", (Throwable)e2);
        }
        return gptParam;
    }

    public String processMessage(String question, String token, String routerKey) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add("token", token);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        JSONObject param = new JSONObject();
        JSONObject msgBody = new JSONObject();
        msgBody.put("text", (Object)question);
        param.put("msgBody", (Object)msgBody);
        JSONObject msgExt = new JSONObject();
        msgExt.put("question", (Object)question);
        msgExt.put("multiDialogue", (Object)"false");
        msgExt.put("metricIdList", new ArrayList());
        param.put("msgExt", (Object)msgExt);
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntityStr = this.restTemplate.postForEntity(this.adtHostConfig.getUrl().concat(ADT_PROCESSMESSAGE_URL), (Object)httpEntity, String.class, new Object[0]);
            log.info("processmessage responseEntity\uff1a{}", responseEntityStr.getBody());
            if (responseEntityStr.getStatusCode().is2xxSuccessful()) {
                JSONObject response = JSONObject.parseObject((String)((String)responseEntityStr.getBody())).getJSONObject("response");
                if (Objects.isNull(response)) {
                    log.info("\u95ee\u6570\u56de\u7b54\u4e3a\u7a7a");
                    return null;
                }
                if (StringUtils.isEmpty((CharSequence)response.getString("snapshotId"))) {
                    log.info("\u5feb\u7167id\u4e3a\u7a7a");
                    return null;
                }
                return response.getString("snapshotId");
            }
            log.info("\u95ee\u6570\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntityStr.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u95ee\u6570\u5931\u8d25", param, e2});
        }
        return null;
    }

    public JSONObject autodataGetdata(String question, List<JSONObject> datasetList, String appCode, JSONArray solutionStep, JSONObject showDefine, String token, String routerKey) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add("token", token);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        JSONObject param = new JSONObject();
        param.put("question", (Object)question);
        param.put("datasetList", datasetList);
        param.put("appCode", (Object)appCode);
        param.put("solutionStep", (Object)solutionStep);
        param.put("showDefine", (Object)showDefine);
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntityStr = this.restTemplate.postForEntity(this.adtHostConfig.getUrl().concat(ADT_AUTODATA_GETDATA_URL), (Object)httpEntity, String.class, new Object[0]);
            log.info("autodataGetdata responseEntity\uff1a{}", responseEntityStr.getBody());
            if (responseEntityStr.getStatusCode().is2xxSuccessful()) {
                JSONObject response = JSONObject.parseObject((String)((String)responseEntityStr.getBody())).getJSONObject("response");
                if (Objects.isNull(response)) {
                    log.info("\u83b7\u53d6\u5206\u6790\u5e08\u6570\u636e\u56de\u7b54\u4e3a\u7a7a");
                    return null;
                }
                return response;
            }
            log.info("\u83b7\u53d6\u5206\u6790\u5e08\u6570\u636e\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntityStr.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u83b7\u53d6\u5206\u6790\u5e08\u6570\u636e\u5931\u8d25", param, e2});
        }
        return null;
    }
}

