/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.common.util.Logger;
import com.digiwin.chatbi.reasoning.search.config.DeepSeekHostConfig;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeepSeekInvoker {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(DeepSeekInvoker.class);
    @Autowired
    private DeepSeekHostConfig deepSeekHostConfig;
    private static final String CHAT_COMPLETIONS_URL = "/v1/chat/completions";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject callDeepSeek(String userMessage) {
        HttpPost httpPost = new HttpPost(this.deepSeekHostConfig.getUrl().concat(CHAT_COMPLETIONS_URL));
        httpPost.setHeader("Content-Type", "application/json");
        JSONObject payload = new JSONObject();
        payload.put("model", (Object)"openchat");
        JSONObject message = new JSONObject();
        message.put("role", (Object)"user");
        message.put("content", (Object)userMessage);
        payload.put("messages", (Object)new JSONObject[]{message});
        try {
            httpPost.setEntity((HttpEntity)new StringEntity(payload.toJSONString(), ContentType.APPLICATION_JSON));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
            Logger.info((String)("\u8c03\u7528deepSeek\u5165\u53c2\uff1a" + payload));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                if (response.getEntity() == null) return null;
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                Logger.info((String)("\u8c03\u7528gpt\u51fa\u53c2\uff1a" + result));
                JSONObject jSONObject = this.parseResponse(result);
                return jSONObject;
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528deepSeek\u5931\u8d25\uff1a{} ", (Throwable)e);
            return null;
        }
    }

    private JSONObject parseResponse(String jsonResponse) {
        JSONObject jsonObject = new JSONObject();
        try {
            JSONObject message;
            JSONObject choice;
            jsonObject = JSONObject.parseObject((String)jsonResponse);
            if (jsonObject.containsKey((Object)"choices") && (choice = jsonObject.getJSONArray("choices").getJSONObject(0)).containsKey((Object)"message") && (message = choice.getJSONObject("message")).containsKey((Object)"content") && StringUtils.isNotBlank((CharSequence)message.getString("content"))) {
                return this.extractThinkData(message.getString("content"));
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790deepSeek\u8fd4\u56de\u7ed3\u679c\u8f6cJSON\u5931\u8d25\uff1a{} ", (Throwable)e);
        }
        return jsonObject;
    }

    public JSONObject extractThinkData(String content) {
        String afterThink;
        String betweenThink;
        JSONObject jsonObject = new JSONObject();
        Pattern pattern = Pattern.compile("<think>(.*?)</think>(.*)", 32);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            betweenThink = matcher.group(1) != null ? matcher.group(1) : "";
            afterThink = matcher.group(2) != null ? matcher.group(2) : content;
        } else {
            betweenThink = "";
            afterThink = content;
        }
        afterThink = this.cleanJsonContent(afterThink);
        jsonObject.put("think", (Object)betweenThink);
        if (StringUtils.isBlank((CharSequence)betweenThink)) {
            jsonObject.put("think", (Object)"");
        }
        jsonObject.put("content", (Object)afterThink);
        return jsonObject;
    }

    private String cleanJsonContent(String content) {
        return content.trim().replaceAll("```json", "").replaceAll("```", "").replaceAll("^\\n+", "").replaceAll("\\n+$", "");
    }
}

