/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.enums.CellExtraTypeEnum;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.common.DmcServiceInvoker;
import com.digiwin.chatbi.common.exception.BussinessException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class DmcServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(DmcServiceInvoker.class);
    @Autowired
    private RestTemplate restTemplate;

    public byte[] getSheet(String url) {
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, null, byte[].class, new Object[0]);
            byte[] bytes = (byte[])responseEntity.getBody();
            if (null == bytes) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6587\u4ef6\u4e2d\u5fc3sheet\u5931\u8d25\uff1a{} ", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getReportByUrl(byte[] excelBytes, ReadSheet sheet) throws BussinessException {
        Map columnAndLineCounts = this.getColumnAndLineCounts(excelBytes, sheet.getSheetNo().intValue());
        int maxRows = (Integer)columnAndLineCounts.get("rowCount");
        int maxCols = (Integer)columnAndLineCounts.get("columnCount");
        int headIndex = (Integer)columnAndLineCounts.get("headIndex");
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        try {
            JSONArray datas = new JSONArray();
            JSONArray columns = new JSONArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(excelBytes);
            ExcelReader build = null;
            try {
                build = ((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream, (ReadListener)new CustomAnalysisEventListener(datas, columns, headIndex, maxRows, maxCols)).headRowNumber(Integer.valueOf(0))).extraRead(CellExtraTypeEnum.MERGE).build();
                build.read(new ReadSheet[]{sheet});
            }
            catch (Exception e) {
                log.error("excel\u89e3\u6790\u5931\u8d25", (Throwable)e);
            }
            finally {
                ((InputStream)inputStream).close();
                if (!Objects.isNull(build)) {
                    build.finish();
                }
            }
            JSONArray finalDatas = new JSONArray();
            JSONArray finalColumns = new JSONArray();
            for (int i = 0; i < columns.size(); ++i) {
                if (Objects.isNull(columns.get(i)) || !StringUtils.isNotEmpty((CharSequence)columns.get(i).toString())) continue;
                finalColumns.add(columns.get(i));
            }
            for (Object data : datas) {
                JSONArray everyLineData = (JSONArray)data;
                JSONArray finalEveryLineData = new JSONArray();
                Boolean isAllDataNull = true;
                for (int i = 0; i < columns.size(); ++i) {
                    if (Objects.isNull(columns.get(i)) || !StringUtils.isNotEmpty((CharSequence)columns.get(i).toString())) continue;
                    if (everyLineData.get(i) != null) {
                        isAllDataNull = false;
                    }
                    finalEveryLineData.add(everyLineData.get(i));
                }
                if (isAllDataNull.booleanValue()) continue;
                finalDatas.add((Object)finalEveryLineData);
            }
            JSONObject res = new JSONObject();
            res.put("datas", (Object)finalDatas);
            res.put("columns", (Object)finalColumns);
            res.put("sheetIndex", (Object)sheet.getSheetNo());
            res.put("sheetName", (Object)sheet.getSheetName());
            return res;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6587\u4ef6\u4e2d\u5fc3excel\u5931\u8d25\uff1a{} ", (Throwable)e);
            throw new BussinessException("\u6570\u636e\u4e0d\u5408\u89c4");
        }
    }

    public Map<String, Integer> getColumnAndLineCounts(byte[] excelBytes, int sheetIndex) throws BussinessException {
        int maxEmptyColumns = 5;
        int maxEmptyRows = 5;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(excelBytes);){
                ((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream, (ReadListener)new /* Unavailable Anonymous Inner Class!! */).headRowNumber(Integer.valueOf(0))).sheet(Integer.valueOf(sheetIndex)).doRead();
            }
            return map;
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u884c\u5217\u6570\u5931\u8d25{}", (Object)e.getMessage());
            throw new BussinessException("\u89e3\u6790\u884c\u5217\u6570\u5931\u8d25");
        }
    }

    private int getRowCount(int maxEmptyRows, Sheet sheet, int rowCount) {
        for (int rowIndex = 0; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (row == null) continue;
            boolean isEmptyRow = true;
            if (!(isEmptyRow = this.isEmptyRow(row, isEmptyRow))) {
                rowCount = rowIndex + 1;
                continue;
            }
            if (rowIndex - rowCount >= maxEmptyRows) break;
        }
        return rowCount;
    }

    private boolean isEmptyRow(Row row, boolean isEmptyRow) {
        for (Cell cell : row) {
            if (cell.getCellType() == CellType.BLANK) continue;
            isEmptyRow = false;
            break;
        }
        return isEmptyRow;
    }

    private int getColumnCount(int maxEmptyColumns, int columnCount, Row firstNonEmptyRow) {
        for (int col = 0; col < firstNonEmptyRow.getLastCellNum(); ++col) {
            Cell cell = firstNonEmptyRow.getCell(col);
            if (cell != null && cell.getCellType() != CellType.BLANK) {
                columnCount = col + 1;
                continue;
            }
            if (col - columnCount >= maxEmptyColumns) break;
        }
        return columnCount;
    }

    private Row getCells(Sheet sheet, Row firstNonEmptyRow) {
        for (Row row : sheet) {
            boolean isEmptyRow = true;
            for (Cell cell : row) {
                if (cell == null || cell.getCellType() == CellType.BLANK) continue;
                cell.getRowIndex();
                isEmptyRow = false;
                break;
            }
            if (isEmptyRow) continue;
            firstNonEmptyRow = row;
            break;
        }
        return firstNonEmptyRow;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

