/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.chart.AiDataSetPushDto;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.reasoning.search.config.AppTokenConfig;
import com.digiwin.chatbi.reasoning.search.config.DmlHostConfig;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DmlServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(DmlServiceInvoker.class);
    @Autowired
    private DmlHostConfig dmlHostConfig;
    @Autowired
    private AppTokenConfig appTokenConfig;
    @Autowired
    private RestTemplate restTemplate;
    private static final String DATASET_SCHEMA_SAVE = "/restful/standard/dml/isv/dataset/schema/save";
    private static final String DATASET_SEARCH_RESULT = "/restful/standard/dml/isv/dataset/search/result";
    private static final String DIGI_KAI_API_KEY = "gZV3LPGC51rdxQDHBygEt0hjrOiq3Oo3Z8mjz1hE2AnUP5yzZ+chiIgXvuzW5mmE4wwUJSNz3cXCW6LxhTVPuF6xbF7S+aXgDeUXU4o5I1B2iuwnoxohQ598Sldb9UCDjZF7cP73YvtHOJ1/1Z0hlmRDhAnzGsLlAKWcskNRxea9pDxmf+51pQV2wgX36ZyYvHwNfyeSbGf3yR3y2js3zieB45RQExZqUK9aUhNsBXPschdCXtWR15E0pzJ8sjFS0ErGpbMNyLfpf2s70DSXXc6jv5cpfivFk72pNm1U8oxv75RaUmajhNH9Azm3HedvEa0+9rMLe4SH9fJZl1AgNxPQyBCS8D6yW4DV3c9KSyLNSaWOhEC3SjhqKYgcMovZ4TKL7tgLVxlRoBZYQgGKJ7frsdKBZYLS/K1YMjGhuc4=";
    private static final String TOKEN = "token";
    private String ERR_MESSAGE = "\u67e5\u8be2dml\u7cfb\u7edf\u5f02\u5e38";

    public void saveDatasetSchema(AiDataSetPushDto aiDataSetPushDto, String token, String locale) throws BussinessException {
        block5: {
            HttpHeaders headers = new HttpHeaders();
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                headers.add(TOKEN, token);
            }
            headers.add("Content-Type", "application/json");
            headers.add("digi-middleware-auth-app", this.appTokenConfig.getScrumbi());
            headers.add("Accept-Language", StringUtils.isNotEmpty((CharSequence)locale) ? locale : "zh_CN");
            headers.add("digi-kai-api-key", DIGI_KAI_API_KEY);
            HttpEntity httpEntity = new HttpEntity((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)aiDataSetPushDto)), (MultiValueMap)headers);
            try {
                ResponseEntity responseEntity = this.restTemplate.postForEntity(this.dmlHostConfig.getUrl().concat(DATASET_SCHEMA_SAVE), (Object)httpEntity, String.class, new Object[0]);
                log.info("saveDatasetSchemaEntity\uff1a{}", responseEntity.getBody());
                if (responseEntity.getStatusCode().is2xxSuccessful()) {
                    Boolean result = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("response").getBoolean("success");
                    if (result.booleanValue()) {
                        return;
                    }
                    break block5;
                }
                log.info("\u63a8\u9001dml\u6570\u636e\u96c6\u5931\u8d25:{}", (Object)JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("response").getString("message"));
                throw new BussinessException("\u63a8\u9001AI\u4e2d\u53f0\u6570\u636e\u96c6\u5931\u8d25");
            }
            catch (Exception e) {
                log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u63a8\u9001dml\u6570\u636e\u96c6\u5931\u8d25", JSONObject.toJSONString((Object)aiDataSetPushDto), e});
                throw new BussinessException("\u63a8\u9001AI\u4e2d\u53f0\u6570\u636e\u96c6\u5931\u8d25");
            }
        }
    }

    public JSONArray datasetSearchResult(JSONObject param, String token, String locale, String routerKey) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.add(TOKEN, token);
        }
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-app", this.appTokenConfig.getAthena());
        headers.add("Accept-Language", StringUtils.isNotEmpty((CharSequence)locale) ? locale : "zh_CN");
        headers.add("digi-kai-api-key", DIGI_KAI_API_KEY);
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.dmlHostConfig.getUrl().concat(DATASET_SEARCH_RESULT), (Object)httpEntity, String.class, new Object[0]);
            log.info("datasetSearchResultEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                JSONArray rows = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("response").getJSONArray("data");
                if (CollectionUtils.isNotEmpty((Collection)rows)) {
                    return rows;
                }
                Boolean result = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("response").getBoolean("success");
                if (!result.booleanValue()) {
                    log.error("dml\u627e\u8868\u5931\u8d25:{}", (Object)JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("response").getString("message"));
                }
                return null;
            }
            log.info("dml\u627e\u8868\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"dml\u627e\u8868\u5931\u8d25", param, e2});
        }
        return null;
    }
}

