/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.digiwin.chatbi.beans.ResultBean;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.common.exception.ChatBiException;
import com.digiwin.chatbi.common.exception.TimeOutException;
import com.github.houbb.opencc4j.util.ZhTwConverterUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;

public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Value(value="${language}")
    private String language;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ResultBean<String> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        e.printStackTrace();
        log.error("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        BindingResult result = e.getBindingResult();
        List errors = result.getFieldErrors();
        String msg = errors.stream().map(error -> error.getDefaultMessage()).collect(Collectors.joining("|"));
        if (!"ZH-CN".equals(this.language)) {
            msg = ZhTwConverterUtil.toTraditional((String)msg);
        }
        return ResultBean.fail((String)msg);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResultBean<String> exceptionGet(Exception ex) {
        log.error("\u3010\u7cfb\u7edf\u5f02\u5e38\u3011{}", (Throwable)ex);
        ex.printStackTrace();
        return ResultBean.fail((String)ex.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public ResultBean handleValidateParams(IllegalArgumentException e) {
        e.printStackTrace();
        log.error("\u53c2\u6570\u6548\u9a8c\u5f02\u5e38, {}", (Object)e.getMessage());
        return ResultBean.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={TimeOutException.class})
    @ResponseBody
    public ResultBean<String> exceptionGet(TimeOutException ex) {
        log.error("\u767b\u5f55\u8d85\u65f6{}", (Throwable)ex);
        ex.printStackTrace();
        String msg = "\u51ed\u8bc1\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01";
        if (!"ZH-CN".equals(this.language)) {
            msg = ZhTwConverterUtil.toTraditional((String)msg);
        }
        return new ResultBean(Integer.valueOf(403), msg);
    }

    @ExceptionHandler(value={BussinessException.class})
    @ResponseBody
    public ResultBean<String> exceptionGet(BussinessException ex) {
        log.error("\u4e1a\u52a1\u5f02\u5e38{}", (Throwable)ex);
        ex.printStackTrace();
        return ResultBean.fail((String)ex.getMessage());
    }

    @ExceptionHandler(value={ChatBiException.class})
    @ResponseBody
    public ResultBean<String> exceptionGet(ChatBiException ex) {
        log.error("\u4e1a\u52a1\u5f02\u5e38{}", (Throwable)ex);
        ex.printStackTrace();
        return ResultBean.fail((String)ex.getMessage());
    }
}

