/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.search.config.TranslationHostConfig;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class TranslateServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(TranslateServiceInvoker.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TranslationHostConfig translationHostConfig;
    private static String url = "/restful/service/translater/IDWTranslateService/translateCustom";
    private static String translateUrl = "/restful/service/translater/IDWTranslateService/translate";

    public String zh2Hant(String keyWord) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        JSONObject jsonObject = new JSONObject();
        JSONObject keyJsonObject = new JSONObject();
        keyJsonObject.put("key", (Object)keyWord);
        jsonObject.put("content", (Object)keyJsonObject);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)"zh2Hant");
        jsonObject.put("convertTypes", (Object)jsonArray);
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.translationHostConfig.getUrl().concat(translateUrl), (Object)httpEntity, String.class, new Object[0]);
            log.info("zh2Hant\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                JSONObject res = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("response");
                if (!Objects.isNull(res)) {
                    return res.getJSONObject("data").getJSONObject("zh2Hant").getString("key");
                }
                return keyWord;
            }
            log.info("\u7b80\u4f53\u8f6c\u7e41\u4f53\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse("\u7b80\u4f53\u8f6c\u7e41\u4f53\u5931\u8d25"));
        }
        catch (Exception e2) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u7b80\u4f53\u8f6c\u7e41\u4f53\u5931\u8d25", keyWord, e2});
        }
        return keyWord;
    }

    public String zh2Hans(String keyWord) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        JSONObject jsonObject = new JSONObject();
        JSONObject keyJsonObject = new JSONObject();
        keyJsonObject.put("key", (Object)keyWord);
        jsonObject.put("content", (Object)keyJsonObject);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)"zh2Hans");
        jsonObject.put("convertTypes", (Object)jsonArray);
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(translateUrl, (Object)httpEntity, String.class, new Object[0]);
            log.info("zh2Hans\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                JSONObject res = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("response");
                if (!Objects.isNull(res)) {
                    return res.getJSONObject("data").getJSONObject("zh2Hans").getString("key");
                }
                return keyWord;
            }
            log.info("\u7e41\u4f53\u8f6c\u7b80\u4f53\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse("\u7b80\u4f53\u8f6c\u7e41\u4f53\u5931\u8d25"));
        }
        catch (Exception e2) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u7e41\u4f53\u8f6c\u7b80\u4f53\u5931\u8d25", keyWord, e2});
        }
        return keyWord;
    }

    public JSONObject cnAndTw(String keyWord) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        JSONObject httpJsonObject = new JSONObject();
        JSONObject keyJsonObject = new JSONObject();
        keyJsonObject.put("key", (Object)keyWord);
        httpJsonObject.put("content", (Object)keyJsonObject);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)"zh2Hant");
        jsonArray.add((Object)"zh2Hans");
        httpJsonObject.put("convertTypes", (Object)jsonArray);
        HttpEntity httpEntity = new HttpEntity((Object)httpJsonObject, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.translationHostConfig.getUrl().concat(url), (Object)httpEntity, String.class, new Object[0]);
            log.info("chAndTw\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                JSONObject res = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("response");
                if (!Objects.isNull(res)) {
                    return res.getJSONObject("data").getJSONObject("lang").getJSONObject("key");
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("zh_TW", (Object)keyWord);
                jsonObject.put("zh_CN", (Object)keyWord);
                return jsonObject;
            }
            log.info("\u7b80\u4f53\u8f6c\u7e41\u4f53\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse("\u7b80\u4f53\u8f6c\u7e41\u4f53\u5931\u8d25"));
        }
        catch (Exception e2) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u7b80\u4f53\u8f6c\u7e41\u4f53\u5931\u8d25", keyWord, e2});
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("zh_TW", (Object)keyWord);
        jsonObject.put("zh_CN", (Object)keyWord);
        return jsonObject;
    }
}

