/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.common.constant.Constants;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringUtil {
    private static final String NUMBER_REGEX = "^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$";
    private static final Pattern CODE_BLOCK_PATTERN = Pattern.compile("(?s)```[a-zA-Z]*\\r?\\n(.*?)\\r?\\n```");

    public static String formatListToBrackets(List<String> elements, String locale) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        StringBuilder formattedString = new StringBuilder();
        for (int i = 0; i < elements.size(); ++i) {
            formattedString.append("\u3010").append(elements.get(i)).append("\u3011");
            if (i < elements.size() - 2) {
                formattedString.append("\u3001");
                continue;
            }
            if (i >= elements.size() - 1) continue;
            formattedString.append("zh_CN".equals(locale) ? "\u8fd8\u662f" : "\u9084\u662f");
        }
        return formattedString.append("\uff1f").toString();
    }

    public static String substringByPrefix(String fullString, String prefix) {
        if (StringUtils.isEmpty((CharSequence)fullString) || StringUtils.isEmpty((CharSequence)prefix)) {
            return fullString;
        }
        int startIndex = fullString.indexOf(prefix);
        if (startIndex != -1) {
            return fullString.substring(startIndex += prefix.length());
        }
        return fullString;
    }

    public static String correctTableName(String tableName) {
        System.out.println("Original Table Name: " + tableName);
        for (int i = 0; i < Constants.ERROR_CHAR_LIST.length; ++i) {
            String regex = Constants.ERROR_CHAR_LIST[i];
            System.out.println("Replacing regex: " + regex);
            tableName = tableName.replaceAll(regex, "_");
            System.out.println("After replacement: " + tableName);
        }
        return tableName;
    }

    public static String trimNewLines(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return str.replaceAll("(^[\n]+)|([\n]+$)", "");
    }

    public static String formatListToBracketsV2(List<String> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        StringBuilder formattedString = new StringBuilder();
        for (int i = 0; i < elements.size(); ++i) {
            formattedString.append("\u3010").append(elements.get(i)).append("\u3011");
            if (i < elements.size() - 2) {
                formattedString.append("\u3001");
                continue;
            }
            if (i >= elements.size() - 1) continue;
            formattedString.append("\u548c");
        }
        return formattedString.toString();
    }

    public static String buildSentencesParam4Metric(List<JSONObject> metricList, String locale) {
        if (CollectionUtils.isEmpty(metricList) || StringUtils.isEmpty((CharSequence)locale)) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (JSONObject metric : metricList) {
            String metricTemplate = "- **%s**\uff1a\n%s";
            String metricName = StringUtil.getNameBylocale((String)metric.getString("metricName"), (String)locale, (JSONObject)metric, (String)"sceneTitle");
            String metricDesc = StringUtils.isEmpty((CharSequence)metric.getString("description")) ? "" : metric.getString("description");
            JSONArray fieldSchemas = (JSONArray)metric.getOrDefault((Object)"fieldSchema", (Object)new JSONArray());
            StringBuilder schemasRes = new StringBuilder();
            for (Object obj : fieldSchemas) {
                String schemaTemplate = "  - **%s** %s %s";
                JSONObject fieldSchema = (JSONObject)obj;
                String schemaType = fieldSchema.getString("dataType");
                String schemaDesc = StringUtils.isEmpty((CharSequence)fieldSchema.getString("description")) ? "" : fieldSchema.getString("description");
                String schemaTitle = StringUtil.getNameBylocale((String)fieldSchema.getString("title"), (String)locale, (JSONObject)fieldSchema, (String)"title");
                if (CollectionUtils.isNotEmpty((Collection)fieldSchema.getJSONArray("enums"))) {
                    JSONArray enums = fieldSchema.getJSONArray("enums");
                    JSONArray enumsArray = new JSONArray();
                    for (Object enumObj : enums) {
                        if (Objects.isNull(enumObj)) continue;
                        JSONObject enumJsonObject = new JSONObject();
                        enumJsonObject.put("description", (Object)((JSONObject)enumObj).getString("description"));
                        enumJsonObject.put("value", (Object)((JSONObject)enumObj).getString("value"));
                        enumsArray.add((Object)enumJsonObject);
                    }
                    String enumsString = enumsArray.toString();
                    schemaDesc = schemaDesc + enumsString;
                }
                String defaultDate = "true".equals(fieldSchema.getString("defaultDate")) ? "defaultDate" : "";
                String schemasFormat = String.format(schemaTemplate, schemaTitle, schemaType, defaultDate);
                schemasRes.append(schemasFormat).append("\n");
            }
            String metricFormat = String.format(metricTemplate, metricName, schemasRes.toString());
            res.append(metricFormat).append("\n");
        }
        return res.toString();
    }

    public static String buildSentencesParamNoneMetric(List<JSONObject> metricList, String locale) {
        if (CollectionUtils.isEmpty(metricList) || StringUtils.isEmpty((CharSequence)locale)) {
            return null;
        }
        ArrayList<JSONObject> resList = new ArrayList<JSONObject>();
        for (JSONObject metric : metricList) {
            String name = metric.getString("metricName");
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = metric.getString("datasetName");
            }
            JSONObject metricRes = new JSONObject();
            String metricName = StringUtil.getNameBylocale((String)name, (String)locale, (JSONObject)metric, (String)"sceneTitle");
            metricRes.put("metric", (Object)metricName);
            JSONArray fieldSchemas = (JSONArray)metric.getOrDefault((Object)"fieldSchema", (Object)new JSONArray());
            ArrayList<JSONObject> schemasRes = new ArrayList<JSONObject>();
            for (Object obj : fieldSchemas) {
                JSONObject fieldRes = new JSONObject();
                JSONObject fieldSchema = (JSONObject)obj;
                String schemaType = fieldSchema.getString("dataType");
                String schemaTitle = StringUtil.getNameBylocale((String)fieldSchema.getString("title"), (String)locale, (JSONObject)fieldSchema, (String)"title");
                fieldRes.put("name", (Object)schemaTitle);
                fieldRes.put("type", (Object)schemaType);
                if (CollectionUtils.isNotEmpty((Collection)fieldSchema.getJSONArray("enums"))) {
                    JSONArray enums = fieldSchema.getJSONArray("enums");
                    JSONArray enumsArray = new JSONArray();
                    for (Object enumObj : enums) {
                        if (Objects.isNull(enumObj)) continue;
                        JSONObject enumJsonObject = new JSONObject();
                        enumJsonObject.put("description", (Object)((JSONObject)enumObj).getString("description"));
                        enumJsonObject.put("value", (Object)((JSONObject)enumObj).getString("value"));
                        enumsArray.add((Object)enumJsonObject);
                    }
                    fieldRes.put("enums", (Object)enumsArray);
                }
                schemasRes.add(fieldRes);
            }
            metricRes.put("fields", schemasRes);
            resList.add(metricRes);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(resList);
    }

    public static String translateName(String mixTargetMetricName, List<JSONObject> metricList, String locale) {
        String name = mixTargetMetricName;
        Optional<JSONObject> first = metricList.stream().filter(m -> mixTargetMetricName.equals(m.getString("metricName"))).findFirst();
        if (!first.isPresent()) {
            return name;
        }
        JSONObject metric = first.get();
        return StringUtil.getNameBylocale((String)mixTargetMetricName, (String)locale, (JSONObject)metric, (String)"sceneTitle");
    }

    public static String getNameBylocale(String defaultName, String locale, JSONObject metric, String key) {
        JSONObject lang = metric.getJSONObject("lang");
        if (Objects.isNull(lang)) {
            return defaultName;
        }
        JSONObject sceneTitle = lang.getJSONObject(key);
        if (Objects.isNull(sceneTitle)) {
            return defaultName;
        }
        return StringUtils.isEmpty((CharSequence)sceneTitle.getString(locale)) ? defaultName : sceneTitle.getString(locale);
    }

    public static List<Integer> fetchBalancedSampleIndexs(int totalSize, int sampleSize) {
        ArrayList<Integer> sampleIndexs = new ArrayList<Integer>();
        if (totalSize <= sampleSize) {
            for (int i = 0; i < totalSize; ++i) {
                sampleIndexs.add(i + 1);
            }
            return sampleIndexs;
        }
        int interval = totalSize / sampleSize;
        for (int i = 0; i < sampleSize; ++i) {
            int index = i * interval;
            sampleIndexs.add(index + 1);
        }
        return sampleIndexs;
    }

    public static String JsonToMarkdownJSONJava(JSONObject jsonObject) {
        StringBuilder markdown = new StringBuilder();
        markdown.append("| Key | Value |\n");
        markdown.append("|-----|-------|\n");
        jsonObject.keySet().forEach(key -> markdown.append("| ").append((String)key).append(" | ").append(jsonObject.get(key)).append(" |\n"));
        return markdown.toString();
    }

    public static String convertObjectToMarkdown(JSONObject jsonObject) {
        StringBuilder markdown = new StringBuilder();
        Set keys = jsonObject.keySet();
        ArrayList keyList = new ArrayList(keys);
        markdown.append("|");
        for (String key : keyList) {
            markdown.append(" ").append(key).append(" |");
        }
        markdown.append("\n");
        markdown.append("|");
        for (String key : keyList) {
            markdown.append("---|");
        }
        markdown.append("\n");
        markdown.append("|");
        for (String key : keyList) {
            Object value = jsonObject.get((Object)key);
            if (value instanceof JSONObject) {
                value = value.toString();
            } else if (value instanceof JSONArray) {
                value = value.toString();
            }
            markdown.append(" ").append(value).append(" |");
        }
        markdown.append("\n");
        return markdown.toString();
    }

    public static String convertArrayToMarkdown(JSONArray jsonArray) {
        if (jsonArray.isEmpty()) {
            return "";
        }
        StringBuilder markdown = new StringBuilder();
        JSONObject firstObject = jsonArray.getJSONObject(0);
        Set keys = firstObject.keySet();
        ArrayList keyList = new ArrayList(keys);
        markdown.append("|");
        for (String key : keyList) {
            markdown.append(" ").append(key).append(" |");
        }
        markdown.append("\n");
        markdown.append("|");
        for (String key : keyList) {
            markdown.append("---|");
        }
        markdown.append("\n");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            markdown.append("|");
            for (String key : keyList) {
                Object value = obj.get((Object)key);
                if (value == null) {
                    value = "";
                } else if (value instanceof JSONObject) {
                    value = value.toString();
                } else if (value instanceof JSONArray) {
                    JSONArray valueJSONArray = (JSONArray)value;
                    StringBuilder result = new StringBuilder();
                    for (int k = 0; k < valueJSONArray.size(); ++k) {
                        result.append(valueJSONArray.get(k));
                        if (k >= valueJSONArray.size() - 1) continue;
                        result.append("\u3001");
                    }
                    value = result.toString();
                }
                markdown.append(" ").append(value).append(" |");
            }
            markdown.append("\n");
        }
        return markdown.toString();
    }

    public static boolean isNumber(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return str.matches("^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$");
    }

    public static String getStringAfterLastChar(String orgString, String lastChar) {
        int lastHashIndex = orgString.lastIndexOf(lastChar);
        return lastHashIndex != -1 ? orgString.substring(lastHashIndex + 1) : orgString;
    }

    public static String convertJsonToMarkdown(JSONArray metrics) {
        StringBuilder markdown = new StringBuilder();
        for (int i = 0; i < metrics.size(); ++i) {
            JSONObject metric = metrics.getJSONObject(i);
            String metricName = metric.getString("metricName");
            String metricId = metric.getString("metricId");
            String description = metric.getString("description");
            markdown.append("## ").append(metricName).append("\n\n");
            markdown.append("**\u63cf\u8ff0**\uff1a").append(description != null ? description : "-").append("  \n");
            markdown.append("**Metric ID**\uff1a`").append(metricId).append("`\n\n");
            markdown.append("| \u5b57\u6bb5\u540d (name) | \u5b57\u6bb5\u8bf4\u660e (title) | \u6570\u636e\u7c7b\u578b | \u63cf\u8ff0 | \u679a\u4e3e\u503c | \u793a\u4f8b\u6570\u636e |\n");
            markdown.append("|---------------|------------------|----------|------|--------|----------|\n");
            JSONArray fields = metric.getJSONArray("fieldSchema");
            for (int j = 0; j < fields.size(); ++j) {
                JSONObject field = fields.getJSONObject(j);
                String name = field.getString("name");
                String title = field.getString("title");
                String dataType = field.getString("dataType");
                String fieldDesc = field.getString("description");
                StringBuilder enumBuilder = new StringBuilder();
                JSONArray enums = field.getJSONArray("enums");
                if (enums != null) {
                    for (int k = 0; k < enums.size(); ++k) {
                        JSONObject enumItem = enums.getJSONObject(k);
                        enumBuilder.append(enumItem.getString("value")).append("=").append(enumItem.getString("description"));
                        if (k >= enums.size() - 1) continue;
                        enumBuilder.append("\n");
                    }
                }
                StringBuilder sampleBuilder = new StringBuilder();
                markdown.append("| `").append(name).append("` ").append("| ").append(title != null ? title : "-").append(" | ").append(dataType != null ? dataType : "-").append(" | ").append(fieldDesc != null ? fieldDesc : "-").append(" | ").append(enumBuilder.length() > 0 ? enumBuilder : "-").append(" | ").append(sampleBuilder.length() > 0 ? sampleBuilder : "-").append(" |\n");
            }
            markdown.append("\n---\n\n");
        }
        return markdown.toString();
    }

    public static String getLastContent(String str) {
        if (str == null) {
            return "";
        }
        int lastDotIndex = str.lastIndexOf(46);
        if (lastDotIndex == -1 || lastDotIndex == str.length() - 1) {
            return "";
        }
        return str.substring(lastDotIndex + 1);
    }

    public static String getLastDotAndContent(String str) {
        if (str == null) {
            return "";
        }
        int lastDotIndex = str.lastIndexOf(46);
        if (lastDotIndex == -1 || lastDotIndex == str.length() - 1) {
            return "";
        }
        return str.substring(lastDotIndex);
    }

    public static String getContentBeforeLastDot(String str) {
        if (str == null) {
            return "";
        }
        int lastDotIndex = str.lastIndexOf(46);
        if (lastDotIndex <= 0) {
            return str;
        }
        return str.substring(0, lastDotIndex);
    }

    public static String getKnowledgeType(String filename) {
        Pattern pattern = Pattern.compile(".*/([^/]+)/[^/]+$");
        Matcher matcher = pattern.matcher(filename);
        if (matcher.find()) {
            String targetDir = matcher.group(1);
            return targetDir;
        }
        return null;
    }

    public static String removeCodeFences(String markdown) {
        if (markdown == null || markdown.isEmpty()) {
            return markdown;
        }
        Pattern pattern = Pattern.compile("(?s)```\\s*\\w*\\s*\\n(.*?)```");
        Matcher matcher = pattern.matcher(markdown);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group(1).trim() + "\n"));
        }
        matcher.appendTail(sb);
        return sb.toString().trim();
    }

    public static String cleanMarkdownTags(String content) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        Matcher matcher = CODE_BLOCK_PATTERN.matcher(content);
        return matcher.replaceAll("$1");
    }

    public static void main(String[] args) {
        String originalContent = "\u4ee5\u4e0b\u662f\u751f\u6210\u7684HTML\u548cJSON\u5185\u5bb9\uff1a\n\n```html\n<div class=\"container\">\n  <p>Hello World</p>\n</div>\n```\n\n\u4e0a\u9762\u7684HTML\u5bf9\u5e94\u7684JSON\u6570\u636e\uff1a\n\n```json\n{\n  \"title\": \"\u793a\u4f8b\",\n  \"content\": \"Hello World\"\n}\n```\n\n\u8bf7\u6839\u636e\u4ee5\u4e0a\u5185\u5bb9\u5904\u7406\u3002";
        String cleanedContent = StringUtil.removeCodeFences((String)originalContent);
        System.out.println(cleanedContent);
    }
}

