/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.ResultBean;
import com.digiwin.chatbi.common.DmcServiceInvoker;
import com.digiwin.chatbi.mapper.mysql.onlyRead.ReportReadMapper;
import com.digiwin.chatbi.mapper.mysql.readAndWrite.ReportWriteMapper;
import com.digiwin.chatbi.mapper.mysql.readAndWrite.UserReportRelationMapper;
import com.digiwin.chatbi.mapper.mysql.readAndWrite.UserReportsMapper;
import com.digiwin.chatbi.reasoning.executor.extract.autoData.DataRetrievalExecutorSingleThread;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.AiMockDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"scrumbi/aimock"})
@Api(value="AiMockDataController", tags={"AiMockDataController"})
public class AiMockDataController {
    @Resource
    private AiMockDataService aiMockDataService;
    @Resource
    private DmcServiceInvoker dmcServiceInvoker;
    @Resource
    private ReportWriteMapper reportMapper;
    @Resource
    private ReportReadMapper reportReadMapper;
    @Resource
    private UserReportRelationMapper userReportRelationMapper;
    @Resource
    private UserReportsMapper userReportsMapper;
    @Resource
    private DataRetrievalExecutorSingleThread dataRetrievalExecutorSingleThread;

    @ApiOperation(value="\u901a\u8fc7gpt\u751f\u6210mock\u6570\u636e")
    @PostMapping(value={"/create"})
    public ResultBean<Object> create(@RequestBody JSONObject param) throws Exception {
        try {
            return ResultBean.ok((Object)this.aiMockDataService.create(param));
        }
        catch (Exception e) {
            return ResultBean.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="test")
    @PostMapping(value={"/test"})
    public ResultBean<Object> test(@RequestBody JSONObject param) throws Exception {
        try {
            return ResultBean.ok((Object)this.aiMockDataService.apolloTest());
        }
        catch (Exception e) {
            return ResultBean.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="report")
    @PostMapping(value={"/report"})
    public ResultBean<Object> report(@RequestBody JSONObject param) throws Exception {
        try {
            return ResultBean.ok();
        }
        catch (Exception e) {
            return ResultBean.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="demo\u95ee\u6570\u63a5\u53e3")
    @PostMapping(value={"/retrieval"})
    public ResultBean<List<JSONObject>> dataRetrieval(@RequestBody JSONObject param, HttpServletRequest request) {
        try {
            String token = request.getHeader("token");
            String routerKey = request.getHeader("routerKey");
            String locale = request.getHeader("locale");
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{token, routerKey})) {
                return ResultBean.fail((String)"token\u6216routerKey\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Output output = this.dataRetrievalExecutorSingleThread.doProcess(param, token, routerKey, locale);
            if (output == null || output.getOutputContext() == null) {
                return ResultBean.fail((String)"\u53d6\u6570\u7ed3\u679c\u4e3a\u7a7a");
            }
            JSONObject outputContext = output.getOutputContext();
            if (outputContext.containsKey((Object)"reply")) {
                JSONObject replyResult = new JSONObject();
                replyResult.put("reply", (Object)outputContext.getString("reply"));
                replyResult.put("type", (Object)"REPLY");
                ArrayList<JSONObject> replyList = new ArrayList<JSONObject>();
                replyList.add(replyResult);
                return ResultBean.ok(replyList);
            }
            JSONObject retrievalDatas = outputContext.getJSONObject("retrievalDatas");
            String snapshotId = outputContext.getString("snapshotId");
            if (retrievalDatas == null) {
                throw new IllegalArgumentException("\u5f53\u524d\u6761\u4ef6\u65e0\u6cd5\u67e5\u5230\u76f8\u5173\u6570\u636e");
            }
            JSONArray dataArray = retrievalDatas.getJSONArray("data");
            if (dataArray == null || dataArray.isEmpty()) {
                throw new IllegalArgumentException("\u5f53\u524d\u6761\u4ef6\u65e0\u6cd5\u67e5\u5230\u76f8\u5173\u6570\u636e");
            }
            List resultList = dataArray.toJavaList(JSONObject.class);
            JSONObject wrapperObj = new JSONObject();
            wrapperObj.put("snapshotId", (Object)(snapshotId != null ? snapshotId : ""));
            wrapperObj.put("data", (Object)resultList);
            ArrayList<JSONObject> finalResult = new ArrayList<JSONObject>();
            finalResult.add(wrapperObj);
            return ResultBean.ok(finalResult);
        }
        catch (Exception e) {
            return ResultBean.fail((String)("\u53d6\u6570\u5931\u8d25: " + e.getMessage()));
        }
    }
}

