/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.loader;

import com.digiwin.chatbi.config.PromptAssemblyConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class YamlPromptConfigLoader {
    private static final Logger log = LoggerFactory.getLogger(YamlPromptConfigLoader.class);
    private final ObjectMapper yamlMapper = new YAMLMapper();
    private final PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();

    public List<PromptAssemblyConfig> loadAllConfigs() {
        ArrayList<PromptAssemblyConfig> configs = new ArrayList<PromptAssemblyConfig>();
        try {
            Resource[] resources;
            for (Resource resource : resources = this.resourceResolver.getResources("classpath:promptEngineering/**/*_assembled.yml")) {
                try {
                    PromptAssemblyConfig config = this.loadConfig(resource);
                    if (config == null) continue;
                    configs.add(config);
                }
                catch (Exception e) {
                    log.error("Failed to load YAML config from resource: {}", (Object)resource, (Object)e);
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to scan for YAML config files", (Throwable)e);
        }
        return configs;
    }

    public PromptAssemblyConfig loadConfig(Resource resource) throws IOException {
        try (InputStream inputStream = resource.getInputStream();){
            PromptAssemblyConfig config = (PromptAssemblyConfig)this.yamlMapper.readValue(inputStream, PromptAssemblyConfig.class);
            this.validateConfig(config);
            PromptAssemblyConfig promptAssemblyConfig = config;
            return promptAssemblyConfig;
        }
    }

    public PromptAssemblyConfig loadConfigFromPath(String configPath) throws IOException {
        Resource resource = this.resourceResolver.getResource("classpath:" + configPath);
        return this.loadConfig(resource);
    }

    private void validateConfig(PromptAssemblyConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        if (config.getName() == null || config.getName().trim().isEmpty()) {
            throw new IllegalArgumentException("Configuration name cannot be empty");
        }
        if (config.getType() == null || config.getType().trim().isEmpty()) {
            throw new IllegalArgumentException("Configuration type cannot be empty");
        }
        if (config.getComponents() == null || config.getComponents().isEmpty()) {
            throw new IllegalArgumentException("Configuration must have at least one component");
        }
        log.debug("Configuration validation passed for: {}", (Object)config.getName());
    }
}

