/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.datasource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.beans.pojos.vector.SearchDocsQo;
import com.digiwin.chatbi.beans.pojos.vector.SearchDocsResult;
import com.digiwin.chatbi.common.exception.KnowledgeBaseOperationAssert;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.KnowledgeBaseService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;

public class MatchVectorTemplate
implements Executor {
    private final Double scoreThreshold = 1.0;

    public Output doProcess(JSONObject context) {
        return Output.through((JSONObject)this.getModelDataSource(Retrieve.TEMPLATE.getIndexName(), (Question)context.getObject("question", Question.class)));
    }

    private JSONObject getModelDataSource(String databaseName, Question question) {
        SearchDocsQo searchDocsQo = this.getSearchDocsQo(databaseName, question);
        StopWatch stopWatch = StopWatch.createStarted();
        List searchDocsResults = (List)KnowledgeBaseOperationAssert.DATA_SOURCE_QUERY_RESPONSE_REQUEST_FAILED_ASSERT.tryCatch(() -> ((KnowledgeBaseService)SpringContextUtil.getBean(KnowledgeBaseService.class)).searchDocs(searchDocsQo), new Object[0]);
        stopWatch.stop();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("templates", searchDocsResults.stream().map(SearchDocsResult::getPage_content).map(JSON::parseObject).collect(Collectors.toList()));
        return jsonObject;
    }

    private SearchDocsQo getSearchDocsQo(String knowledgeBaseName, Question question) {
        SearchDocsQo searchDocsQo = new SearchDocsQo();
        searchDocsQo.setQuery(question.getMessage().replace("explain:", ""));
        searchDocsQo.setKnowledge_base_name(knowledgeBaseName);
        searchDocsQo.setTop_k(question.getSceneTopK());
        searchDocsQo.setScore_threshold(this.scoreThreshold);
        return searchDocsQo;
    }
}

