/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCompleteRecommendedExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(AutoCompleteRecommendedExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_metric");
    }

    public Output doProcess(JSONObject context) {
        String autoCompleteRecommendedGptName = "Autocomplete_Rec";
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            autoCompleteRecommendedGptName = autoCompleteRecommendedGptName + "_V1";
        } else if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion)) {
            autoCompleteRecommendedGptName = autoCompleteRecommendedGptName + "_V2";
        }
        JSONObject result = context.getJSONObject(autoCompleteRecommendedGptName);
        log.info("gpt output auto complete recommended {}", (Object)result);
        ArrayList<String> sentences = new ArrayList<String>();
        try {
            if (result == null || CollectionUtils.isEmpty((Collection)result.getJSONArray("recommendation_question"))) {
                log.info("\u83b7\u53d6\u63a8\u8350\u95ee\u53e5\u7684GPT\u8f93\u51fa\u7684\u4f8b\u53e5\u4e3a\u7a7a");
                return Output.through();
            }
            String locale = ((Question)context.getObject("question", Question.class)).getLocale();
            JSONArray jsonArray = result.getJSONArray("recommendation_question");
            for (Object str : jsonArray) {
                String sentence = (String)str;
                sentences.add("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)sentence) : ZhConverterUtil.toSimple((String)sentence));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u63a8\u8350\u95ee\u53e5\u7684GPT\u8f93\u51fa\u7684\u4f8b\u53e5\u5f02\u5e38", (Throwable)e);
        }
        return Output.through((String)"sentences", sentences);
    }
}

