/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.enums.DebugMode;
import com.digiwin.chatbi.common.enums.SpecialModeEnum;
import com.digiwin.chatbi.common.util.DateTimeUtil;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.config.LeadCorrectSentences;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.KnowledgemapsService;
import com.digiwin.chatbi.service.MessageUtils;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildTargetDataSourceExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(BuildTargetDataSourceExecutor.class);
    public static final String ANALYSIS_APPEND_EX = "%s=%s";

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_scene") || context.containsKey((Object)"scelect_scene_metric_mix");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Output doProcess(JSONObject context) {
        Output output = Output.through();
        Question question = (Question)context.getObject("question", Question.class);
        String questionMsg = question.getMessage().replace("explain:", "");
        String sceneCode = question.getSceneCode();
        String debugMode = question.getDebugMode();
        Boolean multiDialogue = question.isMultiDialogue();
        JSONObject input = new JSONObject();
        input.put("applicationCodes", Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class));
        input.put("version", (Object)context.getString("version"));
        input.put("question", (Object)questionMsg);
        input.put("debugMode", (Object)debugMode);
        input.put("sceneCode", (Object)sceneCode);
        input.put("multiDialogue", (Object)multiDialogue);
        if (context.containsKey((Object)"scelect_scene") || context.containsKey((Object)"scelect_scene_metric_mix")) {
            List allSchemas = Optional.ofNullable(Retrieve.DICTIONARY.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
            List targets = (List)context.getOrDefault((Object)"mixModeTargets", new ArrayList());
            if (CollectionUtils.isEmpty((Collection)targets)) {
                return Output.finish((String)"sentences", (Object)LeadCorrectSentences.achieveRandomSens((Map)((Map)context.get((Object)"locale_sentences")))).keep("reply", (Object)"message.scrumbi.no.target.alike").keep("target_size", (Object)0).keep("logProblemDescription", Constants.NO_TARGET_LOG_VALUE.get(0)).keep("logTimestamp", (Object)DateTimeUtil.format((Date)new Date())).keep("logErrorContent", Constants.NO_TARGET_LOG_VALUE.get(1)).keep("logTroubleGuide", Constants.NO_TARGET_LOG_VALUE.get(2)).keep("logKey", (Object)"\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}").keep("no_target", (Object)"Y");
            }
            if (targets.size() > 1) {
                if (!Objects.isNull(multiDialogue) && multiDialogue.booleanValue()) {
                    HashMap result = new HashMap();
                    targets.stream().map(t -> t.getString("datasourceId")).forEach(id -> result.put(id, (List)((Map)context.get((Object)"locale_sentences")).get(id)));
                    context.put("special_mode", (Object)SpecialModeEnum.MORE_TARGET.getValue());
                    ArrayList list = new ArrayList();
                    String locale = ((Question)context.getObject("question", Question.class)).getLocale();
                    targets.forEach(t -> {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("targetId", (Object)t.getString("datasourceId"));
                        jsonObject.put("targetName", (Object)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)t.getString("datasourceName")) : ZhConverterUtil.toSimple((String)t.getString("datasourceName"))));
                        list.add(jsonObject);
                    });
                    context.put("more_target", list);
                    MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                    String param = StringUtil.formatListToBrackets(new ArrayList(new HashSet(targets.stream().map(t -> t.getString("datasourceName")).collect(Collectors.toList()))), (String)locale);
                    String reply = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.one.more.target", locale, new Object[]{param});
                    return Output.finish((String)"sentences", (Object)LeadCorrectSentences.achieveRandomSens(result)).keep("target_size", (Object)targets.size()).keep("reply", (Object)reply).keep("scelect_scene", (Object)true);
                }
                JSONObject jsonObject = (JSONObject)targets.get(0);
                targets.clear();
                targets.add(jsonObject);
            } else {
                JSONObject existing = (JSONObject)targets.get(0);
                List existSchemasVolidate = allSchemas.stream().filter(a -> existing.getString("applicationCode").equals(a.getString("applicationCode")) && existing.getString("version").equals(a.getString("version"))).map(a -> a.getString("name")).collect(Collectors.toList());
                JSONArray jsonArray = CollectionUtils.isEmpty((Collection)existing.getJSONArray("schemas")) ? new JSONArray() : existing.getJSONArray("schemas");
                jsonArray = JSONArray.parseArray((String)JSON.toJSONString(jsonArray.stream().filter(j -> existSchemasVolidate.contains(((JSONObject)j).getString("name"))).collect(Collectors.toList())));
                existing.put("schemas", jsonArray.stream().distinct().collect(Collectors.toList()));
                targets.clear();
                targets.add(existing);
            }
            HashSet appedAnalysisWords = new HashSet();
            JSONObject sceneBySceneCode = null;
            if (StringUtils.isNotEmpty((CharSequence)sceneCode)) {
                KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
                JSONObject params = new JSONObject();
                params.put("sceneCode", (Object)sceneCode);
                try {
                    ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
                    params.put("applicationCodes", applicationCodes);
                    params.put("version", (Object)context.getString("version"));
                    sceneBySceneCode = bean.querySceneMaps(params, context);
                }
                catch (Exception e) {
                    log.info("\u68c0\u67e5\u5230\u5165\u53c2\u7684\u573a\u666f\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u67e5\u8be2km\u5f02\u5e38");
                }
                if (Objects.isNull(sceneBySceneCode)) {
                    return Output.finish((String)"sceneNotExist", (Object)"1").keep("reply", (Object)"message.scrumbi.check.scenes").keep("target_size", (Object)targets.size());
                }
            }
            JSONObject finalSceneBySceneCode = sceneBySceneCode;
            targets.stream().peek(datasource -> {
                List collect;
                JSONArray schemas = datasource.getJSONArray("schemas");
                if (StringUtils.isNotEmpty((CharSequence)sceneCode) && (DebugMode.DEBUG.getCode().equals(debugMode) || DebugMode.PR_PARAM.getCode().equals(debugMode))) {
                    KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
                    if (DebugMode.DEBUG.getCode().equals(debugMode)) {
                        datasource.put("datasourceId", (Object)finalSceneBySceneCode.getString("targetId"));
                        datasource.put("datasourceName", (Object)finalSceneBySceneCode.getString("targetName"));
                    }
                    try {
                        JSONObject schemasBySceneCode = bean.getSchemasBySceneCode(sceneCode, context);
                        schemas = Objects.isNull(schemasBySceneCode) ? new JSONArray() : schemasBySceneCode.getJSONArray("schemas");
                        List schemasVolidate = allSchemas.stream().filter(a -> schemasBySceneCode.getString("applicationCode").equals(a.getString("applicationCode")) && schemasBySceneCode.getString("version").equals(a.getString("version"))).map(a -> a.getString("name")).collect(Collectors.toList());
                        log.info("\u67e5\u8be2\u5230\u7684schemasVolidate\uff1a{}", schemasVolidate);
                        List objects = schemas.stream().filter(s -> schemasVolidate.contains(((JSONObject)s).getString("name"))).collect(Collectors.toList());
                        schemas.clear();
                        for (Object object : objects) {
                            schemas.add(object);
                        }
                    }
                    catch (Exception e2) {
                        log.error("\u83b7\u53d6\u573a\u666f\u5931\u8d25", (Throwable)e2);
                    }
                }
                if (CollectionUtils.isNotEmpty(collect = schemas.stream().map(schema -> (JSONObject)schema).peek(schema -> {
                    schema.remove((Object)"hasDefault");
                    schema.remove((Object)"required");
                    schema.remove((Object)"ifChecked");
                }).collect(Collectors.toList()))) {
                    collect.removeIf(schema -> "MONTH".equals(schema.getString("name")));
                    boolean hasEocCompanyName = collect.stream().anyMatch(schema -> "eoc_company_name".equals(schema.getString("name")));
                    if (this.checkCompanyIsExist(context) && !hasEocCompanyName) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("dataType", (Object)"string");
                        jsonObject.put("name", (Object)"eoc_company_name");
                        jsonObject.put("title", (Object)"\u516c\u53f8\u540d\u79f0");
                        collect.add(jsonObject);
                    }
                }
                JSONObject schemaJsonObject = new JSONObject();
                schemaJsonObject.put("Schemas", collect);
                log.info("output end dict Schemas:{}", collect);
                datasource.put("schemas", (Object)schemaJsonObject);
                datasource.put("schemasNames", collect.stream().map(e -> e.getString("name")).collect(Collectors.toList()));
                List synonyms = (List)datasource.getObject("synonym", ArrayList.class);
                String datasourceName = datasource.getString("datasourceName");
                if (CollectionUtils.isNotEmpty((Collection)synonyms) && StringUtils.isNotBlank((CharSequence)datasourceName)) {
                    synonyms.stream().forEach(sy -> {
                        if (questionMsg.contains((CharSequence)sy) && !datasourceName.equals(sy)) {
                            appedAnalysisWords.add(String.format(ANALYSIS_APPEND_EX, sy, datasourceName));
                        }
                    });
                }
            }).forEach(arg_0 -> ((Output)output).keep(arg_0));
            List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
            LogCheckDto logCheckDto = new LogCheckDto();
            JSONObject result = new JSONObject();
            result.put("targets", (Object)targets);
            logCheckDto.buildParams("SearchTargetsource", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
            logCheckDtos.add(logCheckDto);
            output.keep("targets", (Object)targets).keep("appedAnalysisWords", appedAnalysisWords).keep("target_size", (Object)targets.size()).keep("logCheckDtos", logCheckDtos);
        }
        return output;
    }

    private boolean checkCompanyIsExist(JSONObject context) {
        List companyWords = (List)context.get((Object)"originalStandardWords");
        if (CollectionUtils.isNotEmpty((Collection)companyWords)) {
            for (JSONObject companyWord : companyWords) {
                if (!"\u516c\u53f8\u540d\u79f0".equals(companyWord.getString("entity_type"))) continue;
                return true;
            }
        }
        return false;
    }
}

