/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.NoneMetricSuggestedQuestionExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class NoneMetricSuggestedQuestionExecutor
implements Executor {
    private static int topK = 3;

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        JSONObject dslParam = new JSONObject();
        dslParam.put("question", (Object)question);
        dslParam.put("appCodesCondition", context.get((Object)"appCodesCondition"));
        dslParam.put("version", (Object)context.getString("version"));
        if (context.containsKey((Object)"dataSets_all_permission") && !context.getBoolean("dataSets_all_permission").booleanValue()) {
            List dataSets_with_permission = (List)context.getOrDefault((Object)"dataSets_with_permission", new ArrayList());
            dslParam.put("datasetIds", dataSets_with_permission.stream().map(dataSet -> dataSet.getString("datasetId")).collect(Collectors.toList()));
        }
        JSONObject tables = (ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion) ? Retrieve.MATCH_SIMILAR_QUESTION_V2 : Retrieve.MATCH_SIMILAR_QUESTION_V1).retrieve(dslParam);
        List sentences = NoneMetricSuggestedQuestionExecutor.extractTopKQuestions((JSONObject)tables, (int)topK);
        return Output.finish((String)"sentences", (Object)sentences).keep("success", (Object)false);
    }

    public static List<String> extractTopKQuestions(JSONObject esResult, int topK) {
        ArrayList<QuestionScore> allQuestions = new ArrayList<QuestionScore>();
        JSONArray hits = esResult.getJSONObject("hits").getJSONArray("hits");
        for (int i = 0; i < hits.size(); ++i) {
            JSONObject hit = hits.getJSONObject(i);
            JSONObject highlight = hit.getJSONObject("highlight");
            if (highlight == null || !highlight.containsKey((Object)"questions.question")) continue;
            JSONArray questions = highlight.getJSONArray("questions.question");
            for (int j = 0; j < questions.size(); ++j) {
                String rawQuestion = questions.getString(j);
                int markCount = NoneMetricSuggestedQuestionExecutor.countMarkTags((String)rawQuestion);
                String cleanQuestion = NoneMetricSuggestedQuestionExecutor.removeMarkTags((String)rawQuestion);
                allQuestions.add(new QuestionScore(cleanQuestion, markCount));
            }
        }
        return allQuestions.stream().sorted(Comparator.comparingInt(QuestionScore::getScore).reversed()).limit(topK).map(QuestionScore::getQuestion).collect(Collectors.toList());
    }

    private static int countMarkTags(String str) {
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf("<mark>", idx)) != -1) {
            ++count;
            idx += "<mark>".length();
        }
        return count;
    }

    private static String removeMarkTags(String str) {
        return str.replaceAll("</?mark>", "");
    }
}

