/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.KnowledgemapsService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAppAndVersionExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchAppAndVersionExecutor.class);

    public Output doProcess(JSONObject context) {
        LogCheckDto logCheckDto;
        String tenantId;
        String tenantVersion;
        List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        String userToken = ((Question)context.getObject("question", Question.class)).getToken();
        String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
        String appCode = ((Question)context.getObject("question", Question.class)).getAppCode();
        String userId = ((Question)context.getObject("question", Question.class)).getUserId();
        log.info("SearchAppAndVersionExecutor routerKey is exist: {}", (Object)routerKey);
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            return Output.through((String)"version", (Object)"2.0");
        }
        JSONObject res = null;
        List<Object> tenantAppCodes = new ArrayList();
        List<Object> applications = new ArrayList();
        JSONObject input = new JSONObject();
        input.put("userToken", (Object)userToken);
        input.put("routerKey", (Object)routerKey);
        input.put("userId", (Object)userId);
        try {
            KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
            res = bean.getUserAppAndVersion(userToken, routerKey, userId);
            JSONArray tenantAppInfos = res.getJSONObject("response").getJSONArray("appCodes");
            tenantAppCodes = tenantAppInfos.stream().map(Object::toString).collect(Collectors.toList());
            tenantVersion = res.getJSONObject("response").getString("tenantVersion");
            tenantId = res.getJSONObject("profile").getString("tenantId");
            userId = res.getJSONObject("profile").getString("userId");
            applications = (List)res.getJSONObject("response").getObject("applications", List.class);
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u6743\u9650\u83b7\u53d6\u7528\u6237\u5e94\u7528\u548c\u7248\u672c\u67e5\u8be2\u5931\u8d25:{}", (Throwable)e);
            LogCheckDto logCheckDto2 = new LogCheckDto();
            StringBuilder result = new StringBuilder();
            result.append("\u67e5\u8be2\u7528\u6237\u8ba2\u8d2d\u7684\u5e94\u7528\u548c\u79df\u6237\u7248\u672c\u5931\u8d25\uff0c\u53ef\u80fd\u662fKM\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0:").append("\u3010").append(e.getMessage()).append("\u3011");
            logCheckDto2.buildParams("SearchAppAndVersion", "P.SCRUMBI.901.0105", input.toJSONString(), result.toString(), "\u8bf7\u7b49\u5f853\u5206\u949f\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5KM\u670d\u52a1");
            logCheckDtos.add(logCheckDto2);
            return Output.finish().keep("reply", (Object)"\u7528\u6237\u6743\u9650\u83b7\u53d6\u7528\u6237\u5e94\u7528\u548c\u7248\u672c\u67e5\u8be2\u5931\u8d25").keep("logCheckDtos", logCheckDtos);
        }
        if (Objects.isNull(res) || StringUtils.isEmpty((CharSequence)tenantVersion) || CollectionUtils.isEmpty(tenantAppCodes)) {
            logCheckDto = new LogCheckDto();
            StringBuilder result = new StringBuilder();
            result.append("\u67e5\u8be2\u7528\u6237\u8ba2\u8d2d\u7684\u5e94\u7528\u548c\u79df\u6237\u7248\u672c\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662fKM\u670d\u52a1\u4e0d\u53ef\u7528");
            logCheckDto.buildParams("SearchAppAndVersion", "P.SCRUMBI.901.0105", input.toJSONString(), res.toJSONString(), "\u8bf7\u7b49\u5f853\u5206\u949f\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5KM\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
            return Output.finish().keep("reply", (Object)"\u7528\u6237\u6743\u9650\u83b7\u53d6\u7528\u6237\u5e94\u7528\u548c\u7248\u672c\u67e5\u8be2\u5931\u8d25").keep("logCheckDtos", logCheckDtos);
        }
        log.info("SearchAppAndVersionExecutor version is: {}", (Object)tenantVersion);
        log.info("SearchAppAndVersionExecutor tenantAppCodes is: {}", tenantAppCodes);
        if (!this.checkAppPermission(context, tenantAppCodes).booleanValue()) {
            logCheckDto = new LogCheckDto();
            input.put("tenantAppCodes", tenantAppCodes);
            String applicationCode = ((Question)context.getObject("question", Question.class)).getAppCode();
            logCheckDto.buildParams("SearchAppAndVersion", "U.SCRUMBI.901.0106", input.toJSONString(), "\u8bc6\u522b\u5230\u7528\u6237\u65e0\u6b64\u5e94\u7528\u3010" + applicationCode + "\u3011" + "\u7684\u6743\u9650", "1.\u767b\u5f55\u9f0e\u6377\u4e91\u7684\u7528\u6237\u7ba1\u7406\u6a21\u5757\u3002\n2.\u641c\u7d22\u5e76\u627e\u5230\u7528\u6237\u3010" + userId + "\u3011" + "\u7684\u6743\u9650\u8bbe\u7f6e\u9875\u9762\u3002\n3.\u70b9\u51fb\u201c\u7f16\u8f91\u201d\u4e3a\u7528\u6237\u6dfb\u52a0" + "\u3010" + applicationCode + "\u3011" + "\u7684\u6743\u9650\u3002\n4.\u8ba9\u7528\u6237\u91cd\u65b0\u767b\u5f55\uff0c\u68c0\u67e5\u662f\u5426\u80fd\u6b63\u5e38\u4f7f\u7528\u5e94\u7528\uff0c\u82e5\u4e0d\u80fd\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            String locale = ((Question)context.getObject("question", Question.class)).getLocale();
            return Output.finish().keep("reply", (Object)"message.scrumbi.no.appcode.permission").keep("logCheckDtos", logCheckDtos);
        }
        if (StringUtils.isNotEmpty((CharSequence)appCode)) {
            tenantAppCodes = Arrays.asList(appCode);
        }
        List<Object> appSystems = new ArrayList();
        HashMap<String, String> appMap = new HashMap<String, String>();
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        Integer appType = 6;
        if (StringUtils.isEmpty((CharSequence)productVersion) || ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            appType = 6;
        } else if (ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion)) {
            appType = 12;
        }
        if (CollectionUtils.isNotEmpty(applications)) {
            if (StringUtils.isNotEmpty((CharSequence)appCode)) {
                applications = applications.stream().filter(app -> appCode.equals(app.get("application"))).collect(Collectors.toList());
            }
            if (Objects.nonNull(appType)) {
                Integer finalAppType = appType;
                applications = applications.stream().filter(app -> finalAppType == app.get("appType")).collect(Collectors.toList());
            }
            appSystems = applications.stream().map(app -> {
                if (Objects.isNull(app.get("appSystem"))) {
                    return null;
                }
                return app.get("appSystem").toString();
            }).collect(Collectors.toList());
            for (HashMap application : applications) {
                appMap.put(application.get("application").toString(), application.get("name").toString());
            }
        }
        List appCodes = applications.stream().map(app -> app.get("code").toString()).collect(Collectors.toList());
        tenantAppCodes = tenantAppCodes.stream().filter(tAppCode -> appCodes.contains(tAppCode)).collect(Collectors.toList());
        LogCheckDto logCheckDto3 = new LogCheckDto();
        JSONObject result = new JSONObject();
        result.put("version", (Object)tenantVersion);
        result.put("applicationCodes", tenantAppCodes);
        result.put("tenantId", (Object)tenantId);
        result.put("userId", (Object)userId);
        logCheckDto3.buildParams("SearchAppAndVersion", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
        logCheckDtos.add(logCheckDto3);
        return Output.through((String)"version", (Object)tenantVersion).keep("applicationCodes", tenantAppCodes).keep("tenantId", (Object)tenantId).keep("userId", (Object)userId).keep("appSystems", appSystems).keep("appMap", appMap).keep("logCheckDtos", logCheckDtos);
    }

    private Boolean checkAppPermission(JSONObject context, List<String> tenantAppCodes) {
        String applicationCode = ((Question)context.getObject("question", Question.class)).getAppCode();
        if (StringUtils.isNotEmpty((CharSequence)applicationCode)) {
            JSONObject jsonObject;
            context.put("switchName", (Object)"appcode_permission_switch");
            List configList = Optional.ofNullable(Retrieve.SWITCH_CONFIG.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            if (CollectionUtils.isNotEmpty((Collection)configList) && Constants.APPCODE_PERMISSION_OPEN.equals((jsonObject = (JSONObject)configList.get(0)).getInteger("value"))) {
                return tenantAppCodes.contains(applicationCode);
            }
        }
        return true;
    }
}

