/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchFewShotExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchFewShotExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_scene") || context.containsKey((Object)"scelect_scene_metric_mix");
    }

    public Output doProcess(JSONObject context) {
        List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        StringBuilder dimensionFewShot = null;
        StringBuilder filterFewShot = null;
        StringBuilder sortAndLimitFewShot = null;
        StringBuilder analysisPlanningFewShot = null;
        List hits = null;
        JSONObject input = new JSONObject();
        input.put("question", (Object)question);
        try {
            hits = Optional.ofNullable(Retrieve.FEW_SHOT.retrieveQuestion(question, context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> (JSONObject)hit).collect(Collectors.toList())).orElse(Lists.newArrayList());
        }
        catch (Exception e) {
            log.error("SearchFewShotExecutor doProcess error", (Throwable)e);
            LogCheckDto logCheckDto = new LogCheckDto();
            input.put("question", (Object)question);
            logCheckDto.buildParams("SearchFewShot", LogUtils.WARING, input.toJSONString(), "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
        }
        ArrayList<JSONObject> fewShots = new ArrayList<JSONObject>();
        ArrayList<String> idList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)hits)) {
            for (JSONObject hit : hits) {
                fewShots.add(hit.getJSONObject("_source"));
                idList.add(hit.getString("_id"));
            }
        }
        dimensionFewShot = new StringBuilder();
        filterFewShot = new StringBuilder();
        sortAndLimitFewShot = new StringBuilder();
        analysisPlanningFewShot = new StringBuilder();
        if (CollectionUtils.isNotEmpty(fewShots)) {
            for (JSONObject fewShot : fewShots) {
                String fewShotQuestion = fewShot.getString("question");
                if (StringUtils.isNotBlank((CharSequence)fewShot.getString("analysisPlanning"))) {
                    analysisPlanningFewShot.append("##\u793a\u4f8b##\n-\u7528\u6237\u8bed\u53e5:\n    " + fewShotQuestion + "\n-\u8f93\u51fa:\n" + JSONObject.parseObject((String)fewShot.getString("analysisPlanning")).toString() + "\n" + System.lineSeparator());
                }
                if (StringUtils.isNotBlank((CharSequence)fewShot.getString("dimension"))) {
                    dimensionFewShot.append("##\u793a\u4f8b##\n-\u7528\u6237\u8bed\u53e5:\n    " + fewShotQuestion + "\n-\u8f93\u51fa:\n" + JSONObject.parseObject((String)fewShot.getString("dimension")).toString() + "\n" + System.lineSeparator());
                }
                if (StringUtils.isNotBlank((CharSequence)fewShot.getString("filter"))) {
                    filterFewShot.append("\u7528\u6237\u8bed\u53e5 : \"" + fewShotQuestion + "\"\n\u8f93\u51fa : " + JSONObject.parseObject((String)fewShot.getString("filter")).toString() + "\n" + System.lineSeparator());
                }
                if (!StringUtils.isNotBlank((CharSequence)fewShot.getString("sortAndLimit"))) continue;
                sortAndLimitFewShot.append("\u8f93\u5165: \"\"\"" + fewShotQuestion + "\"\"\"\n\u8f93\u51fa: " + JSONObject.parseObject((String)fewShot.getString("sortAndLimit")).toString() + "\n" + System.lineSeparator());
            }
        }
        LogCheckDto logCheckDto = new LogCheckDto();
        JSONObject result = new JSONObject();
        result.put("fewShotIds", idList);
        logCheckDto.buildParams("SearchFewShot", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
        logCheckDtos.add(logCheckDto);
        return Output.through((String)"dimension_fewShot", (Object)dimensionFewShot).keep("filter_fewShot", (Object)filterFewShot).keep("sortAndLimit_fewShot", (Object)sortAndLimitFewShot).keep("analysisPlanning_fewShot", (Object)analysisPlanningFewShot).keep("logCheckDtos", logCheckDtos);
    }
}

