/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.ConvertorJsonCommonMethod;
import com.digiwin.chatbi.common.enums.MetricSearchResultEnum;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.DataProcessAfterSearchExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.TranslateService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SearchMetricRollBackExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchMetricRollBackExecutor.class);
    public static final String SPLITE = "&&&&";

    public Output doProcess(JSONObject context) {
        HashMap groupedMetrics;
        List metrics = null;
        try {
            metrics = this.matchestMetricsSearch(context);
        }
        catch (Exception e) {
            log.error("\u6307\u6807\u641c\u7d22\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)metrics)) {
            log.info("\u641c\u6307\u6807\u6ca1\u641c\u5230");
            context.remove((Object)"not_query_all");
            metrics = Optional.ofNullable(Retrieve.METRIC.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            if (CollectionUtils.isEmpty((Collection)metrics)) {
                return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.no.metric.error");
            }
            Map<String, List<JSONObject>> groupedMetrics2 = metrics.stream().collect(Collectors.groupingBy(metric -> metric.getString("applicationCode")));
            ArrayList gptParam = new ArrayList();
            ArrayList apps = new ArrayList();
            groupedMetrics2.entrySet().forEach(g -> {
                ArrayList metricNames = new ArrayList();
                List value = (List)g.getValue();
                value.forEach(v -> metricNames.add(v.getString("metricName")));
                gptParam.add(metricNames);
                apps.add((String)g.getKey());
            });
            return Output.through((String)MetricSearchResultEnum.NO_METRIC.getKey(), (Object)MetricSearchResultEnum.NO_METRIC.getValue()).keep("all_metric_list", groupedMetrics2).keep("no_metric_gpt_param", (Object)this.buildMetricParams(groupedMetrics2)).keep("no_metric_apps", apps);
        }
        if (Objects.nonNull(metrics) && CollectionUtils.isEmpty((Collection)(metrics = ConvertorJsonCommonMethod.filterMetricPermission((JSONObject)context, (List)metrics)))) {
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.no.metric.permission").keep("no_metric_permission_flag", (Object)1);
        }
        Map<Object, Object> map = groupedMetrics = Objects.isNull(metrics) ? Maps.newHashMap() : metrics.stream().collect(Collectors.groupingBy(metric -> metric.getString("applicationCode")));
        if (groupedMetrics.size() > 1) {
            ArrayList metricsAppInfos = new ArrayList();
            groupedMetrics.entrySet().forEach(g -> {
                JSONObject groupedMetric = (JSONObject)((List)g.getValue()).get(0);
                JSONObject metricsAppInfo = new JSONObject();
                metricsAppInfo.put("applicationCode", (Object)groupedMetric.getString("applicationCode"));
                metricsAppInfo.put("applicationName", (Object)groupedMetric.getString("applicationName"));
                metricsAppInfos.add(metricsAppInfo);
            });
            log.info("\u641c\u6307\u6807\u771f\u8d70\u5230\u591a\u5e94\u7528\u4e86\uff1a{}", (Object)JSONObject.toJSONString((Object)metrics));
            return Output.finish((String)"reply", (Object)"message.scrumbi.more.app").keep(MetricSearchResultEnum.MORE_APP_MORE_METRIC.getKey(), (Object)MetricSearchResultEnum.MORE_APP_MORE_METRIC.getValue()).keep("more_app_list", metricsAppInfos).keep("metric_size", (Object)(Objects.nonNull(metrics) ? metrics.size() : 0));
        }
        return Output.through((String)"final_metric", (Object)metrics).keep(MetricSearchResultEnum.ONE_METRIC.getKey(), (Object)MetricSearchResultEnum.ONE_METRIC.getValue()).keep("metric_size", (Object)(Objects.nonNull(metrics) ? metrics.size() : 0)).keep("billingGoodsId", (Object)(Objects.nonNull(metrics) ? ((JSONObject)metrics.get(0)).getString("billingGoodsId") : ""));
    }

    private List<JSONObject> productPriority(List<JSONObject> metrics) {
        Map<String, List<JSONObject>> tempGroupedMetrics = metrics.stream().collect(Collectors.groupingBy(metric -> metric.getString("applicationCode")));
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        tempGroupedMetrics.values().forEach(tempGroupedMetric -> {
            Map<String, List<JSONObject>> groupedByMetricName = tempGroupedMetric.stream().collect(Collectors.groupingBy(metric -> metric.getString("metricName")));
            List result = groupedByMetricName.values().stream().map(group -> {
                JSONObject nonCommon = group.stream().filter(metric -> !"common".equals(metric.getString("prod"))).findAny().orElse(null);
                return nonCommon != null ? nonCommon : (JSONObject)group.get(0);
            }).collect(Collectors.toList());
            res.addAll(result);
        });
        return res;
    }

    private List<JSONObject> matchestMetricsSearch(JSONObject context) {
        String question;
        String applicationCode = ((Question)context.getObject("question", Question.class)).getAppCode();
        List metricIds = ((Question)context.getObject("question", Question.class)).getMetricIdList();
        List metrics = null;
        if (StringUtils.isNotEmpty((CharSequence)applicationCode)) {
            context.put("appCodesCondition", Arrays.asList(applicationCode));
        } else {
            ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
            context.put("appCodesCondition", applicationCodes);
        }
        if (CollectionUtils.isNotEmpty((Collection)metricIds)) {
            context.put("metricIds", (Object)metricIds);
            metrics = Optional.ofNullable(Retrieve.METRIC.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            return metrics;
        }
        context.put("not_query_all", (Object)"1");
        CharSequence metric_standard_name = context.getString("metric_standard_name");
        Map metricsAndSynonyms = (Map)context.getOrDefault((Object)"metricsAndSynonyms", new HashMap());
        String queryQuestion = question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        CharSequence matchVal = null;
        StringBuilder key = new StringBuilder(queryQuestion);
        if (StringUtils.isNotEmpty((CharSequence)metric_standard_name)) {
            key.append(SPLITE).append((String)metric_standard_name);
        }
        if (!Objects.isNull(metricsAndSynonyms)) {
            metricsAndSynonyms.entrySet().forEach(t -> {
                JSONObject value = (JSONObject)t.getValue();
                JSONArray synonyms = CollectionUtils.isEmpty((Collection)value.getJSONArray("synonyms")) ? new JSONArray() : value.getJSONArray("synonyms");
                synonyms.forEach(s -> key.append(SPLITE).append(s));
            });
        }
        Map cnAndTwMap = this.translate(key.toString());
        if (StringUtils.isEmpty(matchVal)) {
            List metricsSearchedKey = null;
            ArrayList accurateStandardWords = new ArrayList();
            context.put("simplified_use_question", (Object)((JSONObject)cnAndTwMap.get(queryQuestion)).getString("cn"));
            context.put("traditional_use_question", (Object)((JSONObject)cnAndTwMap.get(queryQuestion)).getString("tw"));
            if (StringUtils.isNotEmpty((CharSequence)metric_standard_name)) {
                context.put("simplified_metric_standard_name", (Object)((JSONObject)cnAndTwMap.get(metric_standard_name)).getString("cn"));
                context.put("traditional_metric_standard_name", (Object)((JSONObject)cnAndTwMap.get(metric_standard_name)).getString("tw"));
            }
            metricsSearchedKey = Optional.ofNullable(Retrieve.METRIC.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            log.info("metricsSearchedKey:{}", (Object)metricsSearchedKey);
            if (CollectionUtils.isNotEmpty((Collection)metricsSearchedKey)) {
                List metricNames = metricsSearchedKey.stream().map(t -> t.getString("metricName")).distinct().collect(Collectors.toList());
                Map map = this.translate(String.join((CharSequence)SPLITE, metricNames));
                map.entrySet().forEach(m -> cnAndTwMap.put((String)m.getKey(), (JSONObject)m.getValue()));
                metricNames.forEach(t -> {
                    JSONObject simplifiedMetricsAndSynonyms = (JSONObject)metricsAndSynonyms.get(((JSONObject)cnAndTwMap.get(t)).getString("cn"));
                    JSONObject traditionalmetricsAndSynonyms = (JSONObject)metricsAndSynonyms.get(((JSONObject)cnAndTwMap.get(t)).getString("tw"));
                    if (!Objects.isNull(simplifiedMetricsAndSynonyms)) {
                        accurateStandardWords.add(simplifiedMetricsAndSynonyms);
                    }
                    if (!Objects.isNull(traditionalmetricsAndSynonyms)) {
                        accurateStandardWords.add(traditionalmetricsAndSynonyms);
                    }
                    if (Objects.isNull(simplifiedMetricsAndSynonyms) && Objects.isNull(traditionalmetricsAndSynonyms)) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("standard_name", t);
                        accurateStandardWords.add(jsonObject);
                    }
                });
            }
            log.info("accurateStandardWords:{}", accurateStandardWords);
            for (JSONObject d : accurateStandardWords) {
                d.put("standard_name", (Object)((JSONObject)cnAndTwMap.get(d.getString("standard_name"))).getString("cn"));
                JSONArray synonyms = CollectionUtils.isEmpty((Collection)d.getJSONArray("synonyms")) ? new JSONArray() : d.getJSONArray("synonyms");
                ArrayList<String> distinctSynonyms = new ArrayList<String>();
                for (int i = 0; i < synonyms.size(); ++i) {
                    String traditionalString = synonyms.getString(i);
                    String simplifiedString = ((JSONObject)cnAndTwMap.get(traditionalString)).getString("cn");
                    distinctSynonyms.add(i, simplifiedString);
                }
                d.put("synonyms", (Object)new JSONArray(distinctSynonyms.stream().distinct().collect(Collectors.toList())));
            }
            List standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWords(accurateStandardWords, (String)((JSONObject)cnAndTwMap.get(queryQuestion)).getString("cn"), (String)"standard_name");
            metric_standard_name = standardWords.stream().map(source -> source.getString("standard_name")).collect(Collectors.joining(" "));
            String simplified_metric_standard_name = standardWords.stream().map(source -> ((JSONObject)cnAndTwMap.get(source.getString("standard_name"))).getOrDefault((Object)"cn", (Object)"").toString()).collect(Collectors.joining(" "));
            String traditional_metric_standard_name = standardWords.stream().map(source -> ((JSONObject)cnAndTwMap.get(source.getString("standard_name"))).getOrDefault((Object)"tw", (Object)"").toString()).collect(Collectors.joining(" "));
            if (CollectionUtils.isEmpty((Collection)standardWords) && CollectionUtils.isNotEmpty(accurateStandardWords)) {
                metric_standard_name = accurateStandardWords.stream().map(json -> json.getString("standard_name")).max((name1, name2) -> Integer.compare(name1.length(), name2.length())).get();
                if (StringUtils.isEmpty((CharSequence)simplified_metric_standard_name)) {
                    simplified_metric_standard_name = metric_standard_name;
                    traditional_metric_standard_name = metric_standard_name;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)metric_standard_name)) {
                context.put("simplified_metric_standard_name", (Object)simplified_metric_standard_name);
                context.put("traditional_metric_standard_name", (Object)traditional_metric_standard_name);
                metrics = Optional.ofNullable(Retrieve.METRIC_NOQUESTION.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
                context.put("metric_standard_name", (Object)metric_standard_name);
                if (CollectionUtils.isEmpty((Collection)metrics)) {
                    log.info("\u67e5\u8be2\u6307\u6807\u4e3a\u7a7a\uff0c\u8d70\u515c\u5e95\u903b\u8f91\u7ec4\u88c5\u539f\u53e5\u67e5\u8be2");
                    String originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getOriginFinallyQuestion();
                    JSONObject param = new JSONObject();
                    param.put("applicationCodes", context.get((Object)"applicationCodes"));
                    param.put("version", context.get((Object)"version"));
                    param.put("orginal_question", (Object)(StringUtils.isEmpty((CharSequence)originFinallyQuestion) ? question : originFinallyQuestion));
                    param.put("not_query_all", (Object)"1");
                    metrics = Optional.ofNullable(Retrieve.METRIC.retrieve(param)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
                }
            }
        } else {
            metric_standard_name = matchVal;
            if (StringUtils.isNotEmpty((CharSequence)metric_standard_name)) {
                context.put("simplified_metric_standard_name", (Object)((JSONObject)cnAndTwMap.get(metric_standard_name)).getString("cn"));
                context.put("traditional_metric_standard_name", (Object)((JSONObject)cnAndTwMap.get(metric_standard_name)).getString("tw"));
                metrics = Optional.ofNullable(Retrieve.METRIC_NOQUESTION.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
                context.put("metric_standard_name", (Object)metric_standard_name);
            }
        }
        return metrics;
    }

    private Map<String, JSONObject> translate(String key) {
        TranslateService bean = (TranslateService)SpringContextUtil.getBean(TranslateService.class);
        JSONObject cnAndTw = bean.cnAndTw(key);
        String[] cn = cnAndTw.getString("zh_CN").split(SPLITE);
        String[] tw = cnAndTw.getString("zh_TW").split(SPLITE);
        String[] orginal = key.split(SPLITE);
        HashMap<String, JSONObject> cnAndTwMap = new HashMap<String, JSONObject>();
        log.info("cn\u957f\u5ea6\u4e3a\uff1a{},tw\u957f\u5ea6\u4e3a\uff1a{},orginal\u957f\u5ea6\u4e3a\uff1a{}", new Object[]{cn.length, tw.length, orginal.length});
        for (int i = 0; i < cn.length; ++i) {
            String cnString = cn[i];
            String twString = tw[i];
            JSONObject orginalJsonObject = new JSONObject();
            orginalJsonObject.put("cn", (Object)cnString);
            orginalJsonObject.put("tw", (Object)twString);
            cnAndTwMap.put(orginal[i], orginalJsonObject);
            JSONObject cnStringJsonObject = new JSONObject();
            cnStringJsonObject.put("cn", (Object)cnString);
            cnStringJsonObject.put("tw", (Object)twString);
            cnAndTwMap.put(cnString, cnStringJsonObject);
            JSONObject twStringJsonObject = new JSONObject();
            twStringJsonObject.put("cn", (Object)cnString);
            twStringJsonObject.put("tw", (Object)twString);
            cnAndTwMap.put(twString, twStringJsonObject);
        }
        return cnAndTwMap;
    }

    public String buildMetricParams(Map<String, List<JSONObject>> groupedMetrics) {
        StringBuilder result = new StringBuilder();
        int count = 1;
        for (Map.Entry<String, List<JSONObject>> entry : groupedMetrics.entrySet()) {
            String appName = "\u5e94\u7528" + count;
            List<JSONObject> metrics = entry.getValue();
            String s = this.appendMetricNames(appName, metrics);
            result.append(s);
            ++count;
        }
        return result.toString();
    }

    private String appendMetricNames(String appName, List<JSONObject> metrics) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            result.append(appName).append(":\n");
        }
        for (JSONObject metric : metrics) {
            String metricName = metric.getString("metricName");
            String description = metric.getString("description");
            result.append("  - ").append(metricName).append("\n");
            if (StringUtils.isNotEmpty((CharSequence)description) && !"null".equals(description)) {
                result.append("  - ").append(": ").append(description);
            }
            result.append("\n");
        }
        result.append("\n");
        return result.toString();
    }
}

