/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.ConvertorJsonCommonMethod;
import com.digiwin.chatbi.common.enums.AppSystemEnum;
import com.digiwin.chatbi.common.enums.DebugMode;
import com.digiwin.chatbi.common.enums.MetricSearchResultEnum;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.DataProcessAfterSearchExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.KnowledgemapsService;
import com.digiwin.chatbi.service.MessageUtils;
import com.digiwin.chatbi.service.TranslateService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchMetricTargetMixExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchMetricTargetMixExecutor.class);

    public boolean onCondition(JSONObject context) {
        return AppSystemEnum.METRIC.getValue().equals(context.getString("appSystem"));
    }

    public Output doProcess(JSONObject context) {
        LogCheckDto logCheckDto;
        List targetsAccurateStandardWords;
        List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        JSONObject input = new JSONObject();
        String appSystem = context.getString("appSystem");
        if (AppSystemEnum.DATASET.getValue().equals(appSystem)) {
            return Output.through();
        }
        String targetId = ((Question)context.getObject("question", Question.class)).getTargetId();
        String sceneCode = ((Question)context.getObject("question", Question.class)).getSceneCode();
        if (StringUtils.isEmpty((CharSequence)targetId) && StringUtils.isNotBlank((CharSequence)sceneCode)) {
            targetId = this.queryTargetIdBySceneCode(context, sceneCode);
        }
        List targets = null;
        if (StringUtils.isNotEmpty((CharSequence)targetId)) {
            context.put("targetId", (Object)targetId);
            try {
                targets = Optional.ofNullable(Retrieve.TARGET.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            }
            catch (Exception e) {
                log.error("SearchMetricTargetMixExecutor query ES fail", (Throwable)e);
                LogCheckDto logCheckDto2 = new LogCheckDto();
                input.put("targetId", (Object)targetId);
                logCheckDto2.buildParams("SearchTargetsource", "P.SCRUMBI.502.0204", input.toJSONString(), "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
                logCheckDtos.add(logCheckDto2);
                context.put("logCheckDtos", logCheckDtos);
            }
            if (CollectionUtils.isEmpty((Collection)targets)) {
                log.warn("query target by targetId is empty targetId={}", (Object)targetId);
            }
            return Output.through((String)"mixModeTargets", (Object)targets).keep("mixModeMetrics", new ArrayList());
        }
        List metricIds = ((Question)context.getObject("question", Question.class)).getMetricIdList();
        List metrics = null;
        if (CollectionUtils.isNotEmpty((Collection)metricIds)) {
            context.put("metricIds", (Object)metricIds);
            metrics = Optional.ofNullable(Retrieve.METRIC.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            if (CollectionUtils.isEmpty((Collection)metricIds)) {
                log.warn("query metric by metricId is empty metricIds={}", (Object)metricIds);
            }
            return Output.through((String)"mixModeTargets", new ArrayList()).keep("mixModeMetrics", (Object)metrics);
        }
        context.put("not_query_all", (Object)"1");
        String applicationCode = ((Question)context.getObject("question", Question.class)).getAppCode();
        if (StringUtils.isNotEmpty((CharSequence)applicationCode)) {
            context.put("appCodesCondition", Arrays.asList(applicationCode));
        } else {
            ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
            context.put("appCodesCondition", applicationCodes);
        }
        String questionMsg = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        String originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getOriginFinallyQuestion();
        if (StringUtils.isEmpty((CharSequence)originFinallyQuestion)) {
            originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getMessage();
        }
        JSONObject cnAndTw = this.translateMetric(questionMsg);
        String simplified_use_question = cnAndTw.getString("zh_CN");
        String traditional_use_question = cnAndTw.getString("zh_TW");
        ArrayList allAccurateStandardWords = new ArrayList();
        String strategy = this.specialStrategy(context);
        if ("metric".equals(strategy)) {
            List metricsAccurateStandardWords = this.getMetricsAccurateStandardWords(context, cnAndTw, originFinallyQuestion);
            log.info("metricsAccurateStandardWords = {}", (Object)metricsAccurateStandardWords);
            allAccurateStandardWords.addAll(metricsAccurateStandardWords);
        } else if ("dataflow".equals(strategy)) {
            targetsAccurateStandardWords = this.getTargetsAccurateStandardWords(context, cnAndTw, originFinallyQuestion);
            log.info("targetsAccurateStandardWords = {}", (Object)targetsAccurateStandardWords);
            allAccurateStandardWords.addAll(targetsAccurateStandardWords);
        } else {
            targetsAccurateStandardWords = this.getMixAccurateStandardWords(context, cnAndTw, originFinallyQuestion);
            log.info("targetsAccurateStandardWords = {}", (Object)targetsAccurateStandardWords);
            allAccurateStandardWords.addAll(targetsAccurateStandardWords);
        }
        context.put("mix_standard_synonyms_before_filter", allAccurateStandardWords);
        List standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWordsV3(allAccurateStandardWords, (String)originFinallyQuestion);
        if (CollectionUtils.isEmpty((Collection)standardWords)) {
            standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWordsV3(allAccurateStandardWords, (String)simplified_use_question);
        }
        if (CollectionUtils.isEmpty((Collection)standardWords)) {
            standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWordsV3(allAccurateStandardWords, (String)traditional_use_question);
        }
        if (!"dataflow".equals(strategy) && CollectionUtils.isEmpty((Collection)standardWords)) {
            return this.getMetricByGpt(context, input, logCheckDtos);
        }
        log.info("standardWords:{}", (Object)standardWords);
        context.put("mix_standard_synonyms_after_filter", (Object)standardWords);
        ArrayList<JSONObject> targetStandardWords = new ArrayList<JSONObject>();
        ArrayList<JSONObject> metricStandardWords = new ArrayList<JSONObject>();
        ArrayList<JSONObject> synonymsStandardWords = new ArrayList<JSONObject>();
        for (JSONObject standardWord : standardWords) {
            if ("metric".equals(standardWord.getString("dataSources")) || "synonyms".equals(standardWord.getString("dataSources"))) {
                metricStandardWords.add(standardWord);
            }
            if ("target".equals(standardWord.getString("dataSources")) || "synonyms".equals(standardWord.getString("dataSources"))) {
                targetStandardWords.add(standardWord);
            }
            if (!"synonyms".equals(standardWord.getString("dataSources"))) continue;
            synonymsStandardWords.add(standardWord);
        }
        ArrayList<String> notExistMetricOrTargetNameList = new ArrayList<String>();
        List targetList = new ArrayList();
        if (CollectionUtils.isNotEmpty(targetStandardWords)) {
            context.put("target_standard_synonyms_after_filter", targetStandardWords);
            try {
                targetList = Optional.ofNullable(Retrieve.TARGET_V2.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            }
            catch (Exception e) {
                log.error("SearchMetricTargetMixExecutor query target ES fail", (Throwable)e);
                logCheckDto = new LogCheckDto();
                input.put("target_standard_synonyms_after_filter", targetStandardWords);
                logCheckDto.buildParams("SearchMetricTargetMixExecutor", "P.SCRUMBI.502.0204", input.toJSONString(), "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
                logCheckDtos.add(logCheckDto);
                context.put("logCheckDtos", logCheckDtos);
            }
            for (JSONObject target : targetList) {
                ArrayList<String> compare_fields = new ArrayList<String>();
                for (JSONObject jSONObject : targetStandardWords) {
                    if (!jSONObject.getString("standard_name").equalsIgnoreCase(target.getString("datasourceName"))) continue;
                    compare_fields.add(jSONObject.getString("compare_field"));
                }
                target.put("compare_fields", compare_fields);
            }
        }
        List metricList = new ArrayList();
        if (CollectionUtils.isNotEmpty(metricStandardWords)) {
            context.put("metric_standard_synonyms_after_filter", metricStandardWords);
            try {
                metricList = Optional.ofNullable(Retrieve.METRIC_V2.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            }
            catch (Exception e) {
                log.error("SearchMetricTargetMixExecutor query metric ES fail", (Throwable)e);
                LogCheckDto logCheckDto3 = new LogCheckDto();
                input.put("metric_standard_synonyms_after_filter", metricStandardWords);
                logCheckDto3.buildParams("SearchMetricTargetMixExecutor", "P.SCRUMBI.502.0204", input.toJSONString(), "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
                logCheckDtos.add(logCheckDto3);
                context.put("logCheckDtos", logCheckDtos);
            }
            for (JSONObject metric : metricList) {
                ArrayList<String> compare_fields = new ArrayList<String>();
                for (JSONObject metricStandardWord : metricStandardWords) {
                    if (!metricStandardWord.getString("standard_name").equalsIgnoreCase(metric.getString("metricName"))) continue;
                    compare_fields.add(metricStandardWord.getString("compare_field"));
                }
                metric.put("compare_fields", compare_fields);
            }
        }
        if (CollectionUtils.isNotEmpty(synonymsStandardWords)) {
            ArrayList<String> metricTargetNames = new ArrayList<String>();
            for (JSONObject metric : metricList) {
                metricTargetNames.add(metric.getString("metricName"));
            }
            for (JSONObject target : targetList) {
                metricTargetNames.add(target.getString("datasourceName"));
            }
            if (CollectionUtils.isEmpty(metricTargetNames)) {
                for (JSONObject targetStandardWord : targetStandardWords) {
                    notExistMetricOrTargetNameList.add(targetStandardWord.getString("compare_field"));
                }
            } else {
                Map groupedMap = this.synonymsGroupByPosition(synonymsStandardWords);
                for (Map.Entry entry : groupedMap.entrySet()) {
                    int foundTargetOrMetricSize = ((List)entry.getValue()).size();
                    for (JSONObject jsonObject : (List)entry.getValue()) {
                        if (metricTargetNames.contains(jsonObject.getString("standard_name")) || metricTargetNames.contains(jsonObject.getString("compare_field"))) continue;
                        --foundTargetOrMetricSize;
                    }
                    if (foundTargetOrMetricSize != 0) continue;
                    for (JSONObject synonymsWords : (List)entry.getValue()) {
                        notExistMetricOrTargetNameList.add(synonymsWords.getString("compare_field"));
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(notExistMetricOrTargetNameList)) {
                String locale = ((Question)context.getObject("question", Question.class)).getLocale();
                MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                ArrayList arrayList = new ArrayList(new HashSet(notExistMetricOrTargetNameList));
                String s = StringUtil.formatListToBracketsV2(arrayList);
                String reply = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.not.related.target.metric", locale, new Object[]{s});
                return Output.finish((String)"success", (Object)false).keep("scelect_metric", (Object)true).keep("reply", (Object)reply).keep("mix_standard_synonyms_before_filter", context.getOrDefault((Object)"mix_standard_synonyms_before_filter", new ArrayList())).keep("mix_standard_synonyms_after_filter", context.getOrDefault((Object)"mix_standard_synonyms_after_filter", new ArrayList()));
            }
        }
        if (!"dataflow".equals(strategy) && CollectionUtils.isEmpty(targetList) && CollectionUtils.isEmpty(metricList)) {
            return this.getMetricByGpt(context, input, logCheckDtos);
        }
        if (CollectionUtils.isNotEmpty(metricList) && CollectionUtils.isEmpty(targetList) && Objects.nonNull(metricList) && ConvertorJsonCommonMethod.queryMetricSwitch((JSONObject)context).booleanValue() && CollectionUtils.isEmpty(metricList = ConvertorJsonCommonMethod.filterMetricPermission((JSONObject)context, metricList))) {
            logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchMetricTargetMixExecutor", "U.SCRUMBI.901.0109", input.toJSONString(), "\u8bc6\u522b\u5230\u7528\u6237\u65e0\u6b64\u6307\u6807" + context.getOrDefault((Object)"noPermissionMetrics", new HashSet()).toString() + "\u6743\u9650", "1.\u767b\u5f55\u9f0e\u6377\u4e91\u7684\u6743\u9650\u7ba1\u7406\u90e8\u5206\uff0c\u9009\u62e9\u76f8\u5e94\u7528\u6237\u548c\u5e94\u7528\u3002\n2.\u67e5\u627e\u76f8\u5173\u6307\u6807\uff0c\u67e5\u770b\u5176\u6743\u9650\u8bbe\u7f6e\u3002\n3.\u786e\u4fdd\u7528\u6237\u6216\u7528\u6237\u7ec4\u6709\u76f8\u5e94\u7684\u6307\u6807\u8bbf\u95ee\u6743\u9650\u3002\n4.\u82e5\u6743\u9650\u7f3a\u5931\uff0c\u6dfb\u52a0\u6743\u9650\uff0c\u91cd\u65b0\u6d4b\u8bd5\u6307\u6807\u8bbf\u95ee\uff0c\u82e5\u95ee\u9898\u5b58\u5728\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.no.metric.permission").keep("mix_standard_synonyms_before_filter", context.getOrDefault((Object)"mix_standard_synonyms_before_filter", new ArrayList())).keep("mix_standard_synonyms_after_filter", context.getOrDefault((Object)"mix_standard_synonyms_after_filter", new ArrayList())).keep("no_metric_permission_flag", (Object)1).keep("logCheckDtos", logCheckDtos);
        }
        if (!DebugMode.PR_PARAM.getCode().equals(((Question)context.getObject("question", Question.class)).getDebugMode())) {
            ArrayList appList;
            List applicationNames;
            HashSet<String> appCodes = new HashSet<String>();
            for (JSONObject jsonObject : metricList) {
                appCodes.add(jsonObject.getString("applicationCode"));
            }
            for (JSONObject jsonObject : targetList) {
                appCodes.add(jsonObject.getString("applicationCode"));
            }
            if (appCodes.size() > 1 && CollectionUtils.isNotEmpty((Collection)(applicationNames = this.queryApplicationName(context, appList = new ArrayList(appCodes))))) {
                return Output.finish((String)"reply", (Object)"message.scrumbi.more.app").keep("scelect_metric", (Object)true).keep(MetricSearchResultEnum.MORE_APP_MORE_METRIC.getKey(), (Object)MetricSearchResultEnum.MORE_APP_MORE_METRIC.getValue()).keep("more_app_list", (Object)applicationNames);
            }
        }
        logCheckDto = new LogCheckDto();
        JSONObject result = new JSONObject();
        result.put("mixModeTargets", targetList);
        result.put("mixModeMetrics", metricList);
        logCheckDto.buildParams("SearchMetricTargetMixExecutor", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
        logCheckDtos.add(logCheckDto);
        return Output.through((String)"mixModeTargets", targetList).keep("mixModeMetrics", metricList).keep("logCheckDtos", logCheckDtos).keep("mix_standard_synonyms_before_filter", context.getOrDefault((Object)"mix_standard_synonyms_before_filter", new ArrayList())).keep("mix_standard_synonyms_after_filter", context.getOrDefault((Object)"mix_standard_synonyms_after_filter", new ArrayList()));
    }

    private Output getMetricByGpt(JSONObject context, JSONObject input, List<LogCheckDto> logCheckDtos) {
        context.remove((Object)"not_query_all");
        context.put("scelect_metric", (Object)true);
        List allMetric = Optional.ofNullable(Retrieve.METRIC.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)allMetric)) {
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchMetricTargetMixExecutor", "U.SCRUMBI.901.0110", input.toJSONString(), "\u7528\u6237\u5df2\u8ba2\u8d2d\u5e94\u7528\u4e0b\u65e0\u4efb\u4f55\u6307\u6807\uff0c\u53ef\u80fd\u662f\u79df\u6237\u3010" + context.getString("tenantId") + "\u3011" + "\u548c\u5e94\u7528\u7248\u672c\u4e0d\u76f8\u540c\u6216\u672a\u914d\u7f6e\u5e94\u7528\u6743\u9650", "1.\u786e\u8ba4\u7528\u6237\u6743\u9650\u5728\u6743\u9650\u7ba1\u7406\u754c\u9762\u662f\u5426\u6b63\u786e\u3002\n2.\u95ee\u9898\u662f\u5728\u6d4b\u8bd5\u533a\uff0c\u79df\u6237\u7248\u672c1.0\u9700\u53d1\u7248\u6307\u6807\u6240\u5728\u7684\u5e94\u7528\uff0c2.0\u9700\u5207\u7248\u6307\u6807\u6240\u5728\u7684\u5e94\u7528\u3002\n3.\u8fdb\u5165\u7cfb\u7edf\u7684\u53d1\u7248\u6216\u5207\u7248\u64cd\u4f5c\u754c\u9762\uff0c\u6267\u884c\u64cd\u4f5c\u3002\n4.\u5907\u4efd\u6570\u636e\u540e\u53d1\u7248\u6216\u5207\u7248\uff0c\u5b8c\u6210\u540e\u68c0\u67e5\u7cfb\u7edf\u662f\u5426\u6b63\u5e38\uff0c\u5426\u5219\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return Output.finish((String)"success", (Object)false).keep("logCheckDtos", logCheckDtos).keep("mix_standard_synonyms_before_filter", context.getOrDefault((Object)"mix_standard_synonyms_before_filter", new ArrayList())).keep("mix_standard_synonyms_after_filter", context.getOrDefault((Object)"mix_standard_synonyms_after_filter", new ArrayList())).keep("reply", (Object)"message.scrumbi.no.metric.error");
        }
        Map<String, List<JSONObject>> groupedMetrics = allMetric.stream().collect(Collectors.groupingBy(metric -> metric.getString("applicationCode")));
        ArrayList gptParam = new ArrayList();
        ArrayList apps = new ArrayList();
        groupedMetrics.entrySet().forEach(g -> {
            ArrayList metricNames = new ArrayList();
            List value = (List)g.getValue();
            value.forEach(v -> metricNames.add(v.getString("metricName")));
            gptParam.add(metricNames);
            apps.add((String)g.getKey());
        });
        LogCheckDto logCheckDto = new LogCheckDto();
        logCheckDto.buildParams("SearchMetricTargetMixExecutor", LogUtils.WARING, input.toJSONString(), "\u672a\u5339\u914d\u5230\u76f8\u5173\u6307\u6807\uff0c\u63a5\u4e0b\u6765\u5c06\u4f7f\u7528LLM\u515c\u5e95\u68c0\u7d22\u6307\u6807\uff0c\u53ef\u80fd\u539f\u56e0\u662f\u672a\u914d\u7f6e\u6307\u6807\u6216\u672a\u914d\u7f6e\u6307\u6807\u540c\u4e49\u8bcd", "1.\u6253\u5f00\u6307\u6807\u548c\u540c\u4e49\u8bcd\u7684\u914d\u7f6e\u9875\u9762\u3002\n2.\u786e\u8ba4\u6240\u95ee\u6307\u6807\u662f\u5426\u5df2\u914d\u7f6e\uff0c\u6307\u6807\u4fe1\u606f\u662f\u5426\u5b8c\u6574\u3002\n3.\u68c0\u67e5\u6307\u6807\u7684\u540c\u4e49\u8bcd\u662f\u5426\u5df2\u8bbe\u7f6e\uff0c\u786e\u4fdd\u5176\u51c6\u786e\u6027\u3002\n4.\u4fdd\u5b58\u5e76\u91cd\u65b0\u53d1\u7248\u64cd\u4f5c\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
        logCheckDtos.add(logCheckDto);
        context.put("all_metric_list", groupedMetrics);
        return Output.through((String)MetricSearchResultEnum.NO_METRIC.getKey(), (Object)MetricSearchResultEnum.NO_METRIC.getValue()).keep("no_metric_gpt_param", (Object)this.buildMetricParams(groupedMetrics)).keep("no_metric_apps", apps).keep("logCheckDtos", logCheckDtos).keep("mix_standard_synonyms_before_filter", context.getOrDefault((Object)"mix_standard_synonyms_before_filter", new ArrayList())).keep("mix_standard_synonyms_after_filter", context.getOrDefault((Object)"mix_standard_synonyms_after_filter", new ArrayList()));
    }

    private String queryTargetIdBySceneCode(JSONObject context, String sceneCode) {
        try {
            JSONObject params = new JSONObject();
            List applicationCodes = (List)context.getObject("applicationCodes", List.class);
            params.put("sceneCode", (Object)sceneCode);
            params.put("version", (Object)context.getString("version"));
            params.put("applicationCodes", (Object)applicationCodes);
            List scenes = Optional.ofNullable(Retrieve.SCENE.retrieve(params)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)scenes)) {
                return ((JSONObject)scenes.get(0)).getString("targetId");
            }
            log.info("\u6839\u636e\u573a\u666f\u7f16\u7801\u83b7\u53d6schemas\u4e3a\u7a7a");
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u573a\u666f\u7f16\u7801\u83b7\u53d6schemas\u5931\u8d25:{} ", (Throwable)e);
        }
        return null;
    }

    public String buildMetricParams(Map<String, List<JSONObject>> groupedMetrics) {
        StringBuilder result = new StringBuilder();
        int count = 1;
        for (Map.Entry<String, List<JSONObject>> entry : groupedMetrics.entrySet()) {
            String appName = "\u5e94\u7528" + count;
            List<JSONObject> metrics = entry.getValue();
            String s = this.appendMetricNames(appName, metrics);
            result.append(s);
            ++count;
        }
        return result.toString();
    }

    private String appendMetricNames(String appName, List<JSONObject> metrics) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            result.append(appName).append(":\n");
        }
        for (JSONObject metric : metrics) {
            String metricName = metric.getString("metricName");
            String description = metric.getString("description");
            result.append("  - ").append(metricName);
            if (StringUtils.isNotEmpty((CharSequence)description) && !"null".equals(description)) {
                result.append(": ").append(description);
            }
            result.append("\n");
        }
        result.append("\n");
        return result.toString();
    }

    private List<JSONObject> queryApplicationName(JSONObject context, List<String> keysList) {
        ArrayList<JSONObject> multiAppInfos = new ArrayList<JSONObject>();
        String userToken = ((Question)context.getObject("question", Question.class)).getToken();
        KnowledgemapsService knowledgemapsService = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
        try {
            List applicationNames = knowledgemapsService.queryApplicationName(userToken, keysList);
            if (CollectionUtils.isNotEmpty((Collection)applicationNames)) {
                JSONObject application = new JSONObject();
                for (JSONObject jsonObject : applicationNames) {
                    application.put(jsonObject.getString("code"), (Object)jsonObject.getString("name"));
                }
                for (String appCode : keysList) {
                    String applicationName = application.getString(appCode);
                    if (!StringUtils.isNotBlank((CharSequence)applicationName)) continue;
                    JSONObject metricsAppInfo = new JSONObject();
                    metricsAppInfo.put("applicationCode", (Object)appCode);
                    metricsAppInfo.put("applicationName", (Object)applicationName);
                    multiAppInfos.add(metricsAppInfo);
                }
            }
        }
        catch (Exception e) {
            log.error("queryApplicationName error", (Throwable)e);
        }
        return multiAppInfos;
    }

    private List<JSONObject> getTargetsAccurateStandardWords(JSONObject context, JSONObject cnAndTw, String originFinallyQuestion) {
        String simplified_use_question = cnAndTw.getString("zh_CN");
        String traditional_use_question = cnAndTw.getString("zh_TW");
        List questionSearchedTargets = new ArrayList();
        ArrayList<JSONObject> accurateStandardWords = new ArrayList<JSONObject>();
        context.put("simplified_use_question", (Object)simplified_use_question);
        context.put("traditional_use_question", (Object)traditional_use_question);
        context.put("orginal_question", (Object)originFinallyQuestion);
        try {
            questionSearchedTargets = Optional.ofNullable(Retrieve.TARGET.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        }
        catch (Exception e) {
            log.error("SearchMetricTargetMixExecutor query target ES fail", (Throwable)e);
            List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
            LogCheckDto logCheckDto = new LogCheckDto();
            JSONObject input = new JSONObject();
            input.put("simplified_use_question", (Object)simplified_use_question);
            input.put("traditional_use_question", (Object)traditional_use_question);
            input.put("orginal_question", (Object)originFinallyQuestion);
            logCheckDto.buildParams("SearchMetricTargetMixExecutor", "P.SCRUMBI.502.0204", input.toJSONString(), "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
            context.put("logCheckDtos", logCheckDtos);
        }
        log.info("targetsSearchedKey:{}", questionSearchedTargets);
        if (CollectionUtils.isNotEmpty(questionSearchedTargets)) {
            questionSearchedTargets.forEach(t -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("applicationCodes", Arrays.asList(t.getString("applicationCode")));
                jsonObject.put("version", (Object)t.getString("version"));
                jsonObject.put("standard_name", (Object)t.getString("datasourceName"));
                jsonObject.put("match_words", Arrays.asList(t.getString("datasourceName")));
                jsonObject.put("entity_type", (Object)"target");
                jsonObject.put("dataSources", (Object)"target");
                accurateStandardWords.add(jsonObject);
            });
        }
        log.info("accurateStandardWords:{}", accurateStandardWords);
        List standardSynonymsWords = SearchMetricTargetMixExecutor.getStandardSynonymsWords((JSONObject)context, (String)"target");
        if (CollectionUtils.isNotEmpty((Collection)standardSynonymsWords)) {
            accurateStandardWords.addAll(standardSynonymsWords);
        }
        return accurateStandardWords;
    }

    private List<JSONObject> getMetricsAccurateStandardWords(JSONObject context, JSONObject cnAndTw, String originFinallyQuestion) {
        List standardSynonymsWords;
        String simplified_use_question = cnAndTw.getString("zh_CN");
        String traditional_use_question = cnAndTw.getString("zh_TW");
        List questionSearchedMetrics = new ArrayList();
        ArrayList<JSONObject> accurateStandardWords = new ArrayList<JSONObject>();
        context.put("simplified_use_question", (Object)simplified_use_question);
        context.put("traditional_use_question", (Object)traditional_use_question);
        context.put("origin_finally_question", (Object)originFinallyQuestion);
        try {
            questionSearchedMetrics = Optional.ofNullable(Retrieve.METRIC.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        }
        catch (Exception e) {
            List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
            log.error("SearchMetricTargetMixExecutor query metric ES fail", (Throwable)e);
            LogCheckDto logCheckDto = new LogCheckDto();
            JSONObject input = new JSONObject();
            input.put("simplified_use_question", (Object)simplified_use_question);
            input.put("traditional_use_question", (Object)traditional_use_question);
            input.put("origin_finally_question", (Object)originFinallyQuestion);
            logCheckDto.buildParams("SearchMetricTargetMixExecutor", "P.SCRUMBI.502.0204", input.toJSONString(), "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
            context.put("logCheckDtos", logCheckDtos);
        }
        log.info("metricsSearchedKey:{}", questionSearchedMetrics);
        if (CollectionUtils.isNotEmpty(questionSearchedMetrics)) {
            questionSearchedMetrics.forEach(t -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("applicationCodes", Arrays.asList(t.getString("applicationCode")));
                jsonObject.put("version", (Object)t.getString("version"));
                jsonObject.put("standard_name", (Object)t.getString("metricName"));
                jsonObject.put("match_words", Arrays.asList(t.getString("metricName")));
                jsonObject.put("entity_type", (Object)"metric");
                jsonObject.put("dataSources", (Object)"metric");
                accurateStandardWords.add(jsonObject);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(standardSynonymsWords = SearchMetricTargetMixExecutor.getStandardSynonymsWords((JSONObject)context, (String)"metric")))) {
            accurateStandardWords.addAll(standardSynonymsWords);
        }
        return accurateStandardWords;
    }

    private List<JSONObject> getMixAccurateStandardWords(JSONObject context, JSONObject cnAndTw, String originFinallyQuestion) {
        List standardSynonymsWords;
        String simplified_use_question = cnAndTw.getString("zh_CN");
        String traditional_use_question = cnAndTw.getString("zh_TW");
        List questionSearchedMetrics = new ArrayList();
        ArrayList<JSONObject> accurateStandardWords = new ArrayList<JSONObject>();
        context.put("simplified_use_question", (Object)simplified_use_question);
        context.put("traditional_use_question", (Object)traditional_use_question);
        context.put("origin_finally_question", (Object)originFinallyQuestion);
        try {
            questionSearchedMetrics = Optional.ofNullable(Retrieve.METRIC.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        }
        catch (Exception e) {
            List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
            log.error("SearchMetricTargetMixExecutor query metric ES fail", (Throwable)e);
            LogCheckDto logCheckDto = new LogCheckDto();
            JSONObject input = new JSONObject();
            input.put("simplified_use_question", (Object)simplified_use_question);
            input.put("traditional_use_question", (Object)traditional_use_question);
            input.put("origin_finally_question", (Object)originFinallyQuestion);
            logCheckDto.buildParams("SearchMetricTargetMixExecutor", "P.SCRUMBI.502.0204", input.toJSONString(), "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
            context.put("logCheckDtos", logCheckDtos);
        }
        log.info("metricsSearchedKey:{}", questionSearchedMetrics);
        if (CollectionUtils.isNotEmpty(questionSearchedMetrics)) {
            questionSearchedMetrics.forEach(t -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("applicationCodes", Arrays.asList(t.getString("applicationCode")));
                jsonObject.put("version", (Object)t.getString("version"));
                jsonObject.put("standard_name", (Object)t.getString("metricName"));
                jsonObject.put("match_words", Arrays.asList(t.getString("metricName")));
                jsonObject.put("entity_type", (Object)"metric");
                jsonObject.put("dataSources", (Object)"metric");
                accurateStandardWords.add(jsonObject);
            });
        }
        List questionSearchedTargets = new ArrayList();
        context.put("orginal_question", (Object)originFinallyQuestion);
        try {
            questionSearchedTargets = Optional.ofNullable(Retrieve.TARGET.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        }
        catch (Exception e) {
            log.error("SearchMetricTargetMixExecutor query target ES fail", (Throwable)e);
            List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
            LogCheckDto logCheckDto = new LogCheckDto();
            JSONObject input = new JSONObject();
            input.put("simplified_use_question", (Object)simplified_use_question);
            input.put("traditional_use_question", (Object)traditional_use_question);
            input.put("orginal_question", (Object)originFinallyQuestion);
            logCheckDto.buildParams("SearchMetricTargetMixExecutor", "P.SCRUMBI.502.0204", input.toJSONString(), "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
            context.put("logCheckDtos", logCheckDtos);
        }
        log.info("targetsSearchedKey:{}", questionSearchedTargets);
        if (CollectionUtils.isNotEmpty(questionSearchedTargets)) {
            questionSearchedTargets.forEach(t -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("applicationCodes", Arrays.asList(t.getString("applicationCode")));
                jsonObject.put("version", (Object)t.getString("version"));
                jsonObject.put("standard_name", (Object)t.getString("datasourceName"));
                jsonObject.put("match_words", Arrays.asList(t.getString("datasourceName")));
                jsonObject.put("entity_type", (Object)"target");
                jsonObject.put("dataSources", (Object)"target");
                accurateStandardWords.add(jsonObject);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(standardSynonymsWords = SearchMetricTargetMixExecutor.getStandardSynonymsWords((JSONObject)context, (String)"mixMetricTarget")))) {
            accurateStandardWords.addAll(standardSynonymsWords);
        }
        return accurateStandardWords;
    }

    public static List<JSONObject> getStandardSynonymsWords(JSONObject context, String type) {
        ArrayList<JSONObject> accurateStandardWords = new ArrayList<JSONObject>();
        List standardSynonymsWords = (List)context.getObject("standardSynonymsWords", List.class);
        if (CollectionUtils.isNotEmpty((Collection)standardSynonymsWords)) {
            for (JSONObject standardSynonymsWord : standardSynonymsWords) {
                JSONObject jsonObject = new JSONObject();
                if (StringUtils.isEmpty((CharSequence)standardSynonymsWord.getString("tenant_id"))) {
                    jsonObject.put("applicationCodes", Arrays.asList(standardSynonymsWord.getString("assistant_id")));
                } else {
                    jsonObject.put("applicationCodes", context.get((Object)"applicationCodes"));
                }
                jsonObject.put("version", (Object)context.getString("version"));
                jsonObject.put("entity_type", (Object)type);
                jsonObject.put("dataSources", (Object)"synonyms");
                jsonObject.put("standard_name", (Object)standardSynonymsWord.getString("standard_name"));
                jsonObject.put("match_words", standardSynonymsWord.get((Object)"match_words"));
                accurateStandardWords.add(jsonObject);
            }
        }
        return accurateStandardWords;
    }

    private JSONObject translateMetric(String key) {
        TranslateService bean = (TranslateService)SpringContextUtil.getBean(TranslateService.class);
        JSONObject cnAndTw = bean.cnAndTw(key);
        return cnAndTw;
    }

    private String specialStrategy(JSONObject context) {
        Question question = (Question)context.getObject("question", Question.class);
        String debugMode = question.getDebugMode();
        String sceneCode = question.getSceneCode();
        String targetId = question.getTargetId();
        List metricIds = question.getMetricIdList();
        if (StringUtils.isNotEmpty((CharSequence)debugMode) && (debugMode.equals(DebugMode.PARAM.getCode()) || debugMode.equals(DebugMode.PR_PARAM.getCode()) || debugMode.equals(DebugMode.DEBUG.getCode()) || debugMode.equals(DebugMode.TEST.getCode())) || StringUtils.isNotEmpty((CharSequence)sceneCode) || StringUtils.isNotEmpty((CharSequence)targetId) || "dataflow".equals(question.getMethod())) {
            return "dataflow";
        }
        if (CollectionUtils.isNotEmpty((Collection)metricIds) || StringUtils.isNotEmpty((CharSequence)debugMode) && debugMode.equals(DebugMode.DEBUG_METRIC.getCode()) || "metric".equals(question.getMethod())) {
            return "metric";
        }
        return null;
    }

    private Map<List<Integer>, List<JSONObject>> synonymsGroupByPosition(List<JSONObject> jsonObjects) {
        HashMap<List<Integer>, List<JSONObject>> groupedMap = new HashMap<List<Integer>, List<JSONObject>>();
        try {
            for (JSONObject jsonObject : jsonObjects) {
                JSONArray positionArray = jsonObject.getJSONArray("position");
                ArrayList<Integer> position = new ArrayList<Integer>();
                for (int i = 0; i < positionArray.size(); ++i) {
                    position.add(positionArray.getIntValue(i));
                }
                groupedMap.computeIfAbsent(position, k -> new ArrayList()).add(jsonObject);
            }
        }
        catch (Exception e) {
            log.error("groupByPosition error", (Throwable)e);
        }
        return groupedMap;
    }
}

