/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.AppSystemEnum;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchSentenceSourceExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchSentenceSourceExecutor.class);

    public boolean onCondition(JSONObject context) {
        return AppSystemEnum.METRIC.getValue().equals(context.getString("appSystem"));
    }

    public Output doProcess(JSONObject context) {
        String locale = ((Question)context.getObject("question", Question.class)).getLocale();
        ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
        String version = context.getString("version");
        List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        JSONObject input = new JSONObject();
        input.put("locale", (Object)locale);
        input.put("applicationCodes", applicationCodes);
        input.put("version", (Object)version);
        List collect = null;
        try {
            collect = ((Stream)Optional.ofNullable(Retrieve.TARGET_SEN.retrieveSentenceByApplicationCodes(applicationCodes, version, new String[]{"datasourceId", "intentions"})).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source"))).orElse(null)).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("SearchSentenceSourceExecutor query ES fail", (Throwable)e);
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchSentenceSource", "P.SCRUMBI.502.0204", input.toJSONString(), "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
            logCheckDtos.add(logCheckDto);
            return Output.through((String)"logCheckDtos", logCheckDtos);
        }
        Map<Object, Object> simpleString2ListMap = new HashMap();
        if (CollectionUtils.isNotEmpty(collect)) {
            for (JSONObject jSONObject : collect) {
                ArrayList intentions;
                List list = intentions = CollectionUtils.isEmpty((Collection)((Collection)simpleString2ListMap.get(jSONObject.getString("datasourceId")))) ? new ArrayList() : (List)simpleString2ListMap.get(jSONObject.getString("datasourceId"));
                if (!Objects.isNull(jSONObject.get((Object)"intentions"))) {
                    intentions.addAll((List)jSONObject.get((Object)"intentions"));
                }
                simpleString2ListMap.put(jSONObject.getString("datasourceId"), intentions);
            }
        }
        for (Map.Entry entry : simpleString2ListMap.entrySet()) {
            String key = (String)entry.getKey();
            List value = (ArrayList)entry.getValue();
            if ((value = new ArrayList(new HashSet(value))).size() > 9) {
                value = value.subList(0, 9);
            }
            simpleString2ListMap.put(key, value);
        }
        simpleString2ListMap = simpleString2ListMap.entrySet().stream().collect(Collectors.toMap(item -> (String)item.getKey(), item -> ((List)Optional.ofNullable((List)item.getValue()).orElse(null)).stream().map(str -> ZhConverterUtil.toSimple((String)str)).collect(Collectors.toList()), (v1, v2) -> v1));
        Map<String, List> traditionString2ListMap = simpleString2ListMap.entrySet().stream().collect(Collectors.toMap(item -> (String)item.getKey(), item -> ((List)Optional.ofNullable((List)item.getValue()).orElse(null)).stream().map(str -> ZhConverterUtil.toTraditional((String)str)).collect(Collectors.toList()), (v1, v2) -> v1));
        LogCheckDto logCheckDto = new LogCheckDto();
        JSONObject result = new JSONObject();
        result.put("locale_sentences_datasourceIds", simpleString2ListMap.keySet());
        logCheckDto.buildParams("SearchSentenceSource", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
        logCheckDtos.add(logCheckDto);
        return Output.through((String)"locale_sentences", "zh_CN".equals(locale) ? simpleString2ListMap : traditionString2ListMap).keep("logCheckDtos", logCheckDtos);
    }
}

