/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.SearchStandardWords4MetricExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.SearchStandardWords4MetricRollBackExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.StandardWordsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchStandardWords4MetricExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchStandardWords4MetricExecutor.class);
    public static final String FILTER_APPEND_EX = "%s\u662f%s";
    public static final String FILTER_APPEND_EX_SPECIAL = "\u300c%s\u300d\u662f%s";

    public Output doProcess(JSONObject context) {
        Environment environment = (Environment)SpringContextUtil.getBean(Environment.class);
        boolean synonymOldSwitch = (Boolean)environment.getProperty("synonym.old.switch", Boolean.class);
        log.info("\u540c\u4e49\u8bcd\u662f\u5426\u8d70\u8001es\u5f00\u5173:{}", (Object)synonymOldSwitch);
        if (!Objects.isNull(synonymOldSwitch) && synonymOldSwitch) {
            SearchStandardWords4MetricRollBackExecutor searchStandardWords4MetricRollBackExecutor = (SearchStandardWords4MetricRollBackExecutor)SpringContextUtil.getBean(SearchStandardWords4MetricRollBackExecutor.class);
            return searchStandardWords4MetricRollBackExecutor.doProcess(context);
        }
        List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        JSONObject input = new JSONObject();
        input.put("tenantId", (Object)context.getString("tenantId"));
        input.put("applicationCodes", (Object)context.getJSONArray("applicationCodes"));
        input.put("version", (Object)context.getString("version"));
        Output output = Output.through();
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        StandardWordsService standardWordsService = (StandardWordsService)SpringContextUtil.getBean(StandardWordsService.class);
        JSONArray matchWResult = null;
        JSONArray appMatchWResult = null;
        try {
            matchWResult = standardWordsService.synonymSearch4Tenant(question, context.getString("tenantId"));
            log.info("matchWResult:{}", (Object)matchWResult);
            appMatchWResult = standardWordsService.synonymSearch4App(question, context.getJSONArray("applicationCodes"), context.getString("version"));
            log.info("appMatchWResult:{}", (Object)appMatchWResult);
        }
        catch (Exception e) {
            LogCheckDto logCheckDto = new LogCheckDto();
            StringBuilder result = new StringBuilder();
            result.append("\u67e5\u8be2\u540c\u4e49\u8bcd\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:").append("\u3010").append(e.getMessage()).append("\u3011");
            logCheckDto.buildParams("SearchStandardWords4Metric", LogUtils.WARING, input.toJSONString(), result.toString(), "1\u5206\u949f\u91cd\u8bd5\u65e0\u679c\u540e\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
            logCheckDtos.add(logCheckDto);
            return output.keep("logCheckDtos", logCheckDtos);
        }
        if (this.volidateKey(matchWResult, appMatchWResult)) {
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("SearchStandardWords4Metric", LogUtils.WARING, input.toJSONString(), "\u6839\u636e\u95ee\u53e5\u672a\u67e5\u8be2\u5230\u4efb\u4f55\u540c\u4e49\u8bcd\uff0c\u53ef\u80fd\u56e0\u4e3a\u591a\u8bed\u8a00\u3001\u9519\u522b\u5b57\u6216\u6ca1\u6709\u53d1\u7248\u5bfc\u81f4\u5df2\u914d\u7f6e\u7684\u540c\u4e49\u8bcd\u6ca1\u6709\u751f\u6548", "1.\u6253\u5f00\u540c\u4e49\u8bcd\u914d\u7f6e\u754c\u9762\uff0c\u67e5\u627e\u76f8\u5173\u540c\u4e49\u8bcd\u3002\n2.\u68c0\u67e5\u540c\u4e49\u8bcd\u7684\u914d\u7f6e\u662f\u5426\u5b8c\u6574\u3001\u51c6\u786e\u3002\n3.\u82e5\u65e0\u8bef\uff0c\u6267\u884c\u53d1\u7248\u64cd\u4f5c\u5e76\u786e\u8ba4\u53d1\u7248\u5b8c\u6210\u3002\n4.\u53d1\u7248\u540e\u6d4b\u8bd5\uff0c\u82e5\u6709\u95ee\u9898\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return output.keep("logCheckDtos", logCheckDtos);
        }
        JSONArray allMatchResult = this.getAllMatchResult(matchWResult, appMatchWResult);
        allMatchResult.stream().map(JSONObject.class::cast).collect(Collectors.groupingBy(hit -> WordType.of((String)hit.getOrDefault((Object)"entity_type", (Object)"entity").toString()))).entrySet().stream().map(entry -> {
            List matchWords;
            List tenantAndAppStandardWords = (List)entry.getValue();
            List tenantStandardWords = tenantAndAppStandardWords.stream().filter(word -> StringUtils.isNotEmpty((CharSequence)word.getString("tenant_id"))).collect(Collectors.toList());
            List appStandardWords = tenantAndAppStandardWords.stream().filter(word -> StringUtils.isNotEmpty((CharSequence)word.getString("assistant_id"))).collect(Collectors.toList());
            List<Object> appStandardWordsAfterFiltering = new ArrayList();
            ArrayList allTenantMatchWords = new ArrayList();
            if (CollectionUtils.isNotEmpty(tenantStandardWords)) {
                for (JSONObject tenantStandardWord : tenantStandardWords) {
                    matchWords = (List)tenantStandardWord.getOrDefault((Object)"highlight_words", new ArrayList());
                    allTenantMatchWords.addAll(matchWords);
                }
            }
            if (CollectionUtils.isNotEmpty(appStandardWords) && CollectionUtils.isNotEmpty(allTenantMatchWords)) {
                for (JSONObject appStandardWord : appStandardWords) {
                    List matchestWords;
                    matchWords = (List)appStandardWord.getOrDefault((Object)"match_words", new ArrayList());
                    if (!CollectionUtils.isNotEmpty((Collection)matchWords) || !CollectionUtils.isNotEmpty(matchestWords = matchWords.stream().filter(lw -> !allTenantMatchWords.contains(lw)).collect(Collectors.toList()))) continue;
                    appStandardWord.put("match_words", matchWords.stream().filter(lw -> !allTenantMatchWords.contains(lw)).collect(Collectors.toList()));
                    appStandardWordsAfterFiltering.add(appStandardWord);
                }
            } else if (CollectionUtils.isNotEmpty(appStandardWords) && CollectionUtils.isEmpty(tenantStandardWords)) {
                appStandardWordsAfterFiltering = appStandardWords;
            }
            ArrayList<Object> mergeStandardWords = new ArrayList<Object>();
            if (CollectionUtils.isNotEmpty(tenantStandardWords)) {
                mergeStandardWords.addAll(tenantStandardWords);
            }
            if (CollectionUtils.isNotEmpty(appStandardWordsAfterFiltering)) {
                mergeStandardWords.addAll(appStandardWordsAfterFiltering);
            }
            return ((WordType)entry.getKey()).pickKeepData(question, mergeStandardWords, context);
        }).forEach(arg_0 -> ((Output)output).keep(arg_0));
        LogCheckDto logCheckDto = new LogCheckDto();
        Object result = context.getOrDefault((Object)"standardSynonymsWords", new Object());
        logCheckDto.buildParams("SearchStandardWords4Metric", LogUtils.SUCCESS, input.toJSONString(), JSONObject.toJSONString((Object)result), "");
        logCheckDtos.add(logCheckDto);
        return output.keep("logCheckDto", (Object)logCheckDto);
    }

    public static List<String> findLongestWords(List<String> words) {
        if (words == null || words.isEmpty()) {
            return new ArrayList<String>();
        }
        int maxLength = words.stream().mapToInt(String::length).max().orElse(0);
        return words.stream().filter(word -> word.length() == maxLength).collect(Collectors.toList());
    }

    private JSONArray getAllMatchResult(JSONArray matchWResult, JSONArray appMatchWResult) {
        JSONArray allMatchWResult = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)matchWResult)) {
            allMatchWResult.addAll((Collection)matchWResult);
        }
        if (CollectionUtils.isNotEmpty((Collection)appMatchWResult)) {
            allMatchWResult.addAll((Collection)appMatchWResult);
        }
        return allMatchWResult;
    }

    private boolean volidateKey(JSONArray matchWResult, JSONArray appMatchWResult) {
        return CollectionUtils.isEmpty((Collection)matchWResult) && CollectionUtils.isEmpty((Collection)appMatchWResult);
    }
}

