/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.enums.DebugMode;
import com.digiwin.chatbi.common.enums.SpecialModeEnum;
import com.digiwin.chatbi.common.util.CommonUtil;
import com.digiwin.chatbi.common.util.DateTimeUtil;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.RegexUtil;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.config.LeadCorrectSentences;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.DataProcessAfterSearchExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.IamService;
import com.digiwin.chatbi.service.KnowledgemapsService;
import com.digiwin.chatbi.service.MessageUtils;
import com.digiwin.chatbi.service.TranslateService;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTargetsourceExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchTargetsourceExecutor.class);
    public static final String ANALYSIS_APPEND_EX = "%s=%s";
    public static final String SPLITE = "&&&&";

    public Output doProcess(JSONObject context) {
        Output output = Output.through();
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        String sceneCode = ((Question)context.getObject("question", Question.class)).getSceneCode();
        String debugMode = ((Question)context.getObject("question", Question.class)).getDebugMode();
        Boolean multiDialogue = ((Question)context.getObject("question", Question.class)).isMultiDialogue();
        String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
        JSONObject input = new JSONObject();
        input.put("applicationCodes", Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class));
        input.put("version", (Object)context.getString("version"));
        input.put("question", (Object)question);
        input.put("debugMode", (Object)debugMode);
        input.put("sceneCode", (Object)sceneCode);
        input.put("multiDialogue", (Object)multiDialogue);
        List targets = this.matchestTargetsSearch(context);
        List allSchemas = Optional.ofNullable(Retrieve.DICTIONARY.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
        if (CollectionUtils.isEmpty((Collection)targets)) {
            JSONObject jsonObject;
            context.remove((Object)"not_query_all");
            List allTargets = Optional.ofNullable(Retrieve.TARGET.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
            LogCheckDto logCheckDto = new LogCheckDto();
            Map targetsAndSynonyms = (Map)context.getOrDefault((Object)"targetsAndSynonyms", new HashMap());
            String targetsSynonyms = null;
            if (!targetsAndSynonyms.isEmpty() && StringUtils.isNotBlank((CharSequence)context.getString("target_standard_name")) && (jsonObject = (JSONObject)targetsAndSynonyms.get(context.getString("target_standard_name"))) != null && StringUtils.isNotEmpty((CharSequence)jsonObject.getString("match_words"))) {
                List synonyms = (List)jsonObject.getObject("match_words", List.class);
                targetsSynonyms = String.join((CharSequence)",", synonyms);
            }
            logCheckDto.buildParams("SearchTargetsource", "U.SCRUMBI.901.0203", input.toJSONString(), "\u6839\u636e\u95ee\u53e5\u67e5\u4e0d\u5230\u4efb\u4f55\u7684\u5df2\u77e5\u76ee\u6807target\uff0c\u53ef\u80fd\u56e0\u4e3a\u6ca1\u6709\u914d\u7f6e\u76ee\u6807\uff0c\u6216\u7531\u4e8e\u591a\u8bed\u8a00\u3001\u9519\u522b\u5b57\u6216\u6ca1\u6709\u53d1\u7248\u5bfc\u81f4\u5df2\u914d\u7f6e\u7684\u76ee\u6807\u6ca1\u6709\u751f\u6548".replace("target", StringUtils.isBlank(targetsSynonyms) ? "" : "\u3010" + targetsSynonyms + "\u3011"), "1.\u627e\u5230\u573a\u666f\u914d\u7f6e\u9875\u9762\uff0c\u67e5\u627e\u95ee\u53e5\u4e2d\u7684\u76ee\u6807\u662f\u5426\u5df2\u914d\u7f6e\u3002\n2.\u82e5\u672a\u914d\u7f6e\uff0c\u6dfb\u52a0\u76ee\u6807\u53ca\u5176\u76f8\u5173\u6307\u6807\u4fe1\u606f\u3002\n3.\u7ef4\u62a4\u6216\u6dfb\u52a0\u76ee\u6807\u7684\u540c\u4e49\u8bcd\u3002\n4.\u8fdb\u884c\u53d1\u7248\u5207\u7248\u64cd\u4f5c\uff0c\u82e5\u95ee\u9898\u6301\u7eed\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            if (Objects.isNull(multiDialogue) || !multiDialogue.booleanValue()) {
                return Output.finish((String)"sentences", (Object)LeadCorrectSentences.achieveRandomSens((Map)((Map)context.get((Object)"locale_sentences")))).keep("reply", (Object)"message.scrumbi.no.target.alike").keep("target_size", (Object)0).keep("logCheckDtos", logCheckDtos);
            }
            HashMap targetMap = new HashMap();
            allTargets.forEach(t -> targetMap.put(t.getString("datasourceId"), t.getString("datasourceName")));
            List list = targetMap.entrySet().stream().map(e -> (String)e.getValue()).collect(Collectors.toList());
            String result = list.stream().map(s -> "- \"" + s + "\"").collect(Collectors.joining("\n"));
            return Output.through((String)"no_target", (Object)"Y").keep("target_size", (Object)0).keep("alike_target_size", (Object)1).keep("target_list", (Object)result).keep("targetMapDistinctById", targetMap).keep("allTarget", (Object)allTargets).keep("logProblemDescription", Constants.NO_TARGET_LOG_VALUE.get(0)).keep("logTimestamp", (Object)DateTimeUtil.format((Date)new Date())).keep("logErrorContent", Constants.NO_TARGET_LOG_VALUE.get(1)).keep("logTroubleGuide", Constants.NO_TARGET_LOG_VALUE.get(2)).keep("logKey", (Object)"\u95ee\u9898\u4f4d\u7f6e\uff1a\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6(SCRUMBI)\n\u95ee\u9898\u63cf\u8ff0\uff1a{logProblemDescription}\n\u53d1\u751f\u65f6\u95f4\uff1a{logTimestamp}\n\u9519\u8bef\u5185\u5bb9\uff1a{logErrorContent}\n\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a{logTroubleGuide}").keep("logCheckDtos", logCheckDtos);
        }
        if (1 == targets.size()) {
            JSONObject existing2 = (JSONObject)targets.get(0);
            List existSchemasVolidate = allSchemas.stream().filter(a -> existing2.getString("applicationCode").equals(a.getString("applicationCode")) && existing2.getString("version").equals(a.getString("version"))).map(a -> a.getString("name")).collect(Collectors.toList());
            JSONArray jsonArray = CollectionUtils.isEmpty((Collection)existing2.getJSONArray("schemas")) ? new JSONArray() : existing2.getJSONArray("schemas");
            jsonArray = JSONArray.parseArray((String)JSON.toJSONString(jsonArray.stream().filter(j -> existSchemasVolidate.contains(((JSONObject)j).getString("name"))).collect(Collectors.toList())));
            existing2.put("schemas", jsonArray.stream().distinct().collect(Collectors.toList()));
            targets.clear();
            targets.add(existing2);
        } else {
            targets = targets.stream().collect(Collectors.collectingAndThen(Collectors.toMap(jsonObj -> jsonObj.getString("datasourceId"), jsonObj -> jsonObj, (existing, replacement) -> {
                List existSchemasVolidate = allSchemas.stream().filter(a -> existing.getString("applicationCode").equals(a.getString("applicationCode")) && existing.getString("version").equals(a.getString("version"))).map(a -> a.getString("name")).collect(Collectors.toList());
                JSONArray jsonArray = CollectionUtils.isEmpty((Collection)existing.getJSONArray("schemas")) ? new JSONArray() : existing.getJSONArray("schemas");
                jsonArray = JSONArray.parseArray((String)JSON.toJSONString(jsonArray.stream().filter(j -> existSchemasVolidate.contains(((JSONObject)j).getString("name")) || "1".equals(((JSONObject)j).getString("ifChecked"))).collect(Collectors.toList())));
                if (CollectionUtils.isNotEmpty((Collection)replacement.getJSONArray("schemas"))) {
                    List replacementSchemasVolidate = allSchemas.stream().filter(a -> replacement.getString("applicationCode").equals(a.getString("applicationCode")) && replacement.getString("version").equals(a.getString("version"))).map(a -> a.getString("name")).collect(Collectors.toList());
                    jsonArray.addAll((Collection)JSONArray.parseArray((String)JSON.toJSONString(replacement.getJSONArray("schemas").stream().filter(j -> replacementSchemasVolidate.contains(((JSONObject)j).getString("name")) || "1".equals(((JSONObject)j).getString("ifChecked"))).collect(Collectors.toList()))));
                }
                jsonArray.forEach(j -> ((JSONObject)j).put("ifChecked", (Object)"1"));
                existing.put("schemas", jsonArray.stream().distinct().collect(Collectors.toList()));
                return existing;
            }), map -> new ArrayList(new HashSet(map.values()))));
        }
        HashSet appedAnalysisWords = new HashSet();
        if (targets.size() > 1) {
            if (Objects.isNull(multiDialogue) || !multiDialogue.booleanValue()) {
                JSONObject jsonObject = (JSONObject)targets.get(0);
                targets.clear();
                targets.add(jsonObject);
            } else {
                HashMap result = new HashMap();
                targets.stream().map(t -> t.getString("datasourceId")).forEach(id -> result.put(id, (List)((Map)context.get((Object)"locale_sentences")).get(id)));
                context.put("special_mode", (Object)SpecialModeEnum.MORE_TARGET.getValue());
                ArrayList list = new ArrayList();
                String locale = ((Question)context.getObject("question", Question.class)).getLocale();
                targets.forEach(t -> {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("targetId", (Object)t.getString("datasourceId"));
                    jsonObject.put("targetName", (Object)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)t.getString("datasourceName")) : ZhConverterUtil.toSimple((String)t.getString("datasourceName"))));
                    list.add(jsonObject);
                });
                context.put("more_target", list);
                MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
                String param = StringUtil.formatListToBrackets(new ArrayList(new HashSet(targets.stream().map(t -> t.getString("datasourceName")).collect(Collectors.toList()))), (String)locale);
                String reply = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.one.more.target", locale, new Object[]{param});
                return Output.finish((String)"sentences", (Object)LeadCorrectSentences.achieveRandomSens(result)).keep("target_size", (Object)targets.size()).keep("reply", (Object)reply);
            }
        }
        JSONObject sceneBySceneCode = null;
        if (StringUtils.isNotEmpty((CharSequence)sceneCode)) {
            KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
            JSONObject params = new JSONObject();
            params.put("sceneCode", (Object)sceneCode);
            String token = ((Question)context.getObject("question", Question.class)).getToken();
            try {
                ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
                params.put("applicationCodes", applicationCodes);
                params.put("version", (Object)context.getString("version"));
                sceneBySceneCode = bean.querySceneMaps(params, context);
            }
            catch (Exception e2) {
                log.info("\u68c0\u67e5\u5230\u5165\u53c2\u7684\u573a\u666f\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u67e5\u8be2km\u5f02\u5e38");
            }
            if (Objects.isNull(sceneBySceneCode)) {
                return Output.finish((String)"sceneNotExist", (Object)"1").keep("reply", (Object)"message.scrumbi.check.scenes").keep("target_size", (Object)targets.size());
            }
        }
        JSONObject finalSceneBySceneCode = sceneBySceneCode;
        targets.stream().peek(datasource -> {
            List collect;
            datasource.remove((Object)"applicationCode");
            datasource.remove((Object)"version");
            JSONArray schemas = datasource.getJSONArray("schemas");
            if (StringUtils.isNotEmpty((CharSequence)sceneCode) && (DebugMode.DEBUG.getCode().equals(debugMode) || DebugMode.PR_PARAM.getCode().equals(debugMode))) {
                KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
                if (DebugMode.DEBUG.getCode().equals(debugMode)) {
                    datasource.put("datasourceId", (Object)finalSceneBySceneCode.getString("targetId"));
                    datasource.put("datasourceName", (Object)finalSceneBySceneCode.getString("targetName"));
                }
                try {
                    String token = ((Question)context.getObject("question", Question.class)).getToken();
                    JSONObject schemasBySceneCode = bean.getSchemasBySceneCode(sceneCode, context);
                    schemas = Objects.isNull(schemasBySceneCode) ? new JSONArray() : schemasBySceneCode.getJSONArray("schemas");
                    List schemasVolidate = allSchemas.stream().filter(a -> schemasBySceneCode.getString("applicationCode").equals(a.getString("applicationCode")) && schemasBySceneCode.getString("version").equals(a.getString("version"))).map(a -> a.getString("name")).collect(Collectors.toList());
                    log.info("\u67e5\u8be2\u5230\u7684schemasVolidate\uff1a{}", schemasVolidate);
                    List objects = schemas.stream().filter(s -> schemasVolidate.contains(((JSONObject)s).getString("name"))).collect(Collectors.toList());
                    schemas.clear();
                    for (Object object : objects) {
                        schemas.add(object);
                    }
                }
                catch (Exception e2) {
                    log.error("\u83b7\u53d6\u573a\u666f\u5931\u8d25", (Throwable)e2);
                }
            }
            if (CollectionUtils.isNotEmpty(collect = schemas.stream().map(schema -> (JSONObject)schema).peek(schema -> {
                schema.remove((Object)"hasDefault");
                schema.remove((Object)"required");
                schema.remove((Object)"ifChecked");
            }).collect(Collectors.toList()))) {
                collect.removeIf(schema -> "MONTH".equals(schema.getString("name")));
                boolean hasEocCompanyName = collect.stream().anyMatch(schema -> "eoc_company_name".equals(schema.getString("name")));
                if (this.checkCompanyIsExist(context) && !hasEocCompanyName) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("dataType", (Object)"string");
                    jsonObject.put("name", (Object)"eoc_company_name");
                    jsonObject.put("title", (Object)"\u516c\u53f8\u540d\u79f0");
                    collect.add(jsonObject);
                }
            }
            JSONObject schemaJsonObject = new JSONObject();
            schemaJsonObject.put("Schemas", collect);
            log.info("output end dict Schemas:{}", collect);
            datasource.put("schemas", (Object)schemaJsonObject);
            datasource.put("schemasNames", collect.stream().map(e -> e.getString("name")).collect(Collectors.toList()));
            List synonyms = (List)datasource.getObject("synonym", ArrayList.class);
            String datasourceName = datasource.getString("datasourceName");
            if (CollectionUtils.isNotEmpty((Collection)synonyms) && StringUtils.isNotBlank((CharSequence)datasourceName)) {
                synonyms.stream().forEach(sy -> {
                    if (question.contains((CharSequence)sy) && !datasourceName.equals(sy)) {
                        appedAnalysisWords.add(String.format(ANALYSIS_APPEND_EX, sy, datasourceName));
                    }
                });
            }
        }).forEach(arg_0 -> ((Output)output).keep(arg_0));
        List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        LogCheckDto logCheckDto = new LogCheckDto();
        JSONObject result = new JSONObject();
        result.put("targets", (Object)targets);
        logCheckDto.buildParams("SearchTargetsource", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
        logCheckDtos.add(logCheckDto);
        return output.keep("targets", (Object)targets).keep("appedAnalysisWords", appedAnalysisWords).keep("target_size", (Object)targets.size()).keep("logCheckDtos", logCheckDtos);
    }

    private boolean checkCompanyIsExist(JSONObject context) {
        List companyWords = (List)context.get((Object)"originalStandardWords");
        if (CollectionUtils.isNotEmpty((Collection)companyWords)) {
            for (JSONObject companyWord : companyWords) {
                if (!"\u516c\u53f8\u540d\u79f0".equals(companyWord.getString("entity_type"))) continue;
                return true;
            }
        }
        return false;
    }

    private List<JSONObject> matchestTargetsSearch(JSONObject context) {
        String simpleMessage;
        String question;
        String userToken = ((Question)context.getObject("question", Question.class)).getToken();
        String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
        String sessionId = ((Question)context.getObject("question", Question.class)).getSessionId();
        Boolean multiDialogue = ((Question)context.getObject("question", Question.class)).isMultiDialogue();
        String targetId = ((Question)context.getObject("question", Question.class)).getTargetId();
        String asaCode = ((Question)context.getObject("question", Question.class)).getAsaCode();
        List targets = null;
        if (StringUtils.isNotEmpty((CharSequence)targetId)) {
            context.put("targetId", (Object)targetId);
            try {
                targets = Optional.ofNullable(Retrieve.TARGET.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            }
            catch (Exception e) {
                List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
                log.error("SearchTargetsourceExecutor query ES fail", (Throwable)e);
                LogCheckDto logCheckDto = new LogCheckDto();
                JSONObject input = new JSONObject();
                input.put("targetId", (Object)targetId);
                logCheckDto.buildParams("SearchTargetsource", "P.SCRUMBI.502.0204", input.toJSONString(), "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
                logCheckDtos.add(logCheckDto);
                context.put("logCheckDtos", logCheckDtos);
            }
            return targets;
        }
        context.put("not_query_all", (Object)"1");
        String target_standard_name = context.getString("target_standard_name");
        Map targetsAndSynonyms = (Map)context.getOrDefault((Object)"targetsAndSynonyms", new HashMap());
        String queryQuestion = question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        String querySimpleQuestion = simpleMessage = ((Question)context.getObject("question", Question.class)).getSimpleMessage().replace("explain:", "");
        String matchVal = null;
        if (multiDialogue.booleanValue()) {
            String prompt;
            int lastQuestionIndex;
            List jsonObjects = null;
            try {
                IamService bean = (IamService)SpringContextUtil.getBean(IamService.class);
                jsonObjects = bean.getLastedUserHistoryMessage(userToken, routerKey, sessionId, asaCode);
            }
            catch (Exception e) {
                log.error("\u5386\u53f2\u6570\u636e\u67e5\u8be2\u5931\u8d25");
            }
            if (CollectionUtils.isNotEmpty(jsonObjects) && ((JSONObject)jsonObjects.get(lastQuestionIndex = jsonObjects.size() - 1)).getString("msgType").equals("CUSTOM") && StringUtils.isNotEmpty((CharSequence)(prompt = ((JSONObject)jsonObjects.get(lastQuestionIndex)).getJSONObject("msgBody").getString("prompt")))) {
                String originQuestion;
                List bracketValList;
                boolean moreTarget;
                log.info("last answer,{} \u548c targetId = {}", (Object)prompt, (Object)targetId);
                boolean bl = moreTarget = !(!RegexUtil.targetPromptMatch((String)prompt) && !RegexUtil.targetPromptMatchTW((String)prompt) || RegexUtil.templatePromptMatch((String)prompt) && RegexUtil.templatePromptMatchTW((String)prompt) || !StringUtils.isBlank((CharSequence)targetId));
                if ((prompt.startsWith("\u5f53\u524d\u4ec5\u652f\u6301\u5bf9\u4ee5\u4e0b\u51e0\u7c7b\u6570\u636e\u7684\u95ee\u7b54\uff0c\u8bf7\u95ee\u60a8\u662f\u60f3\u8981\u95ee\u54ea\u7c7b\uff1a") || prompt.startsWith("\u7576\u524d\u50c5\u652f\u6301\u5c0d\u4ee5\u4e0b\u5e7e\u985e\u6578\u64da\u7684\u554f\u7b54\uff0c\u8acb\u554f\u60a8\u662f\u60f3\u8981\u554f\u54ea\u985e\uff1a") || moreTarget) && CollectionUtils.isNotEmpty((Collection)(bracketValList = CommonUtil.getBracketValList((String)prompt))) && StringUtils.isNotBlank((CharSequence)(originQuestion = ((Question)context.getObject("question", Question.class)).getOriginMessage()))) {
                    matchVal = CommonUtil.LongestPrefixMatch((List)bracketValList, (String)originQuestion);
                    if (StringUtils.isNotBlank((CharSequence)matchVal)) {
                        target_standard_name = matchVal;
                        context.put("target_standard_name", (Object)matchVal);
                    } else {
                        queryQuestion = originQuestion;
                        querySimpleQuestion = ZhConverterUtil.toSimple((String)originQuestion);
                    }
                }
            }
        }
        StringBuilder key = new StringBuilder(queryQuestion);
        if (StringUtils.isNotEmpty((CharSequence)target_standard_name)) {
            key.append(SPLITE).append(target_standard_name);
        }
        if (!Objects.isNull(targetsAndSynonyms)) {
            targetsAndSynonyms.entrySet().forEach(t -> {
                JSONObject value = (JSONObject)t.getValue();
                JSONArray synonyms = CollectionUtils.isEmpty((Collection)value.getJSONArray("synonyms")) ? new JSONArray() : value.getJSONArray("synonyms");
                synonyms.forEach(s -> key.append(SPLITE).append(s));
            });
        }
        Map cnAndTwMap = this.translate(key.toString());
        if (StringUtils.isEmpty(matchVal)) {
            List targetsSearchedKey = null;
            ArrayList accurateStandardWords = new ArrayList();
            context.put("simplified_use_question", (Object)((JSONObject)cnAndTwMap.get(queryQuestion)).getString("cn"));
            context.put("traditional_use_question", (Object)((JSONObject)cnAndTwMap.get(queryQuestion)).getString("tw"));
            if (StringUtils.isNotEmpty((CharSequence)target_standard_name)) {
                context.put("simplified_target_standard_name", (Object)((JSONObject)cnAndTwMap.get(target_standard_name)).getString("cn"));
                context.put("traditional_target_standard_name", (Object)((JSONObject)cnAndTwMap.get(target_standard_name)).getString("tw"));
            }
            try {
                targetsSearchedKey = Optional.ofNullable(Retrieve.TARGET.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            }
            catch (Exception e) {
                List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
                log.error("SearchTargetsourceExecutor query ES fail", (Throwable)e);
                LogCheckDto logCheckDto = new LogCheckDto();
                JSONObject input = new JSONObject();
                input.put("simplified_use_question", (Object)((JSONObject)cnAndTwMap.get(queryQuestion)).getString("cn"));
                input.put("traditional_use_question", (Object)((JSONObject)cnAndTwMap.get(queryQuestion)).getString("tw"));
                if (StringUtils.isNotEmpty((CharSequence)target_standard_name)) {
                    input.put("simplified_target_standard_name", (Object)((JSONObject)cnAndTwMap.get(target_standard_name)).getString("cn"));
                    input.put("traditional_target_standard_name", (Object)((JSONObject)cnAndTwMap.get(target_standard_name)).getString("tw"));
                }
                logCheckDto.buildParams("SearchTargetsource", "P.SCRUMBI.502.0204", input.toJSONString(), "\u67e5\u8be2ES\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8c03\u7528\u7684ES\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010errorMsg\u3011".replace("errorMsg", e.getMessage()), "\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5ES\u670d\u52a1");
                logCheckDtos.add(logCheckDto);
                context.put("logCheckDtos", logCheckDtos);
            }
            log.info("targetsSearchedKey:{}", (Object)targetsSearchedKey);
            if (CollectionUtils.isNotEmpty((Collection)targetsSearchedKey)) {
                List datasourceNames = targetsSearchedKey.stream().map(t -> t.getString("datasourceName")).distinct().collect(Collectors.toList());
                Map map = this.translate(String.join((CharSequence)SPLITE, datasourceNames));
                map.entrySet().forEach(m -> cnAndTwMap.put((String)m.getKey(), (JSONObject)m.getValue()));
                datasourceNames.forEach(t -> {
                    JSONObject simplifiedTargetsAndSynonyms = (JSONObject)targetsAndSynonyms.get(((JSONObject)cnAndTwMap.get(t)).getString("cn"));
                    JSONObject traditionalTargetsAndSynonyms = (JSONObject)targetsAndSynonyms.get(((JSONObject)cnAndTwMap.get(t)).getString("tw"));
                    if (!Objects.isNull(simplifiedTargetsAndSynonyms)) {
                        accurateStandardWords.add(simplifiedTargetsAndSynonyms);
                    }
                    if (!Objects.isNull(traditionalTargetsAndSynonyms)) {
                        accurateStandardWords.add(traditionalTargetsAndSynonyms);
                    }
                    if (Objects.isNull(simplifiedTargetsAndSynonyms) && Objects.isNull(traditionalTargetsAndSynonyms)) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("standard_name", t);
                        accurateStandardWords.add(jsonObject);
                    }
                });
            }
            log.info("accurateStandardWords:{}", accurateStandardWords);
            for (JSONObject d : accurateStandardWords) {
                d.put("standard_name", (Object)((JSONObject)cnAndTwMap.get(d.getString("standard_name"))).getString("cn"));
                JSONArray synonyms = CollectionUtils.isEmpty((Collection)d.getJSONArray("synonyms")) ? new JSONArray() : d.getJSONArray("synonyms");
                ArrayList<String> distinctSynonyms = new ArrayList<String>();
                for (int i = 0; i < synonyms.size(); ++i) {
                    String traditionalString = synonyms.getString(i);
                    String simplifiedString = ((JSONObject)cnAndTwMap.get(traditionalString)).getString("cn");
                    distinctSynonyms.add(i, simplifiedString);
                }
                d.put("synonyms", (Object)new JSONArray(distinctSynonyms.stream().distinct().collect(Collectors.toList())));
            }
            List standardWords = DataProcessAfterSearchExecutor.filterLongestStandardWords(accurateStandardWords, (String)((JSONObject)cnAndTwMap.get(queryQuestion)).getString("cn"), (String)"standard_name");
            target_standard_name = standardWords.stream().map(source -> source.getString("standard_name")).collect(Collectors.joining(" "));
            String simplified_target_standard_name = standardWords.stream().map(source -> ((JSONObject)cnAndTwMap.get(source.getString("standard_name"))).getOrDefault((Object)"cn", (Object)"").toString()).collect(Collectors.joining(" "));
            String traditional_target_standard_name = standardWords.stream().map(source -> ((JSONObject)cnAndTwMap.get(source.getString("standard_name"))).getOrDefault((Object)"tw", (Object)"").toString()).collect(Collectors.joining(" "));
            if (CollectionUtils.isEmpty((Collection)standardWords) && CollectionUtils.isNotEmpty(accurateStandardWords)) {
                target_standard_name = accurateStandardWords.stream().map(json -> json.getString("standard_name")).max((name1, name2) -> Integer.compare(name1.length(), name2.length())).get();
                if (StringUtils.isEmpty((CharSequence)simplified_target_standard_name)) {
                    simplified_target_standard_name = target_standard_name;
                    traditional_target_standard_name = target_standard_name;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)target_standard_name)) {
                context.put("simplified_target_standard_name", (Object)simplified_target_standard_name);
                context.put("traditional_target_standard_name", (Object)traditional_target_standard_name);
                targets = Optional.ofNullable(Retrieve.TARGET_NOQUESTION.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
                context.put("target_standard_name", (Object)target_standard_name);
                if (CollectionUtils.isEmpty((Collection)targets)) {
                    log.info("\u67e5\u8be2\u76ee\u6807\u4e3a\u7a7a\uff0c\u8d70\u515c\u5e95\u903b\u8f91\u7ec4\u88c5\u539f\u53e5\u67e5\u8be2");
                    String originFinallyQuestion = ((Question)context.getObject("question", Question.class)).getOriginFinallyQuestion();
                    JSONObject param = new JSONObject();
                    param.put("applicationCodes", context.get((Object)"applicationCodes"));
                    param.put("version", context.get((Object)"version"));
                    param.put("orginal_question", (Object)(StringUtils.isEmpty((CharSequence)originFinallyQuestion) ? question : originFinallyQuestion));
                    param.put("not_query_all", (Object)"1");
                    targets = Optional.ofNullable(Retrieve.TARGET.retrieve(param)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
                }
            }
        } else {
            target_standard_name = matchVal;
            if (StringUtils.isNotEmpty((CharSequence)target_standard_name)) {
                context.put("simplified_target_standard_name", (Object)((JSONObject)cnAndTwMap.get(target_standard_name)).getString("cn"));
                context.put("traditional_target_standard_name", (Object)((JSONObject)cnAndTwMap.get(target_standard_name)).getString("tw"));
                targets = Optional.ofNullable(Retrieve.TARGET_NOQUESTION.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
                context.put("target_standard_name", (Object)target_standard_name);
            }
        }
        return targets;
    }

    private Map<String, JSONObject> translate(String key) {
        TranslateService bean = (TranslateService)SpringContextUtil.getBean(TranslateService.class);
        JSONObject cnAndTw = bean.cnAndTw(key);
        String[] cn = cnAndTw.getString("zh_CN").split(SPLITE);
        String[] tw = cnAndTw.getString("zh_TW").split(SPLITE);
        String[] orginal = key.split(SPLITE);
        HashMap<String, JSONObject> cnAndTwMap = new HashMap<String, JSONObject>();
        log.info("cn\u957f\u5ea6\u4e3a\uff1a{},tw\u957f\u5ea6\u4e3a\uff1a{},orginal\u957f\u5ea6\u4e3a\uff1a{}", new Object[]{cn.length, tw.length, orginal.length});
        for (int i = 0; i < cn.length; ++i) {
            String cnString = cn[i];
            String twString = tw[i];
            JSONObject orginalJsonObject = new JSONObject();
            orginalJsonObject.put("cn", (Object)cnString);
            orginalJsonObject.put("tw", (Object)twString);
            cnAndTwMap.put(orginal[i], orginalJsonObject);
            JSONObject cnStringJsonObject = new JSONObject();
            cnStringJsonObject.put("cn", (Object)cnString);
            cnStringJsonObject.put("tw", (Object)twString);
            cnAndTwMap.put(cnString, cnStringJsonObject);
            JSONObject twStringJsonObject = new JSONObject();
            twStringJsonObject.put("cn", (Object)cnString);
            twStringJsonObject.put("tw", (Object)twString);
            cnAndTwMap.put(twString, twStringJsonObject);
        }
        return cnAndTwMap;
    }
}

