/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.AppSystemEnum;
import com.digiwin.chatbi.common.enums.DebugMode;
import com.digiwin.chatbi.common.enums.MetricSearchResultEnum;
import com.digiwin.chatbi.common.enums.SelectRouter;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.MessageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TargetMetricSelectRouterExecutor
implements Executor {
    public Output doProcess(JSONObject context) {
        context.put("locale_zh", (Object)("zh_TW".equalsIgnoreCase(((Question)context.getObject("question", Question.class)).getLocale()) ? "\u7e41\u4f53\u4e2d\u6587" : "\u7b80\u4f53\u4e2d\u6587"));
        Output output = this.specialStrategy(context);
        if (Objects.nonNull(output)) {
            return output.keep("mix_mode_select_router_code", (Object)SelectRouter.SPECIAL_STRATEGY.getDesc());
        }
        if (MetricSearchResultEnum.NO_METRIC.getValue().equals(context.getString(MetricSearchResultEnum.NO_METRIC.getKey()))) {
            return Output.through().keep("scelect_metric", (Object)true).keep("mix_mode_select_router_code", (Object)SelectRouter.GPT_SEARCH_METRIC.getDesc());
        }
        String appSystem = context.getString("appSystem");
        List targetList = (List)context.getOrDefault((Object)"mixModeTargets", new ArrayList());
        List metricList = (List)context.getOrDefault((Object)"mixModeMetrics", new ArrayList());
        JSONObject targetMetricInfo = this.buildMixModeInfo(targetList, metricList);
        if (AppSystemEnum.DATASET.getValue().equals(appSystem)) {
            return Output.through().keep("scelect_dataSet", (Object)true).keep("mix_mode_select_router_code", (Object)SelectRouter.ONLY_DATASET.getDesc());
        }
        int targetSize = targetList.size();
        int metricSize = metricList.size();
        if (targetSize > 0 && metricSize == 0) {
            return Output.through().keep("scelect_scene", (Object)true).keep("mix_mode_metric_target_info", (Object)targetMetricInfo).keep("mix_mode_select_router_code", (Object)SelectRouter.ONLY_TARGET.getDesc());
        }
        if (metricSize > 0 && targetSize == 0) {
            return Output.through().keep("scelect_metric", (Object)true).keep("mix_mode_metric_target_info", (Object)targetMetricInfo).keep("mix_mode_select_router_code", (Object)SelectRouter.ONLY_METRIC.getDesc());
        }
        List targetCompareFieldsNames = targetList.stream().map(json -> (List)json.get((Object)"compare_fields")).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        List metricCompareFields = metricList.stream().map(json -> (List)json.get((Object)"compare_fields")).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        boolean targetContainsMetric = targetCompareFieldsNames.containsAll(metricCompareFields);
        boolean metricContainsTarget = metricCompareFields.containsAll(targetCompareFieldsNames);
        if (targetSize == 1 && metricSize == 1) {
            if (targetContainsMetric) {
                return Output.through().keep("scelect_scene_metric_mix", (Object)true).keep("mix_mode_metric_target_info", (Object)targetMetricInfo).keep("mix_mode_select_router_code", (Object)SelectRouter.ONE_METRIC_AND_TARGET.getDesc());
            }
            List targetNames = targetList.stream().map(t -> t.getString("datasourceName")).distinct().collect(Collectors.toList());
            List metricNames = metricList.stream().map(t -> t.getString("metricName")).distinct().collect(Collectors.toList());
            ArrayList mixTargetMetricList = new ArrayList();
            mixTargetMetricList.addAll(metricNames);
            mixTargetMetricList.addAll(targetNames);
            ArrayList mixTargetMetricNames = new ArrayList(new HashSet(mixTargetMetricList));
            ArrayList<String> mixTargetMetricNames4Lang = new ArrayList<String>();
            metricList = metricList.stream().collect(Collectors.collectingAndThen(Collectors.toMap(jsonObject -> jsonObject.getString("metricName"), jsonObject -> jsonObject, (existing, replacement) -> existing), targetMap -> targetMap.values().stream().collect(Collectors.toList())));
            String locale = ((Question)context.getObject("question", Question.class)).getLocale();
            for (String mixTargetMetricName : mixTargetMetricNames) {
                mixTargetMetricNames4Lang.add(StringUtil.translateName((String)mixTargetMetricName, (List)metricList, (String)locale));
            }
            String s = StringUtil.formatListToBracketsV2(mixTargetMetricNames4Lang);
            MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
            String reply = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.one.metric.target.position.error", locale, new Object[]{s});
            HashMap<String, List> map = new HashMap<String, List>();
            map.put("target", targetList);
            map.put("metric", metricList);
            return Output.through((String)"success", (Object)false).keep("locale_zh", (Object)("zh_TW".equalsIgnoreCase(locale) ? "\u7e41\u4f53\u4e2d\u6587" : "\u7b80\u4f53\u4e2d\u6587")).keep("need_sentences_param_4_mix", map).keep("sentences_param_4_metric", (Object)StringUtil.buildSentencesParam4Metric((List)metricList, (String)locale)).keep("scelect_metric", (Object)true).keep("mix_mode_metric_target_info", (Object)targetMetricInfo).keep("mix_mode_select_router_code", (Object)SelectRouter.ONE_METRIC_AND_TARGET_UNLOCATION.getDesc()).keep("reply", (Object)reply);
        }
        if (targetContainsMetric && metricContainsTarget) {
            return Output.through().keep("scelect_metric", (Object)true).keep("mix_mode_metric_target_info", (Object)targetMetricInfo).keep("mix_mode_select_router_code", (Object)SelectRouter.METRIC_TARGET_MUTUAL_CONTAIN.getDesc());
        }
        if (targetContainsMetric) {
            return Output.through().keep("scelect_scene", (Object)true).keep("mix_mode_metric_target_info", (Object)targetMetricInfo).keep("mix_mode_select_router_code", (Object)SelectRouter.TARGET_CONTAIN_METRIC.getDesc());
        }
        if (metricContainsTarget) {
            return Output.through().keep("scelect_metric", (Object)true).keep("mix_mode_metric_target_info", (Object)targetMetricInfo).keep("mix_mode_select_router_code", (Object)SelectRouter.METRIC_CONTAIN_TARGET.getDesc());
        }
        ArrayList mixTargetMetricList = new ArrayList();
        List targetNames = targetList.stream().map(t -> t.getString("datasourceName")).distinct().collect(Collectors.toList());
        List metricNames = metricList.stream().map(t -> t.getString("metricName")).distinct().collect(Collectors.toList());
        mixTargetMetricList.addAll(metricNames);
        mixTargetMetricList.addAll(targetNames);
        MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
        ArrayList mixTargetMetricNames = new ArrayList(new HashSet(mixTargetMetricList));
        ArrayList<String> mixTargetMetricNames4Lang = new ArrayList<String>();
        metricList = metricList.stream().collect(Collectors.collectingAndThen(Collectors.toMap(jsonObject -> jsonObject.getString("metricName"), jsonObject -> jsonObject, (existing, replacement) -> existing), targetMap -> targetMap.values().stream().collect(Collectors.toList())));
        String locale = ((Question)context.getObject("question", Question.class)).getLocale();
        for (String mixTargetMetricName : mixTargetMetricNames) {
            mixTargetMetricNames4Lang.add(StringUtil.translateName((String)mixTargetMetricName, (List)metricList, (String)locale));
        }
        String s = StringUtil.formatListToBracketsV2(mixTargetMetricNames4Lang);
        String reply = messageUtils.getMessageByLangNameWithFormat("message.scrumbi.metric.target.list.unrelated.parts.error", locale, new Object[]{s});
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("target", targetList);
        map.put("metric", metricList);
        return Output.through((String)"success", (Object)false).keep("need_sentences_param_4_mix", map).keep("sentences_param_4_metric", (Object)StringUtil.buildSentencesParam4Metric((List)metricList, (String)locale)).keep("scelect_metric", (Object)true).keep("mix_mode_metric_target_info", (Object)targetMetricInfo).keep("mix_mode_select_router_code", (Object)SelectRouter.TARGET_METRIC_UNRELATED.getDesc()).keep("reply", (Object)reply);
    }

    private Output specialStrategy(JSONObject context) {
        Question question = (Question)context.getObject("question", Question.class);
        String debugMode = question.getDebugMode();
        String sceneCode = question.getSceneCode();
        String targetId = question.getTargetId();
        List metricIds = question.getMetricIdList();
        if (StringUtils.isNotEmpty((CharSequence)debugMode) && (debugMode.equals(DebugMode.PARAM.getCode()) || debugMode.equals(DebugMode.PR_PARAM.getCode()) || debugMode.equals(DebugMode.DEBUG.getCode()) || debugMode.equals(DebugMode.TEST.getCode())) || StringUtils.isNotEmpty((CharSequence)sceneCode) || StringUtils.isNotEmpty((CharSequence)targetId) || "dataflow".equals(question.getMethod())) {
            return Output.through().keep("scelect_scene", (Object)true);
        }
        if (CollectionUtils.isNotEmpty((Collection)metricIds) || StringUtils.isNotEmpty((CharSequence)debugMode) && debugMode.equals(DebugMode.DEBUG_METRIC.getCode()) || "metric".equals(question.getMethod())) {
            return Output.through().keep("scelect_metric", (Object)true);
        }
        if (CollectionUtils.isNotEmpty((Collection)question.getDatasetIdList())) {
            return Output.through().keep("scelect_dataSet", (Object)true);
        }
        return null;
    }

    private JSONObject buildMixModeInfo(List<JSONObject> targetList, List<JSONObject> metricList) {
        JSONObject jsonObject;
        JSONObject mixModeInfo = new JSONObject();
        if (CollectionUtils.isNotEmpty(targetList)) {
            ArrayList<JSONObject> targetInfoList = new ArrayList<JSONObject>();
            for (JSONObject target : targetList) {
                jsonObject = new JSONObject();
                jsonObject.put("datasourceId", (Object)target.getString("datasourceId"));
                jsonObject.put("datasourceName", (Object)target.getString("datasourceName"));
                jsonObject.put("version", (Object)target.getString("version"));
                jsonObject.put("applicationCode", (Object)target.getString("applicationCode"));
                targetInfoList.add(jsonObject);
            }
            mixModeInfo.put("mixModeTargets", targetInfoList);
        }
        if (CollectionUtils.isNotEmpty(metricList)) {
            ArrayList<JSONObject> metricInfoList = new ArrayList<JSONObject>();
            for (JSONObject metric : metricList) {
                jsonObject = new JSONObject();
                jsonObject.put("metricName", (Object)metric.getString("metricName"));
                jsonObject.put("metricId", (Object)metric.getString("metricId"));
                jsonObject.put("version", (Object)metric.getString("version"));
                jsonObject.put("applicationCode", (Object)metric.getString("applicationCode"));
                metricInfoList.add(jsonObject);
            }
            mixModeInfo.put("mixModeMetrics", metricInfoList);
        }
        return mixModeInfo;
    }
}

