/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.exception.PipelineAssert;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.WordWeightCaculateExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.dependency.nnparser.NeuralNetworkDependencyParser;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WordWeightCaculateExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(WordWeightCaculateExecutor.class);

    public Output doProcess(JSONObject context) {
        return (Output)PipelineAssert.PIPELINE_EXECUTE_FAIL_ASSERT.tryCatch(() -> this.caculateWeight4Words(context), new Object[]{Output.through()});
    }

    private Output caculateWeight4Words(JSONObject context) {
        String text = ((Question)context.getObject("question", Question.class)).getMessage();
        NeuralNetworkDependencyParser parser = new NeuralNetworkDependencyParser();
        CoNLLSentence sentence = parser.parse(text);
        ArrayList<JSONObject> wordWeights = new ArrayList<JSONObject>();
        for (CoNLLWord word2 : sentence) {
            double weight = 1.0;
            CoNLLWord temp = word2;
            int distance = 0;
            if (word2 == word2.HEAD) {
                weight *= 1.5;
            }
            while (temp.HEAD != null && !temp.equals(temp.HEAD)) {
                ++distance;
                temp = temp.HEAD;
            }
            weight *= Math.pow(0.9, distance);
            double finalWeight = weight *= DEPREL.of((String)word2.DEPREL).getWeight();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("word", (Object)word2.NAME);
            jsonObject.put("deprel", (Object)word2.DEPREL);
            jsonObject.put("weight", (Object)finalWeight);
            wordWeights.add(jsonObject);
        }
        log.info(wordWeights.stream().map(word -> word.toJSONString()).reduce((x, y) -> x + "\n" + y).get());
        return Output.through((String)"wordWeights", wordWeights);
    }
}

