/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.convoBoard;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.BaseReq;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.KnowledgemapsService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAppAndVersionCommonExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchAppAndVersionCommonExecutor.class);

    public Output doProcess(JSONObject context) {
        String tenantName;
        String tenantId;
        String tenantVersion;
        List tenantAppCodes;
        BaseReq req = (BaseReq)context.getObject("baseReq", BaseReq.class);
        String routerKey = req.getRouterKey();
        String userToken = req.getToken();
        String userId = req.getUserId();
        String appCode = req.getAppCode();
        log.info("SearchAppAndVersionCommonExecutor routerKey is exist: {}", (Object)routerKey);
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            return Output.through((String)"version", (Object)"2.0");
        }
        JSONObject input = new JSONObject();
        input.put("userToken", (Object)userToken);
        input.put("routerKey", (Object)routerKey);
        input.put("userId", (Object)userId);
        try {
            KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
            JSONObject res = bean.getUserAppAndVersion(userToken, routerKey, userId);
            JSONArray tenantAppInfos = res.getJSONObject("response").getJSONArray("appCodes");
            tenantAppCodes = tenantAppInfos.stream().map(Object::toString).collect(Collectors.toList());
            tenantVersion = res.getJSONObject("response").getString("tenantVersion");
            tenantId = res.getJSONObject("profile").getString("tenantId");
            tenantName = res.getJSONObject("profile").getString("tenantName");
            userId = res.getJSONObject("profile").getString("userId");
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u6743\u9650\u83b7\u53d6\u7528\u6237\u5e94\u7528\u548c\u7248\u672c\u67e5\u8be2\u5931\u8d25:{}", (Throwable)e);
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"\u7528\u6237\u6743\u9650\u83b7\u53d6\u7528\u6237\u5e94\u7528\u548c\u7248\u672c\u67e5\u8be2\u5931\u8d25");
        }
        return Output.through((String)"version", (Object)tenantVersion).keep("applicationCodes", StringUtils.isEmpty((CharSequence)appCode) ? tenantAppCodes : Arrays.asList(appCode)).keep("tenantId", (Object)tenantId).keep("userId", (Object)userId).keep("tenantName", (Object)tenantName);
    }
}

