/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class FilterDataSetExecutor
implements Executor {
    private static final int MAX_COUNT = 5;

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        if (context.containsKey((Object)"TableFilter") || CollectionUtils.isNotEmpty((Collection)context.getJSONObject("TableFilter").getJSONArray("selected_tables"))) {
            JSONObject tableFilter = context.getJSONObject("TableFilter");
            JSONArray selected_tables = tableFilter.getJSONArray("selected_tables");
            List datasetIdsByGpt = selected_tables.stream().filter(id -> Objects.nonNull(id)).map(id -> (String)id).collect(Collectors.toList());
            List dataSets_with_permission = (List)context.getOrDefault((Object)"dataSets_with_permission", new ArrayList());
            List dataSets = dataSets_with_permission.stream().filter(dataSet -> datasetIdsByGpt.contains(dataSet.getString("datasetId"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(dataSets)) {
                return Output.through((String)"matched_table_ids_es", new ArrayList());
            }
            if (CollectionUtils.isEmpty(datasetIdsByGpt) || datasetIdsByGpt.size() <= 5) {
                Output keep = Output.through();
                return keep.keep("matched_table_ids_es", datasetIdsByGpt);
            }
            List datasetIdsByEs = (List)context.getOrDefault((Object)"matched_table_ids_es", new ArrayList());
            ArrayList<String> res = new ArrayList<String>();
            block0: for (String datasetIdByEs : datasetIdsByEs) {
                if (res.size() >= 5) break;
                for (String datasetIdByGpt : datasetIdsByGpt) {
                    if (res.size() >= 5) continue block0;
                    if (!datasetIdByEs.equals(datasetIdByGpt)) continue;
                    res.add(datasetIdByGpt);
                }
            }
            Output keep = Output.through();
            return keep.keep("matched_table_ids_es", res);
        }
        return Output.through((String)"matched_table_ids_es", new ArrayList());
    }
}

