/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.FilterKnowLedgeTypeEnum;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.sse.SseSendService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDataSetExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchDataSetExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        Question question = (Question)context.getObject("question", Question.class);
        List dataSets = (List)context.getOrDefault((Object)"final_dataSet", new ArrayList());
        String dataSetNames = dataSets.stream().map(metric -> metric.getString("datasetName")).collect(Collectors.toList()).toString();
        SseSendService sseSendService = (SseSendService)SpringContextUtil.getBean(SseSendService.class);
        sseSendService.asyncSendAQDetailAndSCTitle(question, dataSetNames, question.isIfStream(), context);
        for (JSONObject dataSet : dataSets) {
            dataSet.put("metricName", (Object)dataSet.getString("datasetName"));
            dataSet.put("metricId", (Object)dataSet.getString("datasetId"));
        }
        return Output.through().keep("filter_knowledge_type", (Object)FilterKnowLedgeTypeEnum.MATCH_TABLE_SECOND.getCode()).keep("final_dataSet", (Object)dataSets).keep("final_metric", (Object)dataSets).keep("billingGoodsId", (Object)(CollectionUtils.isNotEmpty((Collection)dataSets) ? ((JSONObject)dataSets.get(0)).getString("billingGoodsId") : "")).keep("sentences_param_4_schemas_check", (Object)StringUtil.buildSentencesParam4Metric((List)dataSets, (String)((Question)context.getObject("question", Question.class)).getLocale()));
    }
}

