/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.output;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.km.Condition;
import com.digiwin.chatbi.beans.km.Measurement;
import com.digiwin.chatbi.beans.km.Statistics;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.IntentType;
import com.digiwin.chatbi.common.exception.Supplier;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.MessageUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class NL2SQLOutputDataExecutor
implements Executor {
    public static final String OUTPUT_KEY = "finalResult";
    private final String promptTyp;
    private static final String PROMPT_NAME = "NL2SQL";

    public NL2SQLOutputDataExecutor(String promptTyp) {
        this.promptTyp = promptTyp;
    }

    public Output doProcess(JSONObject context) {
        JSONObject apiParams = context.getJSONObject(this.promptTyp + PROMPT_NAME);
        JSONArray data = new JSONArray();
        this.addFieldToData(data, () -> this.fixupMeasure(apiParams), new Predicate[]{Measurement::notEmpty});
        this.addFieldToData(data, () -> this.fixupFilter(apiParams), new Predicate[0]);
        this.addFieldToData(data, () -> this.fixupHaving(apiParams), new Predicate[0]);
        this.addFieldToData(data, () -> this.fixupSort(apiParams), new Predicate[0]);
        this.addFieldToData(data, () -> this.fixupLimit(apiParams), new Predicate[0]);
        int code = apiParams.containsKey((Object)"datasourceId") ? IntentType.GRAPH.getCode() : IntentType.OTHER.getCode();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("datasourceId", apiParams.get((Object)"datasourceId"));
        jsonObject.put("reply", apiParams.get((Object)"reply"));
        jsonObject.put("strategy", (Object)((Question)context.getObject("question", Question.class)).getStrategy());
        jsonObject.put("code", (Object)code);
        MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
        String reply = messageUtils.getMessageByLangName("message.scrumbi.no.target.alike", ((Question)context.getObject("question", Question.class)).getLocale());
        jsonObject.put("data", code > 0 ? data : (StringUtils.isEmpty((String)apiParams.getString("reply")) ? reply : apiParams.get((Object)"reply")));
        return Output.through((String)OUTPUT_KEY, (Object)jsonObject);
    }

    @SafeVarargs
    private final <T> void addFieldToData(JSONArray data, Supplier<T> fieldSupplier, Predicate<T> ... addWhenCondition) {
        try {
            Object field = fieldSupplier.get();
            if (Objects.nonNull(field) && Arrays.stream(addWhenCondition).allMatch(condition -> condition.test(field))) {
                data.add(field);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Measurement fixupMeasure(JSONObject apiParams) {
        if (!apiParams.containsKey((Object)"measures")) {
            return new Measurement();
        }
        JSONArray measures = apiParams.getJSONArray("measures");
        List list = measures.stream().map(measure -> (JSONObject)measure).map(measure -> {
            Statistics statistics = new Statistics();
            statistics.setTitle(measure.getString("title"));
            statistics.setStatisticalFields(Collections.singletonList(measure.getString("field")));
            statistics.setStatisticalMethod(measure.getString("statisticalMethod"));
            statistics.setNewField(CollectionUtils.isNotEmpty((Collection)statistics.getStatisticalFields()) ? ((String)statistics.getStatisticalFields().get(0)).concat("_").concat(statistics.getStatisticalMethod()) : measure.getString("newField"));
            return statistics;
        }).collect(Collectors.toList());
        Measurement measurement = new Measurement();
        Condition condition = new Condition();
        condition.setStatistics(list);
        measurement.setCondition(condition);
        this.fixupDimension(apiParams, measurement);
        return measurement;
    }

    private void fixupDimension(JSONObject apiParams, Measurement measurement) {
        if (!apiParams.containsKey((Object)"groupBy")) {
            measurement.getCondition().setFields(Collections.emptyList());
            return;
        }
        measurement.getCondition().setFields(apiParams.getJSONArray("groupBy").toJavaList(String.class));
    }

    private JSONObject fixupFilter(JSONObject apiParams) {
        if (this.noConditionKey(apiParams, "where")) {
            return null;
        }
        JSONObject filter = apiParams.getJSONObject("where");
        this.fixupFilterLogicType(filter);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)"filter");
        jsonObject.put("technique", (Object)"filter");
        jsonObject.put("condition", (Object)filter);
        return jsonObject;
    }

    private JSONObject fixupHaving(JSONObject apiParams) {
        if (this.noConditionKey(apiParams, "having")) {
            return null;
        }
        JSONObject having = apiParams.getJSONObject("having");
        this.fixupFilterLogicType(having);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)"having");
        jsonObject.put("technique", (Object)"filter");
        jsonObject.put("condition", (Object)having);
        return jsonObject;
    }

    private JSONObject fixupLimit(JSONObject apiParams) {
        if (this.noConditionKey(apiParams, "limit")) {
            return null;
        }
        JSONObject condition = apiParams.getJSONObject("limit");
        condition.put("fields", Collections.emptyList());
        condition.put("statistics", condition.getJSONArray("statistics").stream().map(statistic -> (JSONObject)statistic).peek(statistic -> {
            statistic.put("mode", (Object)"normal");
            statistic.put("statisticalMethod", (Object)"limit");
        }).collect(Collectors.toList()));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)"limit");
        jsonObject.put("technique", (Object)"group");
        jsonObject.put("condition", (Object)condition);
        return jsonObject;
    }

    private JSONObject fixupSort(JSONObject apiParams) {
        if (this.noConditionKey(apiParams, "sort")) {
            return null;
        }
        JSONObject condition = apiParams.getJSONObject("sort");
        condition.put("fields", Collections.emptyList());
        condition.put("statistics", condition.getJSONArray("statistics").stream().map(statistic -> (JSONObject)statistic).peek(statistic -> {
            statistic.put("mode", (Object)"normal");
            statistic.put("statisticalMethod", (Object)"sort");
            Optional.of(this.fixupMeasure(apiParams)).map(Measurement::getCondition).map(Condition::getStatistics).map(statistics -> CollectionUtils.isNotEmpty((Collection)statistics) ? ((Statistics)statistics.get(0)).getNewField() : null).ifPresent(measureNewField -> statistic.put("statisticalFields", Collections.singletonList(measureNewField)));
        }).collect(Collectors.toList()));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)"sort");
        jsonObject.put("technique", (Object)"group");
        jsonObject.put("condition", (Object)condition);
        return jsonObject;
    }

    private void fixupFilterLogicType(JSONObject filter) {
        if (!filter.containsKey((Object)"items") || CollectionUtils.isEmpty((Collection)filter.getJSONArray("items"))) {
            filter.put("logitype", (Object)"single");
            return;
        }
        filter.put("items", filter.getJSONArray("items").toJavaList(JSONObject.class).stream().peek(arg_0 -> this.fixupFilterLogicType(arg_0)).collect(Collectors.toList()));
    }

    private boolean noConditionKey(JSONObject apiParams, String key) {
        return !apiParams.containsKey((Object)key);
    }
}

