/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.knowledge;

import com.digiwin.chatbi.common.exception.PromptAssert;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.common.util.TemplateBroker;
import com.digiwin.chatbi.reasoning.search.template.Dsl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class TemplateLocalFileBroker4Knowledge
implements TemplateBroker {
    private static final Logger log = LoggerFactory.getLogger(TemplateLocalFileBroker4Knowledge.class);

    @PostConstruct
    public void loadPrompts() {
        Resource[] resources = (Resource[])PromptAssert.PROMPT_LOAD_FILE_FAILED_ASSERT.tryCatch(() -> new PathMatchingResourcePatternResolver().getResources("classpath:knowledge/**/*.*"), new Object[0]);
        this.put(Arrays.stream(resources).map(resource -> {
            Dsl dsl;
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));
            try {
                String line;
                String[] split = resource.getURI().toString().replace("/", "&&").replace("\\", "&&").split("&&");
                String type = split[split.length - 2];
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
                dsl = Dsl.New((String)Objects.requireNonNull(resource.getFilename()).replace(StringUtil.getLastDotAndContent((String)resource.getFilename()), ""), (String)type, (String)content.toString());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to get file from resource: " + resource, e);
                }
            }
            reader.close();
            return dsl;
        }).collect(Collectors.toList()));
    }
}

