/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.optimizer.parser;

import com.digiwin.chatbi.reasoning.optimizer.ast.CNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.FNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.HNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.JNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.SNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.StepNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.SubQNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.WNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SolutionStepParser {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public List<StepNode> parse(String dsl) throws Exception {
        JsonNode rootNode = this.objectMapper.readTree(dsl);
        ArrayList<StepNode> steps = new ArrayList<StepNode>();
        if (rootNode.isArray()) {
            ArrayNode stepsArray = (ArrayNode)rootNode;
            for (JsonNode stepNode : stepsArray) {
                steps.add(this.parseStepNode(stepNode));
            }
        } else if (rootNode.has("step")) {
            ArrayNode stepsArray = (ArrayNode)rootNode.get("step");
            for (JsonNode stepNode : stepsArray) {
                steps.add(this.parseStepNode(stepNode));
            }
        } else {
            steps.add(this.parseStepNode(rootNode));
        }
        return steps;
    }

    private StepNode parseStepNode(JsonNode stepNode) {
        StepNode step = new StepNode();
        if (stepNode.has("as")) {
            step.setAs(stepNode.get("as").asText());
        }
        if (stepNode.has("F")) {
            step.setF(this.parseFNode(stepNode.get("F")));
        }
        if (stepNode.has("C")) {
            step.setC(this.parseCNode(stepNode.get("C")));
        }
        if (stepNode.has("J")) {
            ArrayList<JNode> joins = new ArrayList<JNode>();
            JsonNode jNode = stepNode.get("J");
            if (jNode.isArray()) {
                for (JsonNode joinNode : jNode) {
                    joins.add(this.parseJNode(joinNode));
                }
            } else {
                joins.add(this.parseJNode(jNode));
            }
            step.setJ(joins);
        }
        if (stepNode.has("G")) {
            ArrayList<String> groupByFields = new ArrayList<String>();
            JsonNode gNode = stepNode.get("G");
            if (gNode.isArray()) {
                for (JsonNode fieldNode : gNode) {
                    groupByFields.add(fieldNode.asText());
                }
            } else {
                groupByFields.add(gNode.asText());
            }
            step.setG(groupByFields);
        }
        if (stepNode.has("W")) {
            step.setW(this.parseWNode(stepNode.get("W")));
        }
        if (stepNode.has("H")) {
            step.setH(this.parseHNode(stepNode.get("H")));
        }
        if (stepNode.has("O")) {
            ArrayList<String> orderByFields = new ArrayList<String>();
            JsonNode oNode = stepNode.get("O");
            if (oNode.isArray()) {
                for (JsonNode fieldNode : oNode) {
                    orderByFields.add(fieldNode.asText());
                }
            } else {
                orderByFields.add(oNode.asText());
            }
            step.setO(orderByFields);
        }
        if (stepNode.has("L")) {
            ArrayList<Integer> limitFields = new ArrayList<Integer>();
            JsonNode lNode = stepNode.get("L");
            if (lNode.isArray()) {
                for (JsonNode fieldNode : lNode) {
                    limitFields.add(fieldNode.asInt());
                }
            } else {
                limitFields.add(lNode.asInt());
            }
            step.setL(limitFields);
        }
        if (stepNode.has("S")) {
            step.setS(this.parseSNode(stepNode.get("S")));
        }
        return step;
    }

    private FNode parseFNode(JsonNode fNode) {
        FNode f = new FNode();
        if (fNode.has("metric")) {
            f.setMetric(fNode.get("metric").asText());
        }
        if (fNode.has("subQ")) {
            f.setSubQ(this.parseSubQNode(fNode.get("subQ")));
        }
        if (fNode.has("step")) {
            f.setStep(fNode.get("step").asText());
        }
        if (fNode.has("table")) {
            f.setTable(fNode.get("table").asText());
        }
        return f;
    }

    private SubQNode parseSubQNode(JsonNode subQNode) {
        SubQNode subQ = new SubQNode();
        if (subQNode.has("as")) {
            subQ.setAs(subQNode.get("as").asText());
        }
        if (subQNode.has("F")) {
            subQ.setF(this.parseFNode(subQNode.get("F")));
        }
        if (subQNode.has("S")) {
            subQ.setS(this.parseSNode(subQNode.get("S")));
        }
        if (subQNode.has("J")) {
            ArrayList<JNode> joins = new ArrayList<JNode>();
            JsonNode jNode = subQNode.get("J");
            if (jNode.isArray()) {
                for (JsonNode joinNode : jNode) {
                    joins.add(this.parseJNode(joinNode));
                }
            } else {
                joins.add(this.parseJNode(jNode));
            }
            subQ.setJ(joins);
        }
        if (subQNode.has("W")) {
            subQ.setW(this.parseWNode(subQNode.get("W")));
        }
        if (subQNode.has("G")) {
            ArrayList<String> groupByFields = new ArrayList<String>();
            JsonNode gNode = subQNode.get("G");
            if (gNode.isArray()) {
                for (JsonNode fieldNode : gNode) {
                    groupByFields.add(fieldNode.asText());
                }
            } else {
                groupByFields.add(gNode.asText());
            }
            subQ.setG(groupByFields);
        }
        if (subQNode.has("H")) {
            subQ.setH(this.parseHNode(subQNode.get("H")));
        }
        if (subQNode.has("O")) {
            ArrayList<String> orderByFields = new ArrayList<String>();
            JsonNode oNode = subQNode.get("O");
            if (oNode.isArray()) {
                for (JsonNode fieldNode : oNode) {
                    orderByFields.add(fieldNode.asText());
                }
            } else {
                orderByFields.add(oNode.asText());
            }
            subQ.setO(orderByFields);
        }
        if (subQNode.has("L")) {
            ArrayList<Integer> limitFields = new ArrayList<Integer>();
            JsonNode lNode = subQNode.get("L");
            if (lNode.isArray()) {
                for (JsonNode fieldNode : lNode) {
                    limitFields.add(fieldNode.asInt());
                }
            } else {
                limitFields.add(lNode.asInt());
            }
            subQ.setL(limitFields);
        }
        if (subQNode.has("C")) {
            subQ.setC(this.parseCNode(subQNode.get("C")));
        }
        return subQ;
    }

    private CNode parseCNode(JsonNode cNode) {
        CNode c = new CNode();
        HashMap calculations = new HashMap();
        Iterator it = cNode.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            ArrayList<String> exprs = new ArrayList<String>();
            JsonNode exprNode = cNode.get(key);
            if (exprNode.isArray()) {
                for (JsonNode e : exprNode) {
                    exprs.add(e.asText());
                }
            } else {
                exprs.add(exprNode.asText());
            }
            calculations.put(key, exprs);
            c.put((Object)key, exprs);
        }
        c.setCalculations(calculations);
        return c;
    }

    private JNode parseJNode(JsonNode jNode) {
        JNode j = new JNode();
        if (jNode.has("joinType")) {
            j.setJoinType(jNode.get("joinType").asText());
        }
        if (jNode.has("f")) {
            j.setF(this.parseFNode(jNode.get("f")));
        }
        if (jNode.has("on")) {
            ArrayList<String> onFields = new ArrayList<String>();
            JsonNode onNode = jNode.get("on");
            if (onNode.isArray()) {
                for (JsonNode fieldNode : onNode) {
                    onFields.add(fieldNode.asText());
                }
            } else {
                onFields.add(onNode.asText());
            }
            j.setOn(onFields);
        }
        if (jNode.has("w")) {
            j.setW(this.parseWNode(jNode.get("w")));
        }
        return j;
    }

    private WNode parseWNode(JsonNode wNode) {
        WNode w = new WNode();
        Map conditions = this.parseConditions(wNode);
        w.setConditions(conditions);
        return w;
    }

    private HNode parseHNode(JsonNode hNode) {
        HNode h = new HNode();
        Map conditions = this.parseConditions(hNode);
        h.setConditions(conditions);
        return h;
    }

    private Map<String, Object> parseConditions(JsonNode node) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            JsonNode valueNode = node.get(key);
            if (valueNode.isObject()) {
                conditions.put(key, this.parseConditions(valueNode));
                continue;
            }
            if (valueNode.isArray()) {
                ArrayList<Object> conditionList = new ArrayList<Object>();
                for (JsonNode item : valueNode) {
                    if (item.isObject()) {
                        conditionList.add(this.parseConditions(item));
                        continue;
                    }
                    conditionList.add(item.asText());
                }
                conditions.put(key, conditionList);
                continue;
            }
            conditions.put(key, valueNode.asText());
        }
        return conditions;
    }

    private SNode parseSNode(JsonNode sNode) {
        SNode s = new SNode();
        if (sNode.has("field")) {
            ArrayList<String> fields = new ArrayList<String>();
            JsonNode fieldNode = sNode.get("field");
            if (fieldNode.isArray()) {
                for (JsonNode f : fieldNode) {
                    fields.add(f.asText());
                }
            } else {
                fields.add(fieldNode.asText());
            }
            s.setField(fields);
        }
        return s;
    }
}

