/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.optimizer.rule;

import com.digiwin.chatbi.reasoning.optimizer.ast.StepNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.WNode;
import com.digiwin.chatbi.reasoning.optimizer.rule.OptimizationRule;
import java.util.List;
import java.util.Map;

public class R1FilterGClauseRule
implements OptimizationRule {
    public boolean apply(List<StepNode> steps) {
        boolean changed = false;
        for (StepNode step : steps) {
            List groupByFields = step.getG();
            WNode whereClause = step.getW();
            if (groupByFields == null || groupByFields.isEmpty() || whereClause == null) continue;
            boolean allFieldsFiltered = true;
            for (String field : groupByFields) {
                if (this.isFieldPreciselyFiltered(whereClause, field)) continue;
                allFieldsFiltered = false;
                break;
            }
            if (!allFieldsFiltered) continue;
            step.setG(null);
            changed = true;
        }
        return changed;
    }

    private boolean isFieldPreciselyFiltered(WNode whereClause, String field) {
        Map conditions = whereClause.getConditions();
        if (conditions == null) {
            return false;
        }
        if (this.checkConditionForField(conditions, field)) {
            return true;
        }
        for (Object value : conditions.values()) {
            if (value instanceof Map) {
                Map nestedConditions = (Map)value;
                if (!this.checkConditionForField(nestedConditions, field)) continue;
                return true;
            }
            if (!(value instanceof List)) continue;
            List conditionList = (List)value;
            for (Object item : conditionList) {
                Map nestedConditions;
                if (!(item instanceof Map) || !this.checkConditionForField(nestedConditions = (Map)item, field)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkConditionForField(Map<String, Object> conditions, String field) {
        Object value;
        if (conditions.containsKey(field + " eq")) {
            return true;
        }
        return conditions.containsKey(field + " in") && (value = conditions.get(field + " in")) instanceof List && ((List)value).size() == 1;
    }

    public String getName() {
        return "R1: W\u7cbe\u7b5b\u8986\u76d6G \u2192 \u79fb\u9664G\u5b50\u53e5";
    }
}

