/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.optimizer.rule;

import com.digiwin.chatbi.reasoning.optimizer.ast.JNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.StepNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.WNode;
import com.digiwin.chatbi.reasoning.optimizer.rule.OptimizationRule;
import java.util.List;
import java.util.Map;

public class R7OptimizeJoinTypeRule
implements OptimizationRule {
    public boolean apply(List<StepNode> steps) {
        boolean changed = false;
        for (StepNode step : steps) {
            List joins = step.getJ();
            if (joins == null || joins.isEmpty()) continue;
            for (JNode join : joins) {
                String type = join.getJoinType();
                if (!"left".equalsIgnoreCase(type) || !this.hasNonNullConstraint(join.getW())) continue;
                join.setJoinType("inner");
                changed = true;
            }
        }
        return changed;
    }

    private boolean hasNonNullConstraint(WNode whereClause) {
        if (whereClause == null) {
            return false;
        }
        Map conditions = whereClause.getConditions();
        if (conditions == null) {
            return false;
        }
        if (this.checkForNotNullConstraint(conditions)) {
            return true;
        }
        for (Object value : conditions.values()) {
            if (value instanceof Map) {
                Map nestedConditions = (Map)value;
                if (!this.checkForNotNullConstraint(nestedConditions)) continue;
                return true;
            }
            if (!(value instanceof List)) continue;
            List conditionList = (List)value;
            for (Object item : conditionList) {
                Map nestedConditions;
                if (!(item instanceof Map) || !this.checkForNotNullConstraint(nestedConditions = (Map)item)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkForNotNullConstraint(Map<String, Object> conditions) {
        for (String key : conditions.keySet()) {
            Object value;
            if (key.endsWith(" is not null")) {
                return true;
            }
            if (!key.endsWith(" not eq") && !key.endsWith(" neq") || (value = conditions.get(key)) == null || !"null".equalsIgnoreCase(value.toString()) && !value.toString().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return "R7: \u4f18\u5316\u8fde\u63a5\u7c7b\u578b";
    }
}

