/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.pipeline;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.client.GPT_CLIENT;
import com.digiwin.chatbi.common.util.MdcUtil;
import com.digiwin.chatbi.config.ThreadPoolManager;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.ExecutorFactory;
import com.digiwin.chatbi.reasoning.executor.extract.dataSet.BuildFieldsParam4GptExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.dataSet.FilterAllUsefulKnowledgeExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.dataSet.LogicFormExtractExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.dataSet.SearchMatchestFieldAndDataSetsExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.dataSet.SearchTableExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.dataSet.SupplementDataSetsByGptFindedFieldsExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.dataSet.TableAugmentedInfoExtractExecutor;
import com.digiwin.chatbi.reasoning.executor.prompt.PromptExecutor;
import com.digiwin.chatbi.reasoning.pipeline.PipelineWithoutTrace;
import com.digiwin.chatbi.reasoning.pipeline.condition.Condition;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MatchDatasetPipeline {
    private static final Logger log = LoggerFactory.getLogger(MatchDatasetPipeline.class);
    static PipelineWithoutTrace MATCH_TABLE_PIPELINE = new PipelineWithoutTrace().execute(new Executor[]{new TableAugmentedInfoExtractExecutor()}).execute(new Executor[]{new FilterAllUsefulKnowledgeExecutor()}).execute(new Executor[]{PromptExecutor.OfExecutor((String)"prompts", (String)"QueryLogicForm", (GPT_CLIENT)GPT_CLIENT.RH.HK.GPT4O)}).execute(new Executor[]{new LogicFormExtractExecutor()}).execute(new Executor[]{new SearchTableExecutor()}).execute((Condition)Condition.If(context -> context.getJSONArray("matched_table_ids_es").size() > 3).Then(new Executor[]{new FilterAllUsefulKnowledgeExecutor()})).execute((Condition)Condition.If(context -> context.getJSONArray("matched_table_ids_es").size() > 0).Then(new Executor[]{ExecutorFactory.SEARCH_DIMENSION_ENTITIES})).execute(new Executor[]{new SearchMatchestFieldAndDataSetsExecutor()}).execute(new Executor[]{new BuildFieldsParam4GptExecutor()}).execute((Condition)Condition.If(context -> context.getJSONArray("matched_table_ids_es").size() < 2 && CollectionUtils.isEmpty((Collection)context.getJSONArray("field_list_info"))).Then(new Executor[]{context -> Output.finish((String)"matched_table_ids_es", (Object)context.getJSONArray("matched_table_ids_es"))}).Else(new Executor[]{PromptExecutor.OfExecutor((String)"prompts", (String)"TableFilter", (GPT_CLIENT)GPT_CLIENT.RH.HK.GPT4_1)})).execute(new Executor[]{new SupplementDataSetsByGptFindedFieldsExecutor()});

    public static JSONArray process(JSONObject context) {
        String ptxId = ((Question)context.getObject("question", Question.class)).getPtxId();
        List dataSets_with_permission = (List)context.getOrDefault((Object)"dataSets_with_permission", new ArrayList());
        Map groupedData = dataSets_with_permission.stream().map(dataset -> {
            JSONObject json = new JSONObject();
            json.put("applicationCode", (Object)dataset.getString("applicationCode"));
            json.put("applicationName", (Object)dataset.getString("applicationName"));
            json.put("datasetId", (Object)dataset.getString("datasetId"));
            return json;
        }).collect(Collectors.groupingBy(obj -> obj.getString("applicationCode"), Collectors.toList()));
        ExecutorService customThreadPool = ThreadPoolManager.getPipelineExecutorPool();
        ArrayList<CompletableFuture<List>> futures = new ArrayList<CompletableFuture<List>>();
        for (Map.Entry entrySet : groupedData.entrySet()) {
            String string = entrySet.getKey();
            JSONObject subContext = JSONObject.parseObject((String)context.toJSONString());
            subContext.remove((Object)"logCheckDtos");
            subContext.put("appCodesCondition", Arrays.asList(string));
            CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                try {
                    if (StringUtils.isNotEmpty((CharSequence)ptxId)) {
                        MdcUtil.setTraceId((String)ptxId);
                    }
                    JSONObject outputContext = MATCH_TABLE_PIPELINE.accept((Map)subContext).getOutputContext();
                    List list = (List)outputContext.getOrDefault((Object)"matched_table_ids_es", new ArrayList());
                    return list;
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    log.error("\u6267\u884c\u627e\u8868\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
                finally {
                    MdcUtil.clear();
                }
                return null;
            }, customThreadPool);
            futures.add(future);
        }
        JSONArray res = new JSONArray();
        for (CompletableFuture completableFuture : futures) {
            List matchedDatasetIds = new ArrayList();
            try {
                matchedDatasetIds = (List)completableFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error("\u6267\u884c\u627e\u8868\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            String currentApplicationCode = null;
            String currentApplicationName = null;
            for (Map.Entry entrySet : groupedData.entrySet()) {
                List value = entrySet.getValue();
                List datasetIds = value.stream().map(v -> v.getString("datasetId")).collect(Collectors.toList());
                boolean hasIntersection = datasetIds.stream().anyMatch(matchedDatasetIds::contains);
                if (!hasIntersection) continue;
                currentApplicationCode = entrySet.getKey();
                currentApplicationName = ((JSONObject)value.get(0)).getString("applicationName");
                break;
            }
            if (!StringUtils.isNotEmpty(currentApplicationCode)) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("applicationCode", currentApplicationCode);
            jsonObject.put("applicationName", currentApplicationName);
            jsonObject.put("datasetIds", matchedDatasetIds);
            res.add((Object)jsonObject);
        }
        return res;
    }
}

