/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.pipeline;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.PipelineExecutor;
import com.digiwin.chatbi.reasoning.pipeline.PipelineWithoutTraceExecutor;
import com.digiwin.chatbi.reasoning.pipeline.condition.Condition;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineWithoutTrace {
    private static final Logger log = LoggerFactory.getLogger(PipelineWithoutTrace.class);
    private final List<Condition> conditionExecutors = new LinkedList();
    private final List<Executor> finalExecutors = new LinkedList();
    private static final TransmittableThreadLocal<List<Map<String, String>>> timeTrackingStack = new TransmittableThreadLocal();
    private static final TransmittableThreadLocal<List<Map<String, Output>>> outputTraceStack = new TransmittableThreadLocal();
    private static final TransmittableThreadLocal<String> userTokenStack = new TransmittableThreadLocal();
    private static final TransmittableThreadLocal<String> routerKeyStack = new TransmittableThreadLocal();
    private static final TransmittableThreadLocal<String> messageIdStack = new TransmittableThreadLocal();
    private static final TransmittableThreadLocal<String> ptxIdStack = new TransmittableThreadLocal();

    public static synchronized void addTimeTrace(Map<String, String> timeTrace) {
        log.info("PipelineWithoutTrace.addTimeTrace");
    }

    public static synchronized void addOutputTrace(Map<String, Output> outputTrace) {
        log.info("PipelineWithoutTrace.addOutputTrace");
    }

    public static synchronized void addUserToken(String userToken) {
        if (Objects.isNull(userTokenStack.get())) {
            userTokenStack.set((Object)"");
        }
        userTokenStack.set((Object)userToken);
    }

    public static synchronized void addRouterKey(String userToken) {
        if (Objects.isNull(routerKeyStack.get())) {
            routerKeyStack.set((Object)"");
        }
        routerKeyStack.set((Object)userToken);
    }

    public static synchronized void addMessageId(String messageId) {
        if (Objects.isNull(messageIdStack.get())) {
            messageIdStack.set((Object)"");
        }
        messageIdStack.set((Object)messageId);
    }

    public static synchronized void addPtxId(String ptxId) {
        if (Objects.isNull(ptxIdStack.get())) {
            ptxIdStack.set((Object)"");
        }
        ptxIdStack.set((Object)ptxId);
    }

    public static List<Map<String, String>> getTimeTrace() {
        if (Objects.isNull(timeTrackingStack.get())) {
            return Collections.emptyList();
        }
        List timeTrace = (List)timeTrackingStack.get();
        timeTrackingStack.remove();
        return timeTrace;
    }

    public static List<Map<String, Output>> getOutputTrace() {
        if (Objects.isNull(outputTraceStack.get())) {
            return Collections.emptyList();
        }
        List outputTrace = (List)outputTraceStack.get();
        outputTraceStack.remove();
        return outputTrace;
    }

    public static String getUserToken() {
        if (Objects.isNull(userTokenStack.get())) {
            return "";
        }
        String userToken = (String)userTokenStack.get();
        userTokenStack.remove();
        return userToken;
    }

    public static String getRouterKey() {
        if (Objects.isNull(routerKeyStack.get())) {
            return "";
        }
        String userToken = (String)routerKeyStack.get();
        routerKeyStack.remove();
        return userToken;
    }

    public static String getMessageId() {
        if (Objects.isNull(messageIdStack.get())) {
            return "";
        }
        String messageId = (String)messageIdStack.get();
        messageIdStack.remove();
        return messageId;
    }

    public static String getPtxId() {
        if (Objects.isNull(ptxIdStack.get())) {
            return "";
        }
        String ptxId = (String)ptxIdStack.get();
        ptxIdStack.remove();
        return ptxId;
    }

    public PipelineWithoutTrace param(String key, Object value) {
        return this.function(context -> Output.through((String)key, (Object)value));
    }

    public PipelineWithoutTrace function(Function<JSONObject, Output> executor) {
        Executor[] executorArray = new Executor[1];
        executorArray[0] = executor::apply;
        return this.execute(executorArray);
    }

    public PipelineWithoutTrace execute(Executor ... executors) {
        return this.execute(context -> executors);
    }

    public PipelineWithoutTrace execute(Condition conditionPipeline) {
        this.conditionExecutors.add(conditionPipeline);
        return this;
    }

    public PipelineWithoutTrace finallyExecute(Executor executor) {
        this.finalExecutors.add(executor);
        return this;
    }

    public Output accept(String key, Object value) {
        PipelineExecutor pipelineExecutor = new PipelineExecutor().execute(new Executor[]{context -> Output.through((String)key, (Object)value)});
        this.conditionExecutors.forEach(arg_0 -> ((PipelineExecutor)pipelineExecutor).executeWhen(arg_0));
        this.finalExecutors.forEach(arg_0 -> ((PipelineExecutor)pipelineExecutor).finallyExecute(arg_0));
        return pipelineExecutor.getResult();
    }

    public Output accept(Map<String, Object> initContext) {
        PipelineWithoutTraceExecutor pipelineExecutor = new PipelineWithoutTraceExecutor().execute(new Executor[]{context -> {
            Output output = Output.through();
            initContext.forEach((arg_0, arg_1) -> ((Output)output).keep(arg_0, arg_1));
            return output;
        }});
        this.conditionExecutors.forEach(arg_0 -> ((PipelineWithoutTraceExecutor)pipelineExecutor).executeWhen(arg_0));
        this.finalExecutors.forEach(arg_0 -> ((PipelineWithoutTraceExecutor)pipelineExecutor).finallyExecute(arg_0));
        return pipelineExecutor.getResult();
    }

    public List<Output> accept(List<? extends Map<String, Object>> initContexts) {
        return initContexts.parallelStream().map(arg_0 -> this.accept(arg_0)).collect(Collectors.toList());
    }
}

