/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.process;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.convoBoard.ChartPlanReq;
import com.digiwin.chatbi.beans.pojos.convoBoard.LayoutDesignReq;
import com.digiwin.chatbi.common.enums.ChatResult4MetricCode;
import com.digiwin.chatbi.reasoning.constant.Strategy;
import com.digiwin.chatbi.reasoning.context.SseContext;
import com.digiwin.chatbi.reasoning.pipeline.Pipeline;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.sse.SseSendService4ConvoBoard;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConvoBoardProcess {
    private static final Logger log = LoggerFactory.getLogger(ConvoBoardProcess.class);
    @Autowired
    private SseSendService4ConvoBoard sseSendService;

    public JSONObject doChartPlan(ChartPlanReq req) {
        JSONObject param = new JSONObject();
        param.put("chartPlanReq", (Object)req);
        param.put("baseReq", (Object)req);
        Output output = Strategy.CHART_PLAN.getPipeline().accept((Map)param);
        JSONObject res = output.getOutputContext().getJSONObject("finalResult");
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        res.put("timeTrace", (Object)timeTrace);
        res.put("outputTrace", (Object)outputTrace);
        log.info("doChartPlan#res: {}", (Object)JSONObject.toJSONString((Object)res));
        return res;
    }

    public void doChartPlan4Stream(ChartPlanReq req) {
        SseContext.initResult4ConvoBoard((String)req.getId());
        JSONObject res = this.doChartPlan(req);
        res.remove((Object)"timeTrace");
        res.remove((Object)"outputTrace");
        this.sseSendService.sendResult(req.getId(), JSONObject.toJSONString((Object)res), ChatResult4MetricCode.GRAPH.getCode() == res.getIntValue("code"));
        if (Objects.nonNull(SseContext.getSseEmitter((String)req.getId()))) {
            SseContext.getSseEmitter((String)req.getId()).complete();
        }
        SseContext.cleanUpBoard((String)req.getId());
    }

    public JSONObject doLayoutDesign(LayoutDesignReq req) {
        JSONObject param = new JSONObject();
        param.put("layoutDesignReq", (Object)req);
        param.put("baseReq", (Object)req);
        Output output = Strategy.LAYOUT_DESIGN.getPipeline().accept((Map)param);
        JSONObject res = output.getOutputContext().getJSONObject("finalResult");
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        res.put("timeTrace", (Object)timeTrace);
        res.put("outputTrace", (Object)outputTrace);
        log.info("doLayoutDesign#res: {}", (Object)JSONObject.toJSONString((Object)res));
        return res;
    }
}

