/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.token.dataCell;

import com.digiwin.chatbi.reasoning.token.dataCell.WordEntity;

public class SentenceToken
implements Comparable<SentenceToken> {
    private int start;
    private int end;
    private WordEntity entity;
    private double accProb = 0.0;
    private SentenceToken bestPreWord;

    @Override
    public int compareTo(SentenceToken o) {
        if (this.start != o.getStart()) {
            return this.start - o.getStart();
        }
        return o.getEnd() - this.end;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        try {
            SentenceToken token = (SentenceToken)o;
            if (token != null && this.start == token.getStart() && this.end == token.end && this.entity.equals((Object)token.getEntity())) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "start\uff1a" + this.start + "\uff0cend\uff1a" + this.end + "\uff0c" + this.entity + "\uff0c\u6700\u4f73\u524d\u9a71\u8bcd\uff1a" + this.bestPreWord;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public WordEntity getEntity() {
        return this.entity;
    }

    public double getAccProb() {
        return this.accProb;
    }

    public SentenceToken getBestPreWord() {
        return this.bestPreWord;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setEntity(WordEntity entity) {
        this.entity = entity;
    }

    public void setAccProb(double accProb) {
        this.accProb = accProb;
    }

    public void setBestPreWord(SentenceToken bestPreWord) {
        this.bestPreWord = bestPreWord;
    }
}

