/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.search.config.GroundModelConfig;
import com.digiwin.chatbi.reasoning.search.config.MatchTableConfig;
import com.digiwin.chatbi.reasoning.search.config.ModelConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApolloService {
    private static final Logger log = LoggerFactory.getLogger(ApolloService.class);

    public String getQuestionQuotationMarksSwitch() {
        GroundModelConfig groundModelConfig = (GroundModelConfig)SpringContextUtil.getBean(GroundModelConfig.class);
        if ("local".equals(groundModelConfig.getGroundDeployment())) {
            return "1";
        }
        Config config = ConfigService.getAppConfig();
        return config.getProperty("question_quotation_marks_switch", "0");
    }

    public String getCustomModel() {
        GroundModelConfig groundModelConfig = (GroundModelConfig)SpringContextUtil.getBean(GroundModelConfig.class);
        if ("local".equals(groundModelConfig.getGroundDeployment())) {
            ModelConfig modelConfig = (ModelConfig)SpringContextUtil.getBean(ModelConfig.class);
            return modelConfig.getEnableCustomModel();
        }
        Config config = ConfigService.getAppConfig();
        return config.getProperty("scrumbi.customModel.switch", "false");
    }

    public String getMatchtableSwitch() {
        GroundModelConfig groundModelConfig = (GroundModelConfig)SpringContextUtil.getBean(GroundModelConfig.class);
        if ("local".equals(groundModelConfig.getGroundDeployment())) {
            MatchTableConfig matchTableConfig = (MatchTableConfig)SpringContextUtil.getBean(MatchTableConfig.class);
            return matchTableConfig.getAienable();
        }
        Config config = ConfigService.getAppConfig();
        return config.getProperty("scrumbi.matchtable.switch", "false");
    }

    public String getTestApollo() {
        GroundModelConfig groundModelConfig = (GroundModelConfig)SpringContextUtil.getBean(GroundModelConfig.class);
        if ("local".equals(groundModelConfig.getGroundDeployment())) {
            return "";
        }
        Config config = ConfigService.getAppConfig();
        return config.getProperty("test.apollo", "123");
    }
}

