/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.knowledgebase.KnowledgeFile;
import com.digiwin.chatbi.beans.pojos.vector.SearchDocsQo;
import com.digiwin.chatbi.beans.pojos.vector.SearchDocsResult;
import com.digiwin.chatbi.common.annotations.LogRecord;
import com.digiwin.chatbi.common.enums.KnowledgeBaseRequest;
import com.digiwin.chatbi.common.exception.KnowledgeBaseOperationAssert;
import com.digiwin.chatbi.reasoning.search.facade.EsIndexFacade;
import com.google.gson.Gson;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class KnowledgeBaseService {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeBaseService.class);
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private EsIndexFacade esIndexFacade;

    public void batchIndex(List<KnowledgeFile> knowledgeFiles) {
        knowledgeFiles.forEach(arg_0 -> this.index(arg_0));
    }

    public void index(KnowledgeFile knowledgeFile) {
        KnowledgeBaseOperationAssert.DATA_SOURCE_DATA_NOT_NULL_ASSERT.notNull((Object)knowledgeFile, new Object[0]);
        knowledgeFile.doInvalidCheck();
        if (!this.queryKnowledgeBases().contains(knowledgeFile.ofKnowledgeBaseName())) {
            this.createKnowledgeBase(knowledgeFile.ofKnowledgeBaseName());
            log.info("Created knowledge base: " + knowledgeFile.ofKnowledgeBaseName());
        }
        this.indexScrumDatasource(knowledgeFile);
        this.indexKnowledgeFile(knowledgeFile);
    }

    public void delete(KnowledgeFile knowledgeFile) {
        HttpPost httpPost = new HttpPost(KnowledgeBaseRequest.DELETE_DOC.getUrl());
        httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("knowledge_base_name", (Object)knowledgeFile.ofKnowledgeBaseName());
        jsonObject.put("doc_name", (Object)knowledgeFile.ofFullName());
        jsonObject.put("not_refresh_vs_cache", (Object)false);
        jsonObject.put("delete_content", (Object)false);
        httpPost.setEntity((HttpEntity)new StringEntity(jsonObject.toJSONString(), ContentType.APPLICATION_JSON));
        KnowledgeBaseOperationAssert.FILE_DELETE_FAILED_ASSERT.tryCatch(() -> this.requestDataSource((HttpUriRequest)httpPost), new Object[0]);
    }

    private void indexKnowledgeFile(KnowledgeFile knowledgeFile) {
        knowledgeFile.createTTFile();
        this.uploadDoc(knowledgeFile.ofNameFullPath(), knowledgeFile.ofKnowledgeBaseName());
        this.updateDocFile(knowledgeFile);
    }

    private void updateDocFile(KnowledgeFile knowledgeFile) {
        HttpPost httpPost = new HttpPost(KnowledgeBaseRequest.UPDATE_DOC.getUrl());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("knowledge_base_name", (Object)knowledgeFile.ofKnowledgeBaseName());
        jsonObject.put("file_name", (Object)knowledgeFile.ofFullName());
        jsonObject.put("not_refresh_vs_cache", (Object)false);
        httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        httpPost.setEntity((HttpEntity)new StringEntity(jsonObject.toJSONString(), ContentType.APPLICATION_JSON));
        KnowledgeBaseOperationAssert.FILE_UPDATE_FAILED_ASSERT.tryCatch(() -> this.requestDataSource((HttpUriRequest)httpPost), new Object[0]);
    }

    private void saveDetailsToDatabase() {
    }

    @LogRecord(isGpt="1")
    public List<String> queryKnowledgeBases() {
        log.info("\u83b7\u53d6\u77e5\u8bc6\u5e93\u5217\u8868\u5f00\u59cb...");
        try {
            URIBuilder uriBuilder = new URIBuilder(KnowledgeBaseRequest.LIST_KNOWLEDGE_BASES.getUrl());
            JSONObject resultJson = this.requestDataSource((HttpUriRequest)new HttpGet(uriBuilder.build().toString()));
            if (Objects.isNull(resultJson) || !resultJson.containsKey((Object)"data")) {
                return Collections.emptyList();
            }
            return resultJson.getJSONArray("data").toJavaList(String.class);
        }
        catch (URISyntaxException e) {
            log.error("URI syntax error", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void createKnowledgeBase(String knowledgeBaseName) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("knowledge_base_name", (Object)knowledgeBaseName);
        jsonObject.put("vector_store_type", (Object)"faiss");
        jsonObject.put("embed_model", (Object)"text-embedding-ada-002");
        HttpPost httpPost = new HttpPost(KnowledgeBaseRequest.CREATE_KNOWLEDGE_BASE.getUrl());
        httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        httpPost.setEntity((HttpEntity)new StringEntity(jsonObject.toJSONString(), ContentType.APPLICATION_JSON));
        KnowledgeBaseOperationAssert.KNOWLEDGE_BASE_CREATE_FAILED_ASSERT.tryCatch(() -> this.requestDataSource((HttpUriRequest)httpPost), new Object[0]);
    }

    public void uploadDoc(String fileName, String tenantSid) {
        HttpHeaders headers = this.getHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        FileSystemResource fileSystemResource = new FileSystemResource(fileName);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"file", (Object)fileSystemResource);
        params.add((Object)"knowledge_base_name", (Object)tenantSid);
        params.add((Object)"override", (Object)true);
        params.add((Object)"not_refresh_vs_cache", (Object)false);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)params, (MultiValueMap)headers);
        String result = (String)this.restTemplate.postForObject(KnowledgeBaseRequest.UPLOAD_DOC.getUrl(), (Object)requestEntity, String.class, new Object[0]);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        KnowledgeBaseOperationAssert.FILE_UPLOAD_FAILED_ASSERT.isTrue(jsonObject != null && "200".equals(jsonObject.getString("code")), new Object[]{result});
    }

    public List<SearchDocsResult> searchDocs(SearchDocsQo searchDocsQo) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", searchDocsQo.getQuery());
        params.put("knowledge_base_name", searchDocsQo.getKnowledge_base_name());
        params.put("top_k", searchDocsQo.getTop_k());
        params.put("score_threshold", searchDocsQo.getScore_threshold());
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)this.getHeaders());
        ResponseEntity exchangeData = this.restTemplate.exchange(KnowledgeBaseRequest.SEARCH_DOCS.getUrl(), HttpMethod.POST, httpEntity, String.class, new Object[0]);
        String resultRemote = (String)exchangeData.getBody();
        Gson gson = new Gson();
        return (List)gson.fromJson(resultRemote, new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/json;charset=UTF-8"));
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        headers.add("Accept-Charset", "UTF-8");
        return headers;
    }

    private JSONObject requestDataSource(HttpUriRequest request) {
        StopWatch stopWatch = StopWatch.createStarted();
        HttpResponse response = (HttpResponse)KnowledgeBaseOperationAssert.DATA_SOURCE_CONNECT_FAILED_ASSERT.tryCatch((Object)request, arg_0 -> ((CloseableHttpClient)HttpClients.createDefault()).execute(arg_0), new Object[0]);
        stopWatch.stop();
        log.info("Knowledge base call took: " + stopWatch.getTime() + "ms");
        JSONObject resultJson = JSONObject.parseObject((String)((String)KnowledgeBaseOperationAssert.DATA_SOURCE_RESPONSE_PARAS_FAILED_ASSERT.tryCatch((Object)response.getEntity(), EntityUtils::toString, new Object[0])));
        KnowledgeBaseOperationAssert.DATA_SOURCE_REQUEST_FAILED_ASSERT.isTrue(resultJson != null && resultJson.getString("code") != null && "200".equals(resultJson.getString("code")), new Object[0]);
        return resultJson;
    }

    public void indexScrumDatasource(KnowledgeFile knowledgeFile) {
        this.esIndexFacade.insertById(knowledgeFile.ofKnowledgeBaseName(), knowledgeFile.ofFileName(), JSONObject.parseObject((String)knowledgeFile.ofFullContent()), true);
    }
}

