/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.digiwin.chatbi.common.util.JSONUtils;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class MessageUtils {
    @Autowired
    private MessageSource messageSource;

    public String getMessage(String langKey) {
        return this.messageSource.getMessage(langKey, null, LocaleContextHolder.getLocale());
    }

    public String getMessageByLangName(String langKey, String langName) {
        String lang = langName;
        if (StringUtils.isNotBlank((String)lang)) {
            lang = StringUtils.replaceChars((String)lang, (char)'_', (char)'-');
        }
        return this.messageSource.getMessage(langKey, null, Locale.forLanguageTag(lang));
    }

    public String getMessageWithFormat(String langKey, Object ... paras) {
        return String.format(this.getMessage(langKey), paras);
    }

    public String getMessageByLangNameWithFormat(String langKey, String langName, Object ... paras) {
        return String.format(this.getMessageByLangName(langKey, langName), paras);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getMessageByLanguage(Object langObject, String langName) {
        if (langObject == null) {
            return "";
        }
        Map langMap = null;
        if (langObject instanceof String) {
            String valueText = langObject.toString();
            if (!valueText.startsWith("{") || !valueText.endsWith("}")) return valueText;
            try {
                langMap = (Map)JSONUtils.jsonToObject((String)valueText, Map.class);
            }
            catch (Exception e) {
                return valueText;
            }
        } else {
            if (!(langObject instanceof Map)) return langObject.toString();
            langMap = (Map)langObject;
        }
        if (!MapUtils.isNotEmpty((Map)langMap) || !langMap.containsKey(langName = langName.replace("-", "_"))) return langObject.toString();
        return (String)langMap.get(langName);
    }
}

