{
    "query": {
        "bool": {
            "filter": {
                "bool":{
                    "must":[
                        <#if applicationCode??>
                        {
                            "term": {
                                "applicationCode.keyword": "${applicationCode}"
                            }
                        },
                        </#if>
                        <#if applicationCodes??>
                        {
                            "terms": {
                                "applicationCode.keyword": [<#list applicationCodes as item>"${item}"<#sep>, </#list>]
                            }
                        },
                        </#if>
                        <#if version??>
                        {
                            "term": {
                                "version.keyword": "${version}"
                            }
                        },
                        </#if>
                        <#if targetId??>
                        {
                            "term": {
                                "datasourceId.keyword": "${targetId}"
                            }
                        },
                        </#if>
                        <#if not_query_all??>
                        {"bool":{"should":[
                            <#if simplified_use_question??>
                            {
                                "match": {
                                    "datasourceName": {
                                        "query": "${simplified_use_question}",
                                        "boost": 7,
                                        "analyzer": "ngram_analyzer"
                                    }
                                }
                            }
                            </#if>
                            <#if traditional_use_question??>
                            ,{
                                "match": {
                                    "datasourceName": {
                                        "query": "${traditional_use_question}",
                                        "boost": 7,
                                        "analyzer": "ngram_analyzer"
                                    }
                                }
                            }
                            </#if>
                            <#if simplified_target_standard_name??>
                            ,{
                                "match": {
                                    "datasourceName": {
                                        "query": "${simplified_target_standard_name}",
                                        "boost": 10,
                                        "analyzer": "whitespace"
                                    }
                                }
                            }
                            </#if>
                            <#if traditional_target_standard_name??>
                            ,{
                                "match": {
                                    "datasourceName": {
                                        "query": "${traditional_target_standard_name}",
                                        "boost": 10,
                                        "analyzer": "whitespace"
                                    }
                                }
                            }
                            </#if>
                            <#if orginal_question??>
                            ,{
                                "match": {
                                    "datasourceName": {
                                        "query": "${orginal_question}",
                                        "boost": 7,
                                        "analyzer": "ngram_analyzer"
                                    }
                                }
                            }
                            </#if>
                        ]}},

                        </#if>
                        {
                            "exists": {
                                "field": "datasourceId"
                            }
                        }
                    ]
                }
            }
        }
    },
    "size": 1000
}