{
    "_source": false,
    "query": {
        "bool": {
            <#if tenant_ids??>
            "must": [
                {
                    "terms": {
                        "tenant_id.keyword": [<#list tenant_ids as item>"${item}"<#sep>, </#list>]
                    }
                }
            ],
            </#if>
            "minimum_should_match": 1,
            "should": [
                {
                    "match": {
                        "standard_name.keyword": {
                            "query": "${use_question}",
                            "boost": 5,
                            "analyzer": "ngram_analyzer"
                        }
                    }
                },
                {
                    "match": {
                        "synonyms.keyword": {
                            "query": "${use_question}",
                            "boost": 10,
                            "analyzer": "ngram_analyzer"
                        }
                    }
                }
            ],
            "must_not": [
                {
                    "term": {
                        "del_flag": 1
                    }
                }
            ]
        }
    },
    "collapse": {
        "field": "entity_type",
        "inner_hits": {
            "name": "entity_collection",
            "_source": [
                "standard_name",
                "synonyms",
                "tenant_id",
                "ext_info",
                "description"
            ],
            "size": 100
        }
    },
    "size": 100
}