/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.service.permission;

import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import com.digiwin.service.permission.util.AESUtil;
import com.google.gson.Gson;
import java.time.Instant;

public final class DWSecurityTokenGenerator {
    static final long A_MINUTE = 60000L;
    static final int DEFAULT_EFFECTIVE_MINUTES = 10;

    DWSecurityTokenGenerator() {
    }

    public static String generateSecurityToken(DWSecurityContext context) throws Exception {
        return DWSecurityTokenGenerator.generateSecurityToken(context, 10);
    }

    public static String generateSecurityToken(DWSecurityContext context, int effectiveMinutes) throws Exception {
        DWSecurityToken securityToken = new DWSecurityToken();
        securityToken.setContext(context);
        securityToken.setExpirationTime(Instant.now().toEpochMilli() + (long)effectiveMinutes * 60000L);
        return AESUtil.encrypt(new Gson().toJson((Object)securityToken));
    }

    public static DWSecurityToken parseSecurityToken(String securityToken) throws Exception {
        try {
            String decryptToken = AESUtil.decrypt(securityToken);
            return (DWSecurityToken)new Gson().fromJson(decryptToken, DWSecurityToken.class);
        }
        catch (Exception e) {
            throw new Exception("\u65e0\u6548\u7684security-token\uff01");
        }
    }
}

