/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.service.permission;

import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import com.digiwin.service.permission.util.AESUtil;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONObject;

public final class DWSecurityTokenGenerator {
    static final long A_MINUTE = 60000L;
    static final int DEFAULT_EFFECTIVE_MINUTES = 10;

    DWSecurityTokenGenerator() {
    }

    public static String generateSecurityToken(DWSecurityContext context) throws Exception {
        return DWSecurityTokenGenerator.generateSecurityToken(context, 10);
    }

    public static String generateSecurityToken(DWSecurityContext context, int effectiveMinutes) throws Exception {
        DWSecurityToken securityToken = new DWSecurityToken();
        Map<String, Object> profile = context.getProfile();
        Object userSid = null;
        Object tenantSid = null;
        if (Objects.nonNull(profile)) {
            if (Objects.nonNull(profile.get("userSid"))) {
                userSid = profile.get("userSid");
                profile.put("userSid", Objects.toString(userSid));
            }
            if (Objects.nonNull(profile.get("tenantSid"))) {
                tenantSid = profile.get("tenantSid");
                profile.put("tenantSid", Objects.toString(tenantSid));
            }
        }
        securityToken.setContext(context);
        securityToken.setExpirationTime(Instant.now().toEpochMilli() + (long)effectiveMinutes * 60000L);
        String result = AESUtil.encrypt(new JSONObject((Object)securityToken).toString());
        if (Objects.nonNull(profile)) {
            if (Objects.nonNull(userSid)) {
                profile.put("userSid", userSid);
            }
            if (Objects.nonNull(tenantSid)) {
                profile.put("tenantSid", tenantSid);
            }
        }
        return result;
    }

    public static DWSecurityToken parseSecurityToken(String securityToken) throws Exception {
        try {
            String decryptToken = AESUtil.decrypt(securityToken);
            DWSecurityToken token = DWSecurityTokenGenerator.parseToken(decryptToken);
            DWSecurityContext context = token.getContext();
            Map<String, Object> profile = context.getProfile();
            if (Objects.nonNull(profile)) {
                if (Objects.nonNull(profile.get("userSid"))) {
                    profile.put("userSid", Long.parseLong(Objects.toString(profile.get("userSid"))));
                }
                if (Objects.nonNull(profile.get("tenantSid"))) {
                    profile.put("tenantSid", Long.parseLong(Objects.toString(profile.get("tenantSid"))));
                }
            }
            return token;
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6548\u7684security-token\uff01");
        }
    }

    private static DWSecurityToken parseToken(String jsonStr) throws Exception {
        JSONObject obj = new JSONObject(jsonStr);
        long expirationTime = obj.getLong("expirationTime");
        JSONObject objContext = obj.getJSONObject("context");
        String appToken = objContext.getString("appToken");
        boolean tokenVerified = objContext.getBoolean("tokenVerified");
        boolean userVerified = objContext.getBoolean("userVerified");
        JSONObject objProfile = objContext.getJSONObject("profile");
        String tenantId = objProfile.getString("tenantId");
        String tenantName = objProfile.getString("tenantName");
        Long tenantSid = objProfile.getLong("tenantSid");
        String userId = objProfile.getString("userId");
        String userName = objProfile.getString("userName");
        Long userSid = objProfile.getLong("userSid");
        HashMap<String, Object> profile = new HashMap<String, Object>();
        profile.put("tenantId", tenantId);
        profile.put("tenantName", tenantName);
        profile.put("tenantSid", tenantSid);
        profile.put("userId", userId);
        profile.put("userName", userName);
        profile.put("userSid", userSid);
        DWSecurityContext context = DWSecurityContext.getSecurityContext();
        context.remove();
        context.setAppToken(appToken);
        context.setTokenVerified(tokenVerified);
        context.setUserVerified(userVerified);
        context.setProfile(profile);
        DWSecurityToken token = new DWSecurityToken();
        token.setExpirationTime(expirationTime);
        token.setContext(context);
        return token;
    }
}

