/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.service.permission.pojo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class DWSecurityContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<DWSecurityContext> currentSecurityContext = new ThreadLocal();
    private String appToken;
    private Map<String, Object> profile;
    private boolean tokenVerified;
    private boolean userVerified;
    private boolean suspend = false;

    DWSecurityContext() {
    }

    public static DWSecurityContext getSecurityContext() {
        DWSecurityContext securityContext = currentSecurityContext.get();
        if (Objects.isNull(securityContext)) {
            securityContext = new DWSecurityContext();
            currentSecurityContext.set(securityContext);
        }
        return securityContext;
    }

    public void remove() {
        currentSecurityContext.remove();
    }

    public static void setSecurityContext(DWSecurityContext securityContext) {
        currentSecurityContext.set(securityContext);
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public Map<String, Object> getProfile() {
        return this.profile;
    }

    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public boolean isTokenVerified() {
        return this.tokenVerified;
    }

    public void setTokenVerified() {
        this.tokenVerified = true;
    }

    public void setTokenVerified(boolean tokenVerified) {
        this.tokenVerified = tokenVerified;
    }

    public boolean isUserVerified() {
        return this.userVerified;
    }

    public void setUserVerified() {
        this.userVerified = true;
    }

    public void setUserVerified(boolean userVerified) {
        this.userVerified = userVerified;
    }

    public boolean isSuspend() {
        return this.suspend;
    }

    public void suspend() {
        this.suspend = true;
    }

    public void resume() {
        this.suspend = false;
    }

    public DWSecurityContext deepClone() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ObjectOutputStream objOutput = new ObjectOutputStream(output);
        objOutput.writeObject(this);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        ObjectInputStream objInput = new ObjectInputStream(input);
        return (DWSecurityContext)objInput.readObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("appToken='").append(this.appToken).append('\'');
        sb.append(", profile=").append(this.profile);
        sb.append(", tokenVerified=").append(this.tokenVerified);
        sb.append(", userVerified=").append(this.userVerified);
        sb.append(", suspend=").append(this.suspend);
        sb.append('}');
        return sb.toString();
    }
}

