/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import com.google.testing.compile.JavaFileObjectSubjectFactory;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.Parser;
import com.google.testing.compile.TreeContext;
import com.google.testing.compile.TreeDiffer;
import com.google.testing.compile.TreeDifference;
import com.sun.source.tree.CompilationUnitTree;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.tools.JavaFileObject;

public final class JavaFileObjectSubject
extends Subject {
    private static final Subject.Factory<JavaFileObjectSubject, JavaFileObject> FACTORY = new JavaFileObjectSubjectFactory();
    private final JavaFileObject actual;

    public static Subject.Factory<JavaFileObjectSubject, JavaFileObject> javaFileObjects() {
        return FACTORY;
    }

    public static JavaFileObjectSubject assertThat(JavaFileObject actual) {
        return (JavaFileObjectSubject)Truth.assertAbout(FACTORY).that((Object)actual);
    }

    JavaFileObjectSubject(FailureMetadata failureMetadata, JavaFileObject actual) {
        super(failureMetadata, (Object)actual);
        this.actual = actual;
    }

    protected String actualCustomStringRepresentation() {
        return this.actual.toUri().getPath();
    }

    public void isEqualTo(@Nullable Object other) {
        if (!(other instanceof JavaFileObject)) {
            super.isEqualTo(other);
        }
        JavaFileObject otherFile = (JavaFileObject)other;
        try {
            if (!JavaFileObjects.asByteSource(this.actual).contentEquals(JavaFileObjects.asByteSource(otherFile))) {
                this.failWithActual("expected to be equal to", other);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void hasContents(ByteSource expected) {
        try {
            if (!JavaFileObjects.asByteSource(this.actual).contentEquals(expected)) {
                this.failWithActual("expected to have contents", expected);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StringSubject contentsAsString(Charset charset) {
        try {
            return this.check("contents()", new Object[0]).that(JavaFileObjects.asByteSource(this.actual).asCharSource(charset).read());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StringSubject contentsAsUtf8String() {
        return this.contentsAsString(StandardCharsets.UTF_8);
    }

    public void hasSourceEquivalentTo(JavaFileObject expectedSource) {
        this.performTreeDifference(expectedSource, "expected to be equivalent to", "expected", (expectedResult, actualResult) -> TreeDiffer.diffCompilationUnits((CompilationUnitTree)Iterables.getOnlyElement(expectedResult.compilationUnits()), (CompilationUnitTree)Iterables.getOnlyElement(actualResult.compilationUnits())));
    }

    public void containsElementsIn(JavaFileObject expectedPattern) {
        this.performTreeDifference(expectedPattern, "expected to contain elements in", "expected pattern", (expectedResult, actualResult) -> TreeDiffer.matchCompilationUnits((CompilationUnitTree)Iterables.getOnlyElement(expectedResult.compilationUnits()), actualResult.trees(), (CompilationUnitTree)Iterables.getOnlyElement(actualResult.compilationUnits()), expectedResult.trees()));
    }

    private void performTreeDifference(JavaFileObject expected, String failureVerb, String expectedTitle, BiFunction<Parser.ParseResult, Parser.ParseResult, TreeDifference> differencingFunction) {
        Parser.ParseResult actualResult = Parser.parse((Iterable<? extends JavaFileObject>)ImmutableList.of((Object)this.actual));
        CompilationUnitTree actualTree = (CompilationUnitTree)Iterables.getOnlyElement(actualResult.compilationUnits());
        Parser.ParseResult expectedResult = Parser.parse((Iterable<? extends JavaFileObject>)ImmutableList.of((Object)expected));
        CompilationUnitTree expectedTree = (CompilationUnitTree)Iterables.getOnlyElement(expectedResult.compilationUnits());
        TreeDifference treeDifference = differencingFunction.apply(expectedResult, actualResult);
        if (!treeDifference.isEmpty()) {
            String diffReport = treeDifference.getDiffReport(new TreeContext(expectedTree, expectedResult.trees()), new TreeContext(actualTree, actualResult.trees()));
            try {
                this.failWithoutActual(Fact.fact((String)"for file", (Object)this.actual.toUri().getPath()), new Fact[]{Fact.fact((String)failureVerb, (Object)expected.toUri().getPath()), Fact.fact((String)"diff", (Object)diffReport), Fact.fact((String)expectedTitle, (Object)expected.getCharContent(false)), Fact.fact((String)"but was", (Object)this.actual.getCharContent(false))});
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't read from JavaFileObject when it was already in memory.", e);
            }
        }
    }
}

