package com.jugg.agile.biz.digiwin.config;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaSystemProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;

import java.util.Map;

public class DwEnvPropertyHandler implements JaEnvPropertyHandler {
    @Override
    public void addAndCover() {
        if (JaEnvProperty.isCD()) {
            initEnv();
            initLmc();
        }
    }

    @Override
    public int order() {
        return -10;
    }

    private static void initLmc() {
        JaSystemProperty.putByEnv("lmc_log_endpoint", "lmc_log_endpoint", null);
        JaSystemProperty.putByEnv("lmc_log_app", "lmc_log_app", null);
    }

    private static void initEnv() {
        Map<String, String> envMap = System.getenv();
        JaProperty.getPropertyMap().putAll(envMap);
        JaEnvProperty.Entity entity = JaEnvProperty.getEntity();
        entity.setImageEnv(initImageEnv());
        entity.setImageVersion(System.getenv().get("VERSION"));
        entity.setImageName(System.getenv().get("APPIMAGENAME"));
        entity.setCdVersion(System.getenv().get("SMALLVERSION"));
        entity.setCdName(System.getenv().get("APPID"));
        entity.setPodName(System.getenv().get("HOSTNAME"));
    }

    private static String initImageEnv() {
        String cdmCloud = System.getenv().get("CDMCLOUD");
        if (JaStringUtil.isSafeNotEmpty(cdmCloud)) {
            String cdmArea = System.getenv().get("CDMAREA");
            if (JaStringUtil.isSafeNotEmpty(cdmArea)) {
                return cdmCloud.trim().toLowerCase() + "-" + cdmArea.trim().toLowerCase();
            }
        }
        return null;
    }
}
