package com.jugg.agile.biz.digiwin.config;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaPrePropertyHandler;

/**
 * 加载 nacos 所需要的配置
 *
 * @author chenjian
 * @since 2024年06月14日 17:42:12
 */
public class DwPrometheusPropertyHandler implements JaPrePropertyHandler {
    @Override
    public void addAndCover() {
        String imageName = JaEnvProperty.getEntity().getImageName();
        if (null != imageName) {
            String namespace = imageName + "-" + JaEnvProperty.getEnv() + "-" + JaEnvProperty.getVersion();
            addAndCover("management.endpoints.web.exposure.include[0]", "health");
            addAndCover("management.endpoints.web.exposure.include[1]", "prometheus");
            addAndCover("management.endpoints.web.base-path", "/" + namespace + "/actuator");
            addAndCover("management.endpoints.web.path-mapping.health", "healthcheck");
            addAndCover("management.endpoint.health.show-details", "always");


        }
    }


    @Override
    public int order() {
        return -10;
    }

}
